/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdxStatData {
    public static Map<String, Long> getStrategyStatData(String strategy, ArrayList<AdxStrategyDo> strategyDoList) {
        HashMap<String, Long> retMap = new HashMap<String, Long>();
        Long defaultCnt = 0L;
        Long defaultConsume = 0L;
        Long bidCnt = defaultCnt;
        Long sucCnt = defaultCnt;
        Long expCnt = defaultCnt;
        Long clickCnt = defaultCnt;
        Long adxConsume = defaultConsume;
        Long advertConsume = defaultConsume;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{strategy, strategyDoList})) {
            List<AdxLevelDo> strategyDo = StrategyBid.getStrategyInfo(strategyDoList, strategy);
            bidCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.BID.getCode(), defaultCnt);
            sucCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.BID_SUC.getCode(), defaultCnt);
            expCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.EXP.getCode(), defaultCnt);
            clickCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.CLICK.getCode(), defaultCnt);
            adxConsume = DataUtil.double2Long((double)(StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.ADX_CONSUME.getCode(), defaultConsume) / 1000L / 10000L), (Long)1L);
            advertConsume = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
        }
        retMap.put(AdxIndex.BID.getCode(), bidCnt);
        retMap.put(AdxIndex.BID_SUC.getCode(), sucCnt);
        retMap.put(AdxIndex.EXP.getCode(), expCnt);
        retMap.put(AdxIndex.CLICK.getCode(), clickCnt);
        retMap.put(AdxIndex.ADX_CONSUME.getCode(), adxConsume);
        retMap.put(AdxIndex.ADVERT_CONSUME.getCode(), advertConsume);
        return retMap;
    }
}

