/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxFactorExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactorExploration {
    private static final Logger logger = LoggerFactory.getLogger(FactorExploration.class);

    public static AdxFactorExplorationDo getExploreFactor(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxFactorExplorationDo ret = new AdxFactorExplorationDo();
        try {
            Double defaultFactor = 1.0;
            Double defaultMinRoi = 1.0;
            Double lowerLimit = 0.3;
            Double upperLimit = 1.7;
            Double[] stepList = new Double[]{-0.05, 0.0, 0.05};
            Double[] diffList = new Double[]{0.02, 0.05, 0.08, 0.1, 0.15, 0.2, 0.3};
            Double baseValue = defaultFactor;
            Double[] baseFlowRate = new Double[]{0.2, 0.6, 0.2};
            Double[] lastRealRoi = new Double[]{0.0, 0.0, 0.0};
            Double[] lastRealSucRate = new Double[]{0.0, 0.0, 0.0};
            HashMap<String, Double> factorMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> flowRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastRoiMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastSucRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            Long tryLabel = 0L;
            Long lastTryLabel = 0L;
            Long bidCntMs = 0L;
            Long sucBidCntMs = 0L;
            Double roiDay = 0.0;
            Double sucRateDay = 0.0;
            Double adxConsumeDay = 0.0;
            Double advertConsumeMs = 0.0;
            Long bidCntDay = 0L;
            Long sucBidCntDay = 0L;
            Double roiMs = 0.0;
            Double sucRateMs = 0.0;
            Double adxConsumeMs = 0.0;
            Double advertConsumeDay = 0.0;
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                Object uppSuc;
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                Integer feeType = adxRoiControlDoInfo.getFeeType();
                Long defaultCnt = 0L;
                Long defaultConsume = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategyThiMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_THI.getCode());
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategyThiDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_THI.getCode());
                Map<String, Double> sucRateLevelMs = StrategyBid.getLevelSucRate(strategyThiMs);
                Map<String, Long> sucCntLevelMs = StrategyBid.getLevelIndex(strategyThiMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                Map<String, Long> adxConsumeLevelMs = StrategyBid.getLevelIndex(strategyThiMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume);
                Map<String, Long> advertConsumeLevelMs = StrategyBid.getLevelIndex(strategyThiMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
                Map<String, Double> roiRealLevelMs = StrategyBid.getLevelRoi(strategyThiMs, minRoi);
                Map<String, Double> roiLevelMs = StrategyBid.getRoiFactorRectify(roiRealLevelMs, adxConsumeLevelMs, adxRoiControlDoInfo);
                roiMs = StrategyBid.getRoi(strategyThiMs, minRoi);
                sucRateMs = StrategyBid.getSucRate(strategyThiMs);
                bidCntMs = StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntMs = StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeMs = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeMs = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                roiDay = StrategyBid.getRoi(strategyThiDay, minRoi);
                sucRateDay = StrategyBid.getSucRate(strategyThiDay);
                bidCntDay = StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntDay = StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeDay = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeDay = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo, minRoi);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }
                if (bidCntMs == 0L) {
                    tryLabel = 2L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < 0.05 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < 2000000000L) {
                    tryLabel = 1L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 0.05 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 2000000000L && roiLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < minRoi * 0.95) {
                    tryLabel = 1L;
                }
                baseValue = defaultFactor;
                Double lowValue = baseValue + 0.05;
                Double uppValue = baseValue - 0.05;
                Double diff = DataUtil.division((Double)roiMs, (Double)minRoi, (int)3);
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 20L || bidCntDay == 0L) {
                    baseValue = defaultFactor;
                } else {
                    Double incre1 = 1.0;
                    AdxFactorExplorationDo lastFactorDoInfo = adxRoiControlDoInfo.getLastFactorExplorationDo();
                    if (AssertUtil.isNotEmpty((Object)lastFactorDoInfo)) {
                        Map<String, Double> lastFactorMap = lastFactorDoInfo.getFactorExploreMap();
                        String bestLevel = StrategyBid.selectBestLevel(minRoi, roiLevelMs, sucRateLevelMs);
                        lastTryLabel = lastFactorDoInfo.getTryLabel();
                        if (AssertUtil.isNotEmpty(lastFactorMap)) {
                            if (lastFactorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()) != null) {
                                baseValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode());
                                lowValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_THR.getCode());
                                uppValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_ONE.getCode());
                            }
                            if (lastFactorMap.get(bestLevel) != null) {
                                incre1 = DataUtil.division((Double)lastFactorMap.get(bestLevel), (Double)baseValue, (int)3);
                            }
                        }
                    }
                    if (tryLabel == 2L) {
                        Double baseDiff = baseValue - defaultFactor;
                        baseValue = baseValue - baseDiff * 0.2;
                    } else {
                        Double weight1 = 1.0;
                        weight1 = sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(diff < 0.6 ? 0.0 : (diff < 0.8 ? 0.5 : (diff < 0.9 ? 0.8 : 1.0)));
                        Double incre2 = 1.0;
                        if (roiMs > 0.0) {
                            incre2 = DataUtil.division((Double)(minRoi * 0.98), (Double)roiMs, (int)3);
                            if (feeType != null && feeType == 1) {
                                Double roiStable = StrategyBid.getRemainStableRoi(roiDay, roiMs, minRoi, 0.97);
                                incre2 = DataUtil.division((Double)(minRoi * 0.98), (Double)roiStable, (int)3);
                            }
                        }
                        Double weight2 = 1.0;
                        weight2 = sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(1.0);
                        Double remainStableLimit = StrategyBid.getRemainStableLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);
                        incre1 = StrategyBid.getNormalValue(incre1, 1.0, 0.9, 1.1);
                        incre2 = StrategyBid.getNormalValue(incre2, 1.0, 1.0 - remainStableLimit, 1.0 + remainStableLimit);
                        Double incre = 1.0 + (incre1 - 1.0) * weight1 * 0.5 + (incre2 - 1.0) * weight2 * 0.5;
                        if (weight1 == 0.0) {
                            incre = 1.0 + (incre2 - 1.0) * weight2;
                        }
                        Double coeff = StrategyBid.bucket(Math.abs(diff - 1.0), diffList);
                        if (tryLabel == 0L) {
                            baseValue = StrategyBid.getNormalValue(baseValue * incre, defaultFactor, baseValue * (1.0 - coeff), baseValue * (1.0 + coeff));
                        }
                        if (lastTryLabel == 1L && tryLabel == 0L) {
                            baseValue = uppValue;
                        }
                        baseValue = DataUtil.formatDouble((Double)StrategyBid.getNormalValue(baseValue, defaultFactor, lowerLimit, upperLimit), (int)6);
                    }
                }
                if (tryLabel == 2L) {
                    Double uppDiff = uppValue - defaultFactor;
                    stepList[0] = uppValue - uppDiff * 0.2 - baseValue;
                    Double lowDiff = lowValue - defaultFactor;
                    stepList[2] = lowValue - lowDiff * 0.2 - baseValue;
                } else if (tryLabel == 1L) {
                    stepList[2] = lowValue - baseValue;
                    uppSuc = DataUtil.division((Double)sucRateLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), (Double)Math.max(resoSucRateMs, 0.1), (int)3);
                    Double stepSuc = (Double)uppSuc < 0.1 ? 0.15 : ((Double)uppSuc < 0.2 ? 0.08 : ((Double)uppSuc < 0.3 ? -0.08 : -0.15));
                    Double uppDiff = DataUtil.division((Double)roiLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), (Double)minRoi, (int)3);
                    Double stepRoi = uppDiff < 0.8 ? -0.1 : (uppDiff < 0.95 ? -0.07 : (uppDiff < 1.05 ? 0.05 : (uppDiff < 1.2 ? 0.07 : 0.1)));
                    if (adxConsumeMs == 0.0) {
                        stepSuc = 0.15;
                        stepRoi = 0.15;
                    }
                    stepList[0] = uppValue - baseValue - (0.5 * stepSuc + 0.5 * stepRoi);
                } else {
                    uppSuc = stepList;
                    Double.valueOf(uppSuc[0] - (diff < 1.05 ? -0.03 : (diff < 1.1 ? -0.02 : (diff < 1.2 ? 0.0 : (diff < 1.3 ? 0.03 : 0.05)))));
                    uppSuc = stepList;
                    Double.valueOf((Double)uppSuc[2] + (diff < 0.7 ? 0.05 : (diff < 0.8 ? 0.03 : (diff < 0.9 ? 0.0 : (diff < 0.95 ? -0.02 : -0.03)))));
                }
                if (tryLabel == 2L) {
                    baseFlowRate[0] = 0.2;
                    baseFlowRate[2] = 0.2;
                } else if (tryLabel == 1L) {
                    baseFlowRate[0] = 0.2;
                    baseFlowRate[2] = 0.2;
                } else if (diff < 0.9) {
                    baseFlowRate[0] = 0.1;
                    baseFlowRate[2] = diff < 0.8 ? 0.3 : 0.2;
                } else if (diff > 1.1) {
                    baseFlowRate[0] = diff < 1.2 ? 0.2 : 0.3;
                    baseFlowRate[2] = 0.1;
                } else if (diff > 0.95 && diff < 1.05) {
                    baseFlowRate[0] = 0.1;
                    baseFlowRate[2] = 0.1;
                } else {
                    baseFlowRate[0] = 0.15;
                    baseFlowRate[2] = 0.15;
                }
                baseFlowRate[1] = DataUtil.formatDouble((Double)(1.0 - baseFlowRate[2] - baseFlowRate[0]), (int)3);
                for (int i = 1; i < AdxLevel.values().length; ++i) {
                    lastRealRoi[i - 1] = roiLevelMs.get(DataUtil.Integer2String((Integer)i));
                    lastRealSucRate[i - 1] = sucRateLevelMs.get(DataUtil.Integer2String((Integer)i));
                }
            }
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = DataUtil.toInt((Long)DataUtil.string2Long((String)key));
                Double factor = DataUtil.formatDouble((Double)StrategyBid.getNormalValue(baseValue + stepList[i - 1], defaultFactor, lowerLimit, upperLimit), (int)6);
                Double flowRate = baseFlowRate[i - 1];
                Double lastRoi = lastRealRoi[i - 1];
                Double lastSucRate = lastRealSucRate[i - 1];
                factorMap.put(key, factor);
                flowRateMap.put(key, flowRate);
                lastRoiMap.put(key, lastRoi);
                lastSucRateMap.put(key, lastSucRate);
            }
            ret.setFactorExploreMap(factorMap);
            ret.setFactorFlowRateMap(flowRateMap);
            ret.setLastRealRoiMap(lastRoiMap);
            ret.setLastSucRateMap(lastSucRateMap);
            ret.setTryLabel(tryLabel);
            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucBidCntDay(sucBidCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);
            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucBidCntMs(sucBidCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);
        }
        catch (Exception e) {
            logger.error("FactorExploration.getExploreFactor error:" + e);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setBasePrice(900.0);
            String str = "{\"adxRoiFactorDo\":{\"advertConsumeDay\":1378.0,\"advertConsumeMs\":623.0,\"adxConsumeDay\":1170.34,\"adxConsumeMs\":385.19,\"adxRoiFactor\":1.657403,\"bidCntDay\":131248,\"bidCntMs\":67085,\"lastRealRoi\":1.617393,\"roiDay\":1.177444,\"roiMs\":1.617393,\"sucBidCntDay\":21997,\"sucBidCntMs\":9412,\"sucDay\":0.167599,\"sucMs\":0.1403},\"basePrice\":0.0,\"defaultPrice\":121,\"factorExplorationDo\":{\"advertConsumeDay\":676.0,\"advertConsumeMs\":676.0,\"adxConsumeDay\":804.74,\"adxConsumeMs\":788.82,\"bidCntDay\":65021,\"bidCntMs\":65121,\"factorExploreMap\":{\"1\":0.83,\"2\":0.85,\"3\":0.95},\"factorFlowRateMap\":{\"1\":0.1,\"2\":0.6,\"3\":0.3},\"lastRealRoiMap\":{\"1\":0.707193,\"2\":0.831991,\"3\":0.873592},\"lastSucRateMap\":{\"1\":0.185569,\"2\":0.202407,\"3\":0.182051},\"roiDay\":0.840032,\"roiMs\":0.856984,\"sucBidCntDay\":12790,\"sucBidCntMs\":12803,\"sucDay\":0.196706,\"sucMs\":0.196604,\"tryLabel\":0},\"feeType\":2,\"ideaIndexMap\":{\"bidSuc\":27828,\"advertConsume\":1864,\"adxConsume\":17870700000,\"bid\":197123,\"exp\":22387,\"click\":1838},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":1378.0,\"advertConsumeMs\":623.0,\"adxConsumeDay\":1170.34,\"adxConsumeMs\":385.19,\"adxRoiFactor\":1.657403,\"bidCntDay\":131248,\"bidCntMs\":67085,\"lastRealRoi\":1.617393,\"roiDay\":1.177444,\"roiMs\":1.617393,\"sucBidCntDay\":21997,\"sucBidCntMs\":9412,\"sucDay\":0.167599,\"sucMs\":0.1403},\"lastFactorExplorationDo\":{\"advertConsumeDay\":676.0,\"advertConsumeMs\":676.0,\"adxConsumeDay\":804.74,\"adxConsumeMs\":788.82,\"bidCntDay\":65021,\"bidCntMs\":65121,\"factorExploreMap\":{\"1\":0.83,\"2\":0.85,\"3\":0.95},\"factorFlowRateMap\":{\"1\":0.1,\"2\":0.6,\"3\":0.3},\"lastRealRoiMap\":{\"1\":0.707193,\"2\":0.831991,\"3\":0.873592},\"lastSucRateMap\":{\"1\":0.185569,\"2\":0.202407,\"3\":0.182051},\"roiDay\":0.840032,\"roiMs\":0.856984,\"sucBidCntDay\":12790,\"sucBidCntMs\":12803,\"sucDay\":0.196706,\"sucMs\":0.196604,\"tryLabel\":0},\"lastMinRoi\":1.41,\"lastPriceExplorationDo\":{\"advertConsumeDay\":637.0,\"advertConsumeMs\":637.0,\"adxConsumeDay\":1322.1,\"adxConsumeMs\":1308.81,\"bidCntDay\":65092,\"bidCntMs\":65196,\"lastRealRoiMap\":{\"1\":0.478899,\"2\":0.455151,\"3\":0.404951},\"lastSucRateMap\":{\"1\":0.179697,\"2\":0.205808,\"3\":0.183466},\"priceExploreMap\":{\"1\":122,\"2\":136,\"3\":139},\"priceFlowRateMap\":{\"1\":0.3,\"2\":0.6,\"3\":0.1},\"roiDay\":0.481811,\"roiMs\":0.486703,\"sucBidCntDay\":12917,\"sucBidCntMs\":12927,\"sucDay\":0.198443,\"sucMs\":0.19828,\"tryLabel\":0},\"maxPrice\":503,\"minPrice\":50,\"minRoi\":1.41,\"priceExplorationDo\":{\"advertConsumeDay\":637.0,\"advertConsumeMs\":637.0,\"adxConsumeDay\":1322.1,\"adxConsumeMs\":1308.81,\"bidCntDay\":65092,\"bidCntMs\":65196,\"lastRealRoiMap\":{\"1\":0.478899,\"2\":0.455151,\"3\":0.404951},\"lastSucRateMap\":{\"1\":0.179697,\"2\":0.205808,\"3\":0.183466},\"priceExploreMap\":{\"1\":122,\"2\":136,\"3\":139},\"priceFlowRateMap\":{\"1\":0.3,\"2\":0.6,\"3\":0.1},\"roiDay\":0.481811,\"roiMs\":0.486703,\"sucBidCntDay\":12917,\"sucBidCntMs\":12927,\"sucDay\":0.198443,\"sucMs\":0.19828,\"tryLabel\":0},\"resourceIndexMap\":{\"bidSuc\":37197,\"advertConsume\":3159,\"adxConsume\":29123160000,\"bid\":216507,\"exp\":30466,\"click\":2889},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":22469,\"advertConsume\":1378,\"adxConsume\":11875100000,\"bid\":134818,\"exp\":18676,\"click\":1504}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":4483,\"advertConsume\":225,\"adxConsume\":4308910000,\"bid\":29601,\"exp\":3666,\"click\":280}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":14739,\"advertConsume\":829,\"adxConsume\":15215860000,\"bid\":83946,\"exp\":12109,\"click\":964}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":2783,\"advertConsume\":171,\"adxConsume\":3133020000,\"bid\":16565,\"exp\":2287,\"click\":152}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":2809,\"advertConsume\":208,\"adxConsume\":1434570000,\"bid\":16621,\"exp\":2325,\"click\":180}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":14668,\"advertConsume\":821,\"adxConsume\":9050940000,\"bid\":84370,\"exp\":12132,\"click\":984}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":4530,\"advertConsume\":300,\"adxConsume\":2065740000,\"bid\":29516,\"exp\":3697,\"click\":313}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":9463,\"advertConsume\":623,\"adxConsume\":3842370000,\"bid\":67429,\"exp\":7634,\"click\":649}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":2664,\"advertConsume\":103,\"adxConsume\":2574410000,\"bid\":19482,\"exp\":2142,\"click\":160}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":5490,\"advertConsume\":405,\"adxConsume\":5796980000,\"bid\":39006,\"exp\":4323,\"click\":347}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":932,\"advertConsume\":80,\"adxConsume\":1059600000,\"bid\":6475,\"exp\":767,\"click\":55}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":925,\"advertConsume\":156,\"adxConsume\":474660000,\"bid\":6469,\"exp\":734,\"click\":62}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":5600,\"advertConsume\":310,\"adxConsume\":2790940000,\"bid\":39569,\"exp\":4463,\"click\":393}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":2680,\"advertConsume\":187,\"adxConsume\":1234520000,\"bid\":19354,\"exp\":2146,\"click\":194}}],\"strategy\":\"3\"}]}\n";
            AdxRoiControlDo adxRoiControlDoInfo3 = (AdxRoiControlDo)JSONObject.parseObject((String)str, AdxRoiControlDo.class);
            System.out.println("lastFactorExplorationDo:" + JSON.toJSONString((Object)adxRoiControlDoInfo3.getLastFactorExplorationDo()));
            AdxFactorExplorationDo ret3 = FactorExploration.getExploreFactor(adxRoiControlDoInfo3);
            System.out.println("ret3:" + JSON.toJSONString((Object)ret3));
            System.out.println("ret3:" + JSON.toJSONString((Object)DataUtil.double2Long((double)35.0, (Long)1L)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

