/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdxStatData {
    public static Map<String, Long> getStrategyStatData(String strategy, ArrayList<AdxStrategyDo> strategyDoList) {
        HashMap<String, Long> retMap = new HashMap<String, Long>();
        Long defaultCnt = 0L;
        Long defaultConsume = 0L;
        Long bidCnt = defaultCnt;
        Long sucCnt = defaultCnt;
        Long expCnt = defaultCnt;
        Long clickCnt = defaultCnt;
        Long adxConsume = defaultConsume;
        Long advertConsume = defaultConsume;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{strategy, strategyDoList})) {
            List<AdxLevelDo> strategyDo = StrategyBid.getStrategyInfo(strategyDoList, strategy);
            bidCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.BID.getCode(), defaultCnt);
            sucCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.BID_SUC.getCode(), defaultCnt);
            expCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.EXP.getCode(), defaultCnt);
            clickCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.CLICK.getCode(), defaultCnt);
            adxConsume = DataUtil.double2Long((double)(StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.ADX_CONSUME.getCode(), defaultConsume) / 1000L / 10000L), (Long)1L);
            advertConsume = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
        }
        retMap.put(AdxIndex.BID.getCode(), bidCnt);
        retMap.put(AdxIndex.BID_SUC.getCode(), sucCnt);
        retMap.put(AdxIndex.EXP.getCode(), expCnt);
        retMap.put(AdxIndex.CLICK.getCode(), clickCnt);
        retMap.put(AdxIndex.ADX_CONSUME.getCode(), adxConsume);
        retMap.put(AdxIndex.ADVERT_CONSUME.getCode(), advertConsume);
        return retMap;
    }

    public static Double getRoi(Map<String, Long> mapInfo, Double targetRoi) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        Long defaultAdxConsume = 50L;
        if (AssertUtil.isNotEmpty(mapInfo)) {
            Long adxConsume = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.ADX_CONSUME.getCode()), defaultValue);
            Long advertConsume = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), defaultValue);
            ret = adxConsume >= defaultAdxConsume ? DataUtil.division((Long)advertConsume, (Long)adxConsume, (int)6) : DataUtil.division((Double)((double)advertConsume.longValue() + (double)defaultAdxConsume.longValue() * targetRoi), (Long)(adxConsume + defaultAdxConsume), (int)6);
        }
        return ret;
    }

    public static Map<String, Double> getFlowRateAdjust(Map<String, Double> flowRateMap, Integer ind, Double step) {
        Double defaultFlowRate;
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Double firFlowRate = defaultFlowRate = Double.valueOf(0.33);
        Double secFlowRate = defaultFlowRate;
        Double thiFlowRate = defaultFlowRate;
        if (AssertUtil.isNotEmpty(flowRateMap)) {
            firFlowRate = StrategyBid.getNormalValue(flowRateMap.get(AdxStrategy.ADX_STRATEGY_FIR.getCode()), defaultFlowRate, 0.1, 0.8);
            secFlowRate = StrategyBid.getNormalValue(flowRateMap.get(AdxStrategy.ADX_STRATEGY_SEC.getCode()), defaultFlowRate, 0.1, 0.8);
            thiFlowRate = StrategyBid.getNormalValue(flowRateMap.get(AdxStrategy.ADX_STRATEGY_THI.getCode()), defaultFlowRate, 0.1, 0.8);
        }
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ind, step})) {
            if (ind == 1) {
                firFlowRate = firFlowRate + step;
            } else if (ind == 2) {
                secFlowRate = secFlowRate + step;
            } else if (ind == 3) {
                thiFlowRate = thiFlowRate + step;
            }
        }
        retMap.put(AdxStrategy.ADX_STRATEGY_FIR.getCode(), firFlowRate);
        retMap.put(AdxStrategy.ADX_STRATEGY_SEC.getCode(), secFlowRate);
        retMap.put(AdxStrategy.ADX_STRATEGY_THI.getCode(), thiFlowRate);
        return retMap;
    }

    public static Double nullToDefault(Double value, Double defaultValue) {
        Double ret = defaultValue;
        if (value != null) {
            ret = value;
        }
        return ret;
    }

    public static Double getFlowRateScore(Map<String, Long> mapInfo) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        Long bidCntLimit = 20L;
        if (AssertUtil.isNotEmpty(mapInfo)) {
            Long bidCnt = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.BID.getCode()), defaultValue);
            Long adxConsume = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.ADX_CONSUME.getCode()), defaultValue);
            Long advertConsume = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), defaultValue);
            if (bidCnt >= bidCntLimit) {
                ret = DataUtil.division((Double)((double)advertConsume.longValue() / 1.15 - (double)adxConsume.longValue()), (Long)bidCnt) * 1000.0;
            }
        }
        return DataUtil.formatDouble((Double)ret, (int)3);
    }
}

