/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaStatDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.List;
import java.util.Map;

public class AdxIdeaBaseRcmder {
    private static long ADX_MULTIPLIER = 10000000L;
    static double[] ctrBucket = new double[]{0.5, 0.7, 0.8, 0.9, 0.95, 0.97, 1.0};
    static double[] ctrWeight = new double[]{0.5, 1.0, 2.0, 5.0, 10.0, 50.0, 100.0};
    static double[] pCpmBucket = new double[]{0.5, 0.7, 0.8, 0.9, 0.95, 0.97, 1.0};
    static double[] pCpmWeight = new double[]{0.5, 1.0, 2.0, 5.0, 10.0, 50.0, 100.0};
    static double[] pCpmBucket2 = new double[]{1.0, 1.1, 1.5, 2.0, 3.0};
    static double[] pCpmWeight2 = new double[]{100.0, 20.0, 5.0, 1.0, 0.5};
    static double[] updateDelayBucket = new double[]{60.0, 360.0, 1440.0, 4320.0};
    static double[] updateDelayWeight = new double[]{0.3, 0.5, 0.7, 1.0};

    public static Double getUpdateWeight(Double oldWeight, Double oldWeightSum, Double newWeight, Double newWeightSum, String lastUpdateTime) {
        Double ret = null;
        if (oldWeight != null) {
            Long delayMinutes = LocalDateUtil.getIntervalMinutes((String)lastUpdateTime, (DateStyle)DateStyle.YYYYMMDDHHMMSS);
            Double learnRatio = MathBase.getConfidenceWeight(delayMinutes, updateDelayBucket, updateDelayWeight, 0.3);
            Double newWeight2 = newWeight * 100.0 / newWeightSum;
            Double oldWeight2 = oldWeight * 100.0 / oldWeightSum;
            ret = (1.0 - learnRatio) * oldWeight2 + learnRatio * newWeight2;
        } else {
            ret = newWeight * 100.0 / newWeightSum;
        }
        return MathUtil.formatDouble((double)ret, (int)2);
    }

    public static Double getMergeWeight(Double minWeight, Double dayWeight, Long historyTimes, Long currentTimes, Long size, Double currentWeightRato) {
        Double ret = null;
        if (dayWeight == null && minWeight != null) {
            ret = minWeight;
        }
        if (dayWeight != null && minWeight == null) {
            ret = dayWeight;
        }
        if (dayWeight == null && minWeight == null) {
            if (currentTimes == null || currentTimes <= 5L) {
                Double limit = 10.0;
                if (historyTimes != null && historyTimes > 5L) {
                    limit = 5.0;
                }
                ret = Math.min(100.0 / (double)size.longValue(), limit);
            } else {
                ret = 1.0;
            }
        }
        if (dayWeight != null && minWeight != null) {
            ret = (1.0 - currentWeightRato) * dayWeight + currentWeightRato * minWeight;
        }
        return ret;
    }

    public static Double getIdeaWeight(AdxIdeaStatDo adxIdeaStatDo, AdxIdeaStatDo adxBestIdeaStatDo) {
        Double ret = null;
        if (adxIdeaStatDo == null || !adxIdeaStatDo.getConfidence().booleanValue() || adxBestIdeaStatDo == null) {
            return ret;
        }
        Double bestCtr = adxBestIdeaStatDo.getCtr();
        Double bestProfitEcpm = adxBestIdeaStatDo.getProfitEcpm();
        Double ideaCtr = adxIdeaStatDo.getCtr();
        Double ideaProfitEcpm = adxIdeaStatDo.getProfitEcpm();
        boolean ideaConfidence = adxIdeaStatDo.getConfidence();
        Double ctrWeight = AdxIdeaBaseRcmder.getCtrWeight(ideaCtr, bestCtr, ideaConfidence);
        Double profitCpmWeight = AdxIdeaBaseRcmder.getProfitEcpmWeight(ideaProfitEcpm, bestProfitEcpm, ideaConfidence);
        if (ctrWeight != null && profitCpmWeight != null) {
            Double newCtrWeight = MathBase.noiseSmoother(ctrWeight, 0.6 * profitCpmWeight, 1.2 * profitCpmWeight);
            ret = 0.2 * newCtrWeight + 0.8 * profitCpmWeight;
        }
        return ret;
    }

    public static Double getCtrWeight(Double ctr, Double bestCtr, boolean isConfidence) {
        Double ret = null;
        if (bestCtr != null && isConfidence && ctr != null) {
            Double ratio = DataUtil.division((Double)ctr, (Double)bestCtr, (int)3);
            ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), ctrBucket, ctrWeight);
        }
        return ret;
    }

    public static Double getProfitEcpmWeight(Double pCpm, Double bestPCpm, boolean isConfidence) {
        Double ret = null;
        if (pCpm != null && isConfidence && bestPCpm != null) {
            if (bestPCpm >= 0.0) {
                Double ratio = DataUtil.division((Double)pCpm, (Double)(bestPCpm + 1.0E-6), (int)3);
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            } else {
                Double ratio = DataUtil.division((Double)pCpm, (Double)bestPCpm, (int)3);
                ret = MathBase.getConfidenceWeight(Math.max(ratio, 1.0), pCpmBucket2, pCpmWeight2);
            }
        }
        return ret;
    }

    public static AdxIdeaStatDo getBestCtrAndProfitEcpm(List<Long> ideaList, Map<Long, AdxIdeaStatDo> adxStatDoMap) {
        AdxIdeaStatDo ret = new AdxIdeaStatDo();
        if (AssertUtil.isEmpty(adxStatDoMap)) {
            return null;
        }
        int size = ideaList.size();
        for (int i = 0; i < size; ++i) {
            Long ideaId = ideaList.get(i);
            AdxIdeaStatDo adxIdeaStatDo = adxStatDoMap.get(ideaId);
            if (adxIdeaStatDo == null || !adxIdeaStatDo.getConfidence().booleanValue()) continue;
            if (ret.getCtr() == null || ret.getCtr() < adxIdeaStatDo.getCtr()) {
                ret.setCtr(adxIdeaStatDo.getCtr());
            }
            if (ret.getProfitEcpm() != null && !(ret.getProfitEcpm() < adxIdeaStatDo.getProfitEcpm())) continue;
            ret.setProfitEcpm(adxIdeaStatDo.getProfitEcpm());
        }
        return ret;
    }

    public static void ideaStatCompute(AdxIdeaStatDo adxIdeaStatDo) {
        if (adxIdeaStatDo != null) {
            boolean isConfidence = false;
            if (DataUtil.isLarger((Long)adxIdeaStatDo.getBid(), (Long)50L) && DataUtil.isLarger((Long)adxIdeaStatDo.getBidSuc(), (Long)20L) && DataUtil.isLarger((Long)adxIdeaStatDo.getExp(), (Long)10L) && DataUtil.isLarger((Long)adxIdeaStatDo.getClick(), (Long)2L) && DataUtil.isLarger((Long)adxIdeaStatDo.getAdxConsume(), (Long)(50L * ADX_MULTIPLIER)) && DataUtil.isLarger((Long)adxIdeaStatDo.getAdvertConsume(), (Long)50L)) {
                isConfidence = true;
            }
            if (isConfidence) {
                Double roi = MathUtil.division((Long)adxIdeaStatDo.getAdvertConsume(), (Long)(adxIdeaStatDo.getAdxConsume() / ADX_MULTIPLIER), (int)3);
                Double ctr = MathUtil.division((Long)adxIdeaStatDo.getClick(), (Long)adxIdeaStatDo.getExp(), (int)4);
                Double profit = (double)adxIdeaStatDo.getAdvertConsume().longValue() / 1.15 - (double)(adxIdeaStatDo.getAdxConsume() / ADX_MULTIPLIER);
                Double pEcpm = MathUtil.division((Double)(profit * 1000.0 * AdxIdeaBaseRcmder.roiPenaltyFactor(roi)), (Long)adxIdeaStatDo.getBid(), (int)4);
                adxIdeaStatDo.setRoi(roi);
                adxIdeaStatDo.setCtr(ctr);
                adxIdeaStatDo.setProfitEcpm(pEcpm);
            }
            adxIdeaStatDo.setConfidence(isConfidence);
        }
    }

    public static double roiPenaltyFactor(Double roi) {
        double ret = 1.0;
        if (roi != null) {
            if (roi >= 1.5 && roi < 2.0) {
                ret = (1.5 + (roi - 1.5) * 0.9) / roi;
            }
            if (roi > 2.0) {
                ret = (1.95 + (roi - 2.0) * 0.8) / roi;
            }
        }
        return ret;
    }
}

