package cn.com.duiba.nezha.alg.alg.adx.rcmd;

import cn.com.duiba.nezha.alg.alg.params.AdxIdeaRcmdParam;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxResourceRcmdDo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

public class AdxIdeaRcmdAlg {

    private static final Logger logger = LoggerFactory.getLogger(AdxIdeaDQNRcmder.class);

    /**
     * 定时任务 流量分配
     *
     * @param ideaList              资源下，算法组创意集合（开启）
     * @param adxMinStatDoMap       创意统计数据 20分钟
     * @param adxDayStatDoMap       创意统计数据 3天
     * @param lastAdxResourceRcmdDo 上一次输出对象（资源位创意推荐对象）
     * @return
     */
    public static AdxResourceRcmdDo trafficAllocation(List<Long> ideaList,
                                                      Map<Long, AdxIdeaStatDo> adxMinStatDoMap,
                                                      Map<Long, AdxIdeaStatDo> adxDayStatDoMap,
                                                      AdxResourceRcmdDo lastAdxResourceRcmdDo) {
        return AdxIdeaRcmder.trafficAllocation(ideaList, adxMinStatDoMap, adxDayStatDoMap, lastAdxResourceRcmdDo);
    }

    /**
     * 创意推荐1.0
     *
     * @param validIdeaList     有效创意集合
     * @param adxResourceRcmdDo 资源位创意推荐对象
     * @return 创意
     */
    public static Long ideaRcmd(List<Long> validIdeaList, AdxResourceRcmdDo adxResourceRcmdDo) {

        return AdxIdeaRcmder.ideaRcmd(validIdeaList, adxResourceRcmdDo);
    }


    /**
     * 创意推荐2.0
     *
     * @param adxIdeaRcmdParam
     * @return
     */
    public static AdxIdeaFeatureDo ideaRcmd(AdxIdeaRcmdParam adxIdeaRcmdParam) {
        AdxIdeaFeatureDo ret = null;

        try {
            ret = AdxIdeaDQNRcmder.ideaRcmd(adxIdeaRcmdParam);

        } catch (Exception e) {
            logger.error("AdxIdeaRcmdAlg.ideaRcmd()  error " + e);
        }

        return ret;
    }


}
