/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdxStatData {
    private static long ADX_MULTIPLIER = 10000000L;

    public static Map<String, Long> getStrategyStatData(String strategy, ArrayList<AdxStrategyDo> strategyDoList) {
        HashMap<String, Long> retMap = new HashMap<String, Long>();
        Long defaultCnt = 0L;
        Long defaultConsume = 0L;
        Long bidCnt = defaultCnt;
        Long sucCnt = defaultCnt;
        Long expCnt = defaultCnt;
        Long clickCnt = defaultCnt;
        Long adxConsume = defaultConsume;
        Long advertConsume = defaultConsume;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{strategy, strategyDoList})) {
            List<AdxLevelDo> strategyDo = StrategyBid.getStrategyInfo(strategyDoList, strategy);
            bidCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.BID.getCode(), defaultCnt);
            sucCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.BID_SUC.getCode(), defaultCnt);
            expCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.EXP.getCode(), defaultCnt);
            clickCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.CLICK.getCode(), defaultCnt);
            adxConsume = DataUtil.double2Long((double)(StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.ADX_CONSUME.getCode(), defaultConsume) / ADX_MULTIPLIER), (Long)1L);
            advertConsume = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
        }
        retMap.put(AdxIndex.BID.getCode(), bidCnt);
        retMap.put(AdxIndex.BID_SUC.getCode(), sucCnt);
        retMap.put(AdxIndex.EXP.getCode(), expCnt);
        retMap.put(AdxIndex.CLICK.getCode(), clickCnt);
        retMap.put(AdxIndex.ADX_CONSUME.getCode(), adxConsume);
        retMap.put(AdxIndex.ADVERT_CONSUME.getCode(), advertConsume);
        return retMap;
    }

    public static Map<String, Long> getlevelIndexStat(String strategy, String indexLabel, ArrayList<AdxStrategyDo> strategyDoList) {
        HashMap<String, Long> retMap = new HashMap();
        Long defaultValue = 0L;
        List<AdxLevelDo> strategyDo = StrategyBid.getStrategyInfo(strategyDoList, strategy);
        retMap = StrategyBid.getLevelIndex(strategyDo, indexLabel, defaultValue);
        if (indexLabel.equals(AdxIndex.ADX_CONSUME.getCode())) {
            retMap.replaceAll((k, v) -> DataUtil.double2Long((Double)DataUtil.division((Long)v, (Long)ADX_MULTIPLIER)));
        }
        return retMap;
    }

    public static Double getRoi(Map<String, Long> mapInfo, Double targetRoi) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        Long defaultAdxConsume = 50L;
        if (AssertUtil.isNotEmpty(mapInfo)) {
            Long adxConsume = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.ADX_CONSUME.getCode()), defaultValue);
            Long advertConsume = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), defaultValue);
            ret = adxConsume >= defaultAdxConsume ? DataUtil.division((Long)advertConsume, (Long)adxConsume, (int)6) : DataUtil.division((Double)((double)advertConsume.longValue() + (double)defaultAdxConsume.longValue() * targetRoi), (Long)(adxConsume + defaultAdxConsume), (int)6);
        }
        return ret;
    }

    public static Map<String, Double> getLevelRoi(Map<String, Long> adxMap, Map<String, Long> advertMap, Double targetRoi) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Double ret = 0.0;
        Long defaultAdxConsume = 25L;
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{adxMap, advertMap})) {
                if (adxMap.get(key) >= defaultAdxConsume) {
                    ret = DataUtil.division((Long)advertMap.get(key), (Long)adxMap.get(key), (int)6);
                    retMap.put(key, ret);
                    continue;
                }
                ret = DataUtil.division((Double)((double)advertMap.get(key).longValue() + (double)defaultAdxConsume.longValue() * targetRoi), (Long)(adxMap.get(key) + defaultAdxConsume), (int)6);
                retMap.put(key, ret);
                continue;
            }
            retMap.put(key, 0.0);
        }
        return retMap;
    }

    public static Map<String, Double> getRoiFactorRectify(Map<String, Double> roiMap, Map<String, Long> adxConsumeLevelMs, AdxDirectlyFactorDo directlyFactorDoInfo) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Long adxConsumeLimit = 50L;
        Long adxConsumeBaseLimit = 25L;
        Double baseRoi = AdxStatData.nullToMinDefault(roiMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()), 0.0);
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            retMap.put(key, roiMap.get(key));
        }
        if (AssertUtil.isNotEmpty((Object)directlyFactorDoInfo)) {
            Map<String, Double> factorMap = directlyFactorDoInfo.getFactorExploreMap();
            Double baseFactor = 1.0;
            if (AssertUtil.isNotEmpty(factorMap)) {
                baseFactor = AdxStatData.nullToMinDefault(factorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()), 1.0);
            }
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode()) || !AssertUtil.isNotEmpty(adxConsumeLevelMs) || adxConsumeLevelMs.get(key) >= adxConsumeLimit || adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < adxConsumeBaseLimit) continue;
                Double diff = DataUtil.division((Double)factorMap.get(key), (Double)baseFactor);
                Double roi = baseRoi * diff;
                retMap.put(key, DataUtil.formatDouble((Double)roi, (int)6));
            }
        }
        return retMap;
    }

    public static Double getSucRate(Map<String, Long> mapInfo, Long defaultCnt) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        if (AssertUtil.isNotEmpty(mapInfo)) {
            Long bidCnt = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.BID.getCode()), defaultValue);
            Long sucCnt = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.BID_SUC.getCode()), defaultValue);
            if (bidCnt >= defaultCnt) {
                ret = AdxStatData.getNormalValue(DataUtil.division((Long)sucCnt, (Long)bidCnt, (int)6), 0.0, 0.0, 1.0);
            }
        }
        return ret;
    }

    public static Map<String, Double> getLevelSucRate(Map<String, Long> bidCntMap, Map<String, Long> sucCntMap) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Double ret = 0.0;
        Long defaultCnt = 10L;
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{bidCntMap, sucCntMap})) {
                if (bidCntMap.get(key) >= defaultCnt) {
                    ret = AdxStatData.getNormalValue(DataUtil.division((Long)sucCntMap.get(key), (Long)bidCntMap.get(key), (int)6), 0.0, 0.0, 1.0);
                    retMap.put(key, ret);
                    continue;
                }
                retMap.put(key, 0.0);
                continue;
            }
            retMap.put(key, 0.0);
        }
        return retMap;
    }

    public static Map<String, Double> getFlowRateAdjust(Map<String, Double> flowRateMap, Integer ind, Double step) {
        Double defaultFlowRate;
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Double firFlowRate = defaultFlowRate = Double.valueOf(0.33);
        Double secFlowRate = defaultFlowRate;
        Double thiFlowRate = defaultFlowRate;
        if (AssertUtil.isNotEmpty(flowRateMap)) {
            firFlowRate = AdxStatData.getNormalValue(flowRateMap.get(AdxStrategy.ADX_STRATEGY_FIR.getCode()), defaultFlowRate, 0.1, 0.8);
            secFlowRate = AdxStatData.getNormalValue(flowRateMap.get(AdxStrategy.ADX_STRATEGY_SEC.getCode()), defaultFlowRate, 0.1, 0.8);
            thiFlowRate = AdxStatData.getNormalValue(flowRateMap.get(AdxStrategy.ADX_STRATEGY_THI.getCode()), defaultFlowRate, 0.1, 0.8);
        }
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ind, step})) {
            if (ind == 1) {
                firFlowRate = firFlowRate + step;
            } else if (ind == 2) {
                secFlowRate = secFlowRate + step;
            } else if (ind == 3) {
                thiFlowRate = thiFlowRate + step;
            }
        }
        retMap.put(AdxStrategy.ADX_STRATEGY_FIR.getCode(), firFlowRate);
        retMap.put(AdxStrategy.ADX_STRATEGY_SEC.getCode(), secFlowRate);
        retMap.put(AdxStrategy.ADX_STRATEGY_THI.getCode(), thiFlowRate);
        return retMap;
    }

    public static Double nullToDefault(Double value, Double defaultValue) {
        Double ret = defaultValue;
        if (value != null) {
            ret = value;
        }
        return ret;
    }

    public static Long nullToDefault(Long value, Long defaultValue) {
        Long ret = defaultValue;
        if (value != null) {
            ret = value;
        }
        return ret;
    }

    public static Double nullToMinDefault(Double value, Double defaultValue) {
        Double ret = defaultValue;
        if (value != null && value > defaultValue) {
            ret = value;
        }
        return ret;
    }

    public static Long nullToMinDefault(Long value, Long defaultValue) {
        Long ret = defaultValue;
        if (value != null && value > defaultValue) {
            ret = value;
        }
        return ret;
    }

    public static Double getNormalValue(Double value, Double defaultValue, Double lower, Double upper) {
        Double ret = defaultValue;
        if (value != null) {
            ret = value < lower ? lower : (value > upper ? upper : value);
        }
        return ret;
    }

    public static boolean isLarger(Long value1, Long value2) {
        boolean ret = false;
        if (value1 != null && value2 != null && value1 > value2) {
            ret = true;
        }
        return ret;
    }

    public static boolean isLarger(Double value1, Double value2) {
        boolean ret = false;
        if (value1 != null && value2 != null && value1 > value2) {
            ret = true;
        }
        return ret;
    }

    public static boolean isEqual(Long value1, Long value2) {
        boolean ret = false;
        if (value1 != null && value2 != null && value1.equals(value2)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isEqual(Double value1, Double value2) {
        boolean ret = false;
        if (value1 != null && value2 != null && value1.equals(value2)) {
            ret = true;
        }
        return ret;
    }

    public static Double getFlowRateScore(Map<String, Long> mapInfo) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        Long bidCntLimit = 20L;
        if (AssertUtil.isNotEmpty(mapInfo)) {
            Long bidCnt = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.BID.getCode()), defaultValue);
            Long adxConsume = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.ADX_CONSUME.getCode()), defaultValue);
            Long advertConsume = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), defaultValue);
            if (bidCnt >= bidCntLimit) {
                ret = DataUtil.division((Double)((double)advertConsume.longValue() / 1.15 - (double)adxConsume.longValue()), (Long)bidCnt) * 1000.0;
            }
        }
        return DataUtil.formatDouble((Double)ret, (int)3);
    }

    public static Double getTryFlowRate(Double roiMsDiff, Long adxConsumeTryMs, AdxDirectlyFactorDo directlyFactorDoInfo) {
        Map<String, Double> flowRateMap;
        Double ret = 0.2;
        Double lastRate = 0.2;
        if (AssertUtil.isNotEmpty((Object)directlyFactorDoInfo) && AssertUtil.isNotEmpty(flowRateMap = directlyFactorDoInfo.getFactorFlowRateMap())) {
            lastRate = AdxStatData.getNormalValue(flowRateMap.get(AdxLevel.ADX_LEVEL_ONE.getCode()), lastRate, 0.02, 1.0);
        }
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{roiMsDiff, adxConsumeTryMs})) {
            Long adxConsumeMs = AdxStatData.nullToDefault(adxConsumeTryMs, 0L);
            Double baseRate = AdxStatData.getNormalValue(DataUtil.division((Double)100.0, (Long)adxConsumeMs) * lastRate, lastRate, 0.02, 0.8);
            ret = roiMsDiff > 0.98 ? Double.valueOf(baseRate + Math.min(DataUtil.division((Double)roiMsDiff, (Double)0.98) - 1.0, 1.0) * (1.0 - baseRate)) : (adxConsumeMs < 100L ? baseRate : (adxConsumeMs > 1000L ? Double.valueOf(baseRate * 1.5) : Double.valueOf(baseRate * 1.2)));
        }
        return AdxStatData.getNormalValue(ret, 0.2, 0.02, 1.0);
    }

    public static Double getConfidentAdxConsume(Double roi) {
        Double ret = 100.0;
        if (AssertUtil.isNotEmpty((Object)roi)) {
            ret = 100.0 + DataUtil.division((Double)(roi - 1.0), (Double)0.1499999999999999) * 100.0;
        }
        return AdxStatData.getNormalValue(ret, 100.0, 100.0, 200.0);
    }

    public static Double getTryUppStepCon(Long adxConsume, Double roi, Double limit) {
        Double ret = 0.0;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{adxConsume, roi, limit})) {
            Double confidentConsume = AdxStatData.getConfidentAdxConsume(roi);
            ret = (double)adxConsume.longValue() <= confidentConsume ? Double.valueOf((1.0 - DataUtil.division((Long)adxConsume, (Double)confidentConsume)) * limit) : Double.valueOf(Math.max(1.0 - DataUtil.division((Long)adxConsume, (Double)confidentConsume), -1.0) * limit);
        }
        return DataUtil.formatDouble((Double)AdxStatData.getNormalValue(ret, 0.0, -limit.doubleValue(), limit), (int)3);
    }

    public static String selectBestLevel(Map<String, Long> bidMap, Map<String, Long> adxMap, Map<String, Long> advertMap) {
        String ret = AdxLevel.ADX_LEVEL_TWO.getCode();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{bidMap, adxMap, advertMap})) {
            Double tmpRpm = -1000000.0;
            for (AdxLevel adxLevel : AdxLevel.values()) {
                Double profit;
                Double rpm;
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                Long bid = AdxStatData.nullToMinDefault(bidMap.get((Object)adxLevel), 0L);
                Long adx = AdxStatData.nullToMinDefault(adxMap.get((Object)adxLevel), 0L);
                Long advert = AdxStatData.nullToMinDefault(advertMap.get((Object)adxLevel), 0L);
                if (!AdxStatData.isLarger(bid, 10L) || !AdxStatData.isLarger(adx, 25L) || !AdxStatData.isLarger(advert, 25L) || !((rpm = MathUtil.division((Double)((profit = Double.valueOf((double)advert.longValue() / 1.15 - (double)adx.longValue())) * 1000.0), (Long)bid, (int)6)) > tmpRpm)) continue;
                ret = key;
                tmpRpm = rpm;
            }
        }
        return ret;
    }

    public static AdxIndexStatsDo indexStatCompute(Map<String, Long> indexStatInfo) {
        AdxIndexStatsDo ret = new AdxIndexStatsDo();
        boolean isConfident = false;
        Long bidCnt = 0L;
        Long sucCnt = 0L;
        Long expCnt = 0L;
        Long clickCnt = 0L;
        Long adxConsume = 0L;
        Long advertConsume = 0L;
        if (AssertUtil.isNotEmpty(indexStatInfo)) {
            bidCnt = AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.BID.getCode()), 0L);
            sucCnt = AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.BID_SUC.getCode()), 0L);
            expCnt = AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.EXP.getCode()), 0L);
            clickCnt = AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.CLICK.getCode()), 0L);
            adxConsume = DataUtil.double2Long((double)(AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.ADX_CONSUME.getCode()), 0L) / ADX_MULTIPLIER), (Long)1L);
            advertConsume = AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), 0L);
            if (AdxStatData.isLarger(bidCnt, 50L) && AdxStatData.isLarger(sucCnt, 20L) && AdxStatData.isLarger(expCnt, 10L) && AdxStatData.isLarger(clickCnt, 2L) && AdxStatData.isLarger(adxConsume, 50L) && AdxStatData.isLarger(advertConsume, 50L)) {
                isConfident = true;
            }
            if (isConfident) {
                Double roi = MathUtil.division((Long)advertConsume, (Long)adxConsume, (int)6);
                Double sucRate = MathUtil.division((Long)sucCnt, (Long)bidCnt, (int)6);
                Double ctr = MathUtil.division((Long)clickCnt, (Long)expCnt, (int)6);
                Double profit = (double)advertConsume.longValue() / 1.15 - (double)adxConsume.longValue();
                Double rpm = MathUtil.division((Double)(profit * 1000.0), (Long)bidCnt, (int)6);
                ret.setRoi(roi);
                ret.setRoi(sucRate);
                ret.setCtr(ctr);
                ret.setRpm(rpm);
            }
        }
        ret.setConfident(isConfident);
        ret.setBidCnt(bidCnt);
        ret.setSucCnt(sucCnt);
        ret.setExpCnt(expCnt);
        ret.setClickCnt(clickCnt);
        ret.setAdxConsume(adxConsume);
        ret.setAdvertConsume(advertConsume);
        return ret;
    }
}

