/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd;

import cn.com.duiba.nezha.alg.alg.adx.rcmd.AdxIdeaBaseRcmder;
import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxResourceRcmdDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AdxIdeaRcmder {
    private static long ADX_MULTIPLIER = 10000000L;

    public static AdxResourceRcmdDo trafficAllocation(List<Long> ideaList, Map<Long, AdxIdeaStatDo> adxMinStatDoMap, Map<Long, AdxIdeaStatDo> adxDayStatDoMap, AdxResourceRcmdDo lastAdxResourceRcmdDo) {
        AdxIdeaParamsDo adxIdeaParamsDo;
        Long ideaId2;
        int i;
        Map<Long, AdxIdeaParamsDo> ideaStatParamsMap;
        AdxResourceRcmdDo ret = lastAdxResourceRcmdDo;
        if (AssertUtil.isEmpty(ideaList)) {
            return ret;
        }
        if (ret == null) {
            ret = new AdxResourceRcmdDo();
        }
        if (ret.getIdeaParamsMap() == null) {
            ret.setIdeaParamsMap(new HashMap<Long, AdxIdeaParamsDo>());
        }
        if (AssertUtil.isNotEmpty(ideaStatParamsMap = ret.getIdeaParamsMap())) {
            Iterator<Map.Entry<Long, AdxIdeaParamsDo>> it = ideaStatParamsMap.entrySet().iterator();
            while (it.hasNext()) {
                Long delayMinutes;
                Map.Entry<Long, AdxIdeaParamsDo> entry = it.next();
                Long ideaId3 = entry.getKey();
                AdxIdeaParamsDo parmasDo = entry.getValue();
                String lastUpdateTime = parmasDo.getLastUpdateTime();
                if (lastUpdateTime == null || (delayMinutes = LocalDateUtil.getIntervalMinutes((String)lastUpdateTime, (DateStyle)DateStyle.YYYYMMDDHHMMSS)) == null || delayMinutes <= 10080L) continue;
                it.remove();
            }
        }
        if (AssertUtil.isNotEmpty(adxMinStatDoMap)) {
            adxMinStatDoMap.forEach((ideaId, adxStatDo) -> AdxIdeaBaseRcmder.ideaStatCompute(adxStatDo));
        }
        if (AssertUtil.isNotEmpty(adxDayStatDoMap)) {
            adxDayStatDoMap.forEach((ideaId, adxStatDo) -> AdxIdeaBaseRcmder.ideaStatCompute(adxStatDo));
        }
        AdxIdeaStatDo bestAdxMinIdeaStatDo = AdxIdeaBaseRcmder.getBestCtrAndProfitEcpm(ideaList, adxMinStatDoMap);
        AdxIdeaStatDo bestAdxDayIdeaStatDo = AdxIdeaBaseRcmder.getBestCtrAndProfitEcpm(ideaList, adxDayStatDoMap);
        if (bestAdxMinIdeaStatDo == null || bestAdxMinIdeaStatDo.getCtr() == null) {
            return ret;
        }
        System.out.println(4);
        HashMap<Long, Double> newWeightMap = new HashMap<Long, Double>();
        Double oldWeightSum = 0.0;
        Double newWeightSum = 0.0;
        int size = ideaList.size();
        for (i = 0; i < size; ++i) {
            ideaId2 = ideaList.get(i);
            adxIdeaParamsDo = ret.getIdeaParamsMap().get(ideaId2);
            if (adxIdeaParamsDo == null) {
                adxIdeaParamsDo = new AdxIdeaParamsDo();
                adxIdeaParamsDo.setIdeaId(ideaId2);
                adxIdeaParamsDo.setGiveUpRatio(0.0);
                ret.getIdeaParamsMap().put(ideaId2, adxIdeaParamsDo);
            }
            AdxIdeaStatDo adxDayIdeaStatDo = adxDayStatDoMap.get(ideaId2);
            AdxIdeaStatDo adxMinIdeaStatDo = adxMinStatDoMap.get(ideaId2);
            AdxIdeaBaseRcmder.updateHistoryRpm(adxIdeaParamsDo, adxMinIdeaStatDo);
            adxIdeaParamsDo.setFused(false);
            Double dayWeight = AdxIdeaBaseRcmder.getIdeaWeight(adxDayIdeaStatDo, bestAdxDayIdeaStatDo);
            Double minWeight = AdxIdeaBaseRcmder.getIdeaWeight(adxMinIdeaStatDo, bestAdxMinIdeaStatDo);
            Double currentMergeRatio = 0.5;
            if (adxMinIdeaStatDo != null && adxMinIdeaStatDo.getConfidence().booleanValue()) {
                currentMergeRatio = 0.5 + 0.4 * Math.min((double)(adxMinIdeaStatDo.getAdvertConsume() / 500L), 1.0);
            }
            Double newWeight = AdxIdeaBaseRcmder.getMergeWeight(minWeight, dayWeight, adxIdeaParamsDo.getHistoryTimes(), adxIdeaParamsDo.getCurrentTimes(), (long)size + 0L, currentMergeRatio);
            if (adxDayIdeaStatDo != null && adxDayIdeaStatDo.getBid() != null && adxDayIdeaStatDo.getBid() > 10000L) {
                if (adxDayIdeaStatDo.getExp() == null || adxDayIdeaStatDo.getExp() == 0L) {
                    adxIdeaParamsDo.setFused(true);
                    newWeight = 0.01;
                }
                if (adxDayIdeaStatDo.getExp() != null && adxDayIdeaStatDo.getExp() > 2000L && adxDayIdeaStatDo.getRoi() != null && adxDayIdeaStatDo.getRoi() < 1.05 && (newWeight == null || newWeight <= 0.99)) {
                    adxIdeaParamsDo.setFused(true);
                }
            }
            adxIdeaParamsDo.setCurrentRoi(null);
            Double giveUpLearnRatio = 0.3;
            if (adxMinIdeaStatDo != null && adxMinIdeaStatDo.getConfidence().booleanValue()) {
                adxIdeaParamsDo.setCurrentRoi(adxMinIdeaStatDo.getRoi());
                Double adxConsume = 0.0 + (double)(adxMinIdeaStatDo.getAdxConsume() / ADX_MULTIPLIER);
                Double newGiveUpRatio = adxIdeaParamsDo.getGiveUpRatio();
                if (newGiveUpRatio == null) {
                    newGiveUpRatio = 0.0;
                }
                if (adxMinIdeaStatDo.getRoi() > 1.05) {
                    newGiveUpRatio = 0.0;
                }
                if (adxMinIdeaStatDo.getRoi() < 1.05) {
                    if (newGiveUpRatio < 0.05 && adxConsume > 400.0) {
                        newGiveUpRatio = 0.05;
                    }
                    Double pc = MathBase.noiseSmoother(adxConsume / 400.0, 0.5, 2.0);
                    newGiveUpRatio = newGiveUpRatio * (1.0 - giveUpLearnRatio + giveUpLearnRatio * pc);
                }
                newGiveUpRatio = MathBase.noiseSmoother(newGiveUpRatio, 0.0, 0.8);
                adxIdeaParamsDo.setGiveUpRatio(newGiveUpRatio);
            }
            newWeightMap.put(ideaId2, newWeight);
            newWeightSum = newWeightSum + newWeight;
            oldWeightSum = oldWeightSum + (Double)DataUtil.getValueOrDefault((Object)adxIdeaParamsDo.getWeight(), (Object)0.0);
        }
        System.out.println(6);
        size = ideaList.size();
        for (i = 0; i < size; ++i) {
            ideaId2 = ideaList.get(i);
            adxIdeaParamsDo = ret.getIdeaParamsMap().get(ideaId2);
            Double finalWeight = AdxIdeaBaseRcmder.getUpdateWeight(adxIdeaParamsDo.getWeight(), oldWeightSum, (Double)newWeightMap.get(ideaId2), newWeightSum, adxIdeaParamsDo.getLastUpdateTime());
            adxIdeaParamsDo.setWeight(finalWeight);
            adxIdeaParamsDo.setLastUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYYMMDDHHMMSS));
            adxIdeaParamsDo.setCurrentTimes(DataUtil.addLong((Long)adxIdeaParamsDo.getCurrentTimes(), (Long)1L));
            adxIdeaParamsDo.setHistoryTimes(DataUtil.addLong((Long)adxIdeaParamsDo.getHistoryTimes(), (Long)1L));
            if (adxIdeaParamsDo.isFused() == null || !adxIdeaParamsDo.isFused().booleanValue()) continue;
            adxIdeaParamsDo.setCurrentTimes(0L);
            adxIdeaParamsDo.setWeight((Double)DataUtil.getValueOrDefault((Object)adxIdeaParamsDo.getWeight(), (Object)0.1) * 0.1);
        }
        return ret;
    }

    public static Long ideaRcmd(List<Long> validIdeaList, AdxResourceRcmdDo adxResourceRcmdDo) {
        Long ret = null;
        if (AssertUtil.isEmpty(validIdeaList)) {
            return ret;
        }
        if (adxResourceRcmdDo == null) {
            adxResourceRcmdDo = new AdxResourceRcmdDo();
            adxResourceRcmdDo.setIdeaParamsMap(new HashMap<Long, AdxIdeaParamsDo>());
        }
        HashMap<Long, Double> map = new HashMap<Long, Double>();
        HashMap<Long, Double> mapWithGiveUp = new HashMap<Long, Double>();
        int size = validIdeaList.size();
        for (int i = 0; i < size; ++i) {
            Long ideaId = validIdeaList.get(i);
            AdxIdeaParamsDo adxIdeaParamsDo = adxResourceRcmdDo.getIdeaParamsMap().get(ideaId);
            if (adxIdeaParamsDo == null || adxIdeaParamsDo.getWeight() == null) {
                map.put(ideaId, 1.0);
                mapWithGiveUp.put(ideaId, 1.0);
                continue;
            }
            if (adxIdeaParamsDo.isFused() == null || !adxIdeaParamsDo.isFused().booleanValue()) {
                map.put(ideaId, adxIdeaParamsDo.getWeight());
                if (adxIdeaParamsDo.getGiveUpRatio() != null && adxIdeaParamsDo.getGiveUpRatio() >= 0.0 && Math.random() > adxIdeaParamsDo.getGiveUpRatio()) {
                    mapWithGiveUp.put(ideaId, adxIdeaParamsDo.getWeight());
                }
                if (adxIdeaParamsDo.getGiveUpRatio() == null) {
                    mapWithGiveUp.put(ideaId, adxIdeaParamsDo.getWeight());
                }
            }
            if (adxIdeaParamsDo.isFused() == null || !adxIdeaParamsDo.isFused().booleanValue() || !(Math.random() > 0.9)) continue;
            mapWithGiveUp.put(ideaId, adxIdeaParamsDo.getWeight());
        }
        ret = (Long)Roulette.doubleMap(mapWithGiveUp);
        return ret;
    }
}

