/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.correct.IsotonicCalibrator;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;

public class CvrCalibrator {
    public static void calibrate(AdBidParamsDo adBidParamsDo, IsotonicCalibrator calibrator, Double preCvr) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{adBidParamsDo, calibrator, preCvr})) {
            return;
        }
        Double lowerBound = calibrator.getLowerBound();
        Double upperBound = calibrator.getUpperBound();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{lowerBound, upperBound})) {
            return;
        }
        double rawCaliFactor = calibrator.calibrate(preCvr);
        double caliFactor = MathUtil.stdwithBoundary((double)rawCaliFactor, (double)lowerBound, (double)upperBound);
        Long fee = adBidParamsDo.getFee();
        Long feeNew = Math.round((double)fee.longValue() * caliFactor);
        adBidParamsDo.setFee(feeNew);
        adBidParamsDo.setCaliFee(feeNew);
        adBidParamsDo.setRawCaliFactor(MathUtil.formatDouble((double)rawCaliFactor, (int)5));
        adBidParamsDo.setCaliFactor(MathUtil.formatDouble((double)caliFactor, (int)5));
        adBidParamsDo.setFactor(MathUtil.formatDouble((double)(caliFactor * adBidParamsDo.getFactor()), (int)5));
        adBidParamsDo.setCaliDim(calibrator.getDim());
        adBidParamsDo.setCaliTime(calibrator.getUpdateTime());
    }
}

