/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.advert.v2;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.ee.AdExploreModel;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidJichengStrategy {
    private static final Logger log = LoggerFactory.getLogger(BidJichengStrategy.class);

    public static void main(String[] args) {
    }

    public static void jichengExplore(Map<String, AdBidResultDo> controlResultMap, Map<Long, AdExploreModel> adEEModelMap) {
        ArrayList<AdBidResultDo> adBidResultDoList = new ArrayList<AdBidResultDo>();
        for (Map.Entry<String, AdBidResultDo> entry : controlResultMap.entrySet()) {
            adBidResultDoList.add(entry.getValue());
            BidJichengStrategy.scoreUpdate(entry.getValue());
            BidJichengStrategy.jichengInfoUpdate(entry.getValue(), adEEModelMap);
        }
        Collections.sort(adBidResultDoList);
        AdBidResultDo top1 = (AdBidResultDo)adBidResultDoList.get(0);
        BidJichengStrategy.jichengExplore(top1, controlResultMap, adEEModelMap);
    }

    public static void jichengExplore(AdBidResultDo top1, Map<String, AdBidResultDo> controlResultMap, Map<Long, AdExploreModel> adEEModelMap) {
        boolean jichengStatus = false;
        if (top1.getIsHighQualityAd() != null && top1.getIsHighQualityAd().booleanValue() && top1.getJcRatio() != null && Math.random() < top1.getJcRatio()) {
            jichengStatus = true;
        }
        if (!jichengStatus) {
            return;
        }
        Long top1AdvertId = top1.getAdvertId();
        Long topAccount = top1.getAccountId();
        Double topEcpm = top1.getEcpm();
        ArrayList<AdBidResultDo> jichengList = new ArrayList<AdBidResultDo>();
        for (Map.Entry<String, AdBidResultDo> entry : controlResultMap.entrySet()) {
            AdBidResultDo adBidResultDo = entry.getValue();
            if (!BidJichengStrategy.jichengValid(top1AdvertId, topAccount, adBidResultDo)) continue;
            jichengList.add(adBidResultDo);
        }
        BidJichengStrategy.jichengControl(topEcpm, jichengList);
    }

    public static void jichengControl(Double topEcpm, List<AdBidResultDo> jichengList) {
        if (AssertUtil.isEmpty(jichengList)) {
            return;
        }
        Random random = new Random();
        int rand = random.nextInt(jichengList.size());
        AdBidResultDo adBidResultDo = jichengList.get(rand);
        Double ecpm = adBidResultDo.getEcpm();
        Long fee = adBidResultDo.getFee();
        long feeNew = Math.round(topEcpm / ecpm * (double)fee.longValue()) + 1L;
        adBidResultDo.setFee(feeNew);
        adBidResultDo.setJichengSuc(true);
        adBidResultDo.getAdBidParamsDo().setFee(feeNew);
        adBidResultDo.getAdBidParamsDo().setJcFee(feeNew);
        adBidResultDo.getAdBidParamsDo().setJichengSuc(true);
    }

    public static boolean jichengValid(Long topAd, Long topAccount, AdBidResultDo adBidResultDo) {
        boolean ret = false;
        if (adBidResultDo.getIsJiCheng() != null && adBidResultDo.getIsJiCheng().booleanValue() && topAccount.equals(adBidResultDo.getAccountId()) && !topAd.equals(adBidResultDo.getAdvertId()) && adBidResultDo.getChargeType() == 2) {
            ret = true;
        }
        return ret;
    }

    public static void jichengInfoUpdate(AdBidResultDo adBidResultDo, Map<Long, AdExploreModel> adEEModelMap) {
        Long advertId = adBidResultDo.getAdvertId();
        AdExploreModel adExploreModel = adEEModelMap.get(advertId);
        if (adExploreModel == null) {
            return;
        }
        Boolean isJiCheng = adExploreModel.getIsJiCheng();
        Boolean isHighQualityAd = adExploreModel.getIsHighQualityAd();
        Double jcRatio = adExploreModel.getJcRatio();
        adBidResultDo.setIsJiCheng(isJiCheng);
        adBidResultDo.setIsHighQualityAd(isHighQualityAd);
        adBidResultDo.setJcRatio(jcRatio);
    }

    public static void scoreUpdate(AdBidResultDo adBidResultDo) {
        Double score = adBidResultDo.getCtr() * (double)adBidResultDo.getFee().longValue();
        adBidResultDo.setScore(score);
        adBidResultDo.setEcpm(score);
    }
}

