/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import java.util.List;
import java.util.Optional;

public class IdeaUnitDo {
    private Long ideaUnitId;
    private Long adIdeaId;
    private List<Long> materialIds;
    private Integer ratioType;
    private Long type;
    private Double price;
    private Double preCtr;
    private Double statCtr;
    private Double ctr;
    private Double preLaunchPv;
    private Double statLaunchPv;
    private Double launchPv;
    private Double arpu;
    private Double preArpu;
    private AdxStatsDo adxStatsDo;
    private Double adEcpm;
    private Boolean isNew = true;
    private Long lt7DExp;
    private Long lt7DAdCost;
    private Long lt1DExp;
    private Long lt1DAdCost;

    public static Double getStatEcpm(IdeaUnitDo ideaUnitDo) {
        Double ret = null;
        if (ideaUnitDo != null) {
            AdxStatsDo adxStatsDo = Optional.ofNullable(ideaUnitDo.getAdxStatsDo()).orElse(new AdxStatsDo());
            AdxIndexStatDo last1DayStat = adxStatsDo.getLast1DayStat();
            ret = AdxIndexStatDo.getStatEcpm(last1DayStat);
        }
        if (ret == null) {
            ret = 10000.0;
        }
        return ret;
    }

    public static boolean getNewStatus(IdeaUnitDo ideaUnitDo) {
        ideaUnitDo = Optional.ofNullable(ideaUnitDo).orElse(new IdeaUnitDo());
        AdxStatsDo adxStatsDo = Optional.ofNullable(ideaUnitDo.getAdxStatsDo()).orElse(new AdxStatsDo());
        AdxIndexStatDo last1DayStat = adxStatsDo.getLast1DayStat();
        AdxIndexStatDo last7DayStat = adxStatsDo.getLast7DayStat();
        Long last1DayExp = AdxIndexStatDo.getExpCnt(last1DayStat);
        Long last7DayExp = AdxIndexStatDo.getExpCnt(last7DayStat);
        Long last1DayAdxCost = AdxIndexStatDo.getAdxCost(last1DayStat);
        Long last7DayAdxCost = AdxIndexStatDo.getAdxCost(last7DayStat);
        if (last7DayAdxCost > 10000L || last7DayExp > 5000L) {
            return false;
        }
        return last1DayAdxCost <= 5000L && last1DayExp <= 2000L;
    }

    public static boolean getNewStatus(AdxStatsDo ideaUnitDto, AdxStatsDo resoDto) {
        ideaUnitDto = Optional.ofNullable(ideaUnitDto).orElse(new AdxStatsDo());
        resoDto = Optional.ofNullable(resoDto).orElse(new AdxStatsDo());
        AdxIndexStatDo ideaUnit7DayStat = ideaUnitDto.getLast7DayStat();
        AdxIndexStatDo reso7DayStat = resoDto.getLast7DayStat();
        Long ideaUnit7DayExp = AdxIndexStatDo.getExpCnt(ideaUnit7DayStat);
        Long ideaUnit7DayAdxCost = AdxIndexStatDo.getAdxCost(ideaUnit7DayStat);
        Long reso7DayExp = AdxIndexStatDo.getExpCnt(reso7DayStat);
        Long reso7DayAdxCost = AdxIndexStatDo.getAdxCost(reso7DayStat);
        if (ideaUnit7DayExp > 5000L || ideaUnit7DayAdxCost > 5000L) {
            return false;
        }
        return reso7DayExp <= 3000L && reso7DayAdxCost <= 3000L;
    }

    public static Long countExpCnt(IdeaUnitDo ideaUnitDo, int timeType) {
        ideaUnitDo = Optional.ofNullable(ideaUnitDo).orElse(new IdeaUnitDo());
        AdxStatsDo adxStatsDo = Optional.ofNullable(ideaUnitDo.getAdxStatsDo()).orElse(new AdxStatsDo());
        return AdxStatsDo.getExpCnt(adxStatsDo, timeType);
    }

    public static Long countAdCost(IdeaUnitDo ideaUnitDo, int timeType) {
        ideaUnitDo = Optional.ofNullable(ideaUnitDo).orElse(new IdeaUnitDo());
        AdxStatsDo adxStatsDo = Optional.ofNullable(ideaUnitDo.getAdxStatsDo()).orElse(new AdxStatsDo());
        return AdxStatsDo.getAdCost(adxStatsDo, timeType);
    }

    public static Double mergeStatAdEcpm(IdeaUnitDo ideaUnitDo, long limit, int mergeType) {
        ideaUnitDo = Optional.ofNullable(ideaUnitDo).orElse(new IdeaUnitDo());
        AdxStatsDo adxStatsDo = Optional.ofNullable(ideaUnitDo.getAdxStatsDo()).orElse(new AdxStatsDo());
        return AdxStatsDo.mergeStatAdEcpm(adxStatsDo, limit, mergeType);
    }

    public Long getIdeaUnitId() {
        return this.ideaUnitId;
    }

    public Long getAdIdeaId() {
        return this.adIdeaId;
    }

    public List<Long> getMaterialIds() {
        return this.materialIds;
    }

    public Integer getRatioType() {
        return this.ratioType;
    }

    public Long getType() {
        return this.type;
    }

    public Double getPrice() {
        return this.price;
    }

    public Double getPreCtr() {
        return this.preCtr;
    }

    public Double getStatCtr() {
        return this.statCtr;
    }

    public Double getCtr() {
        return this.ctr;
    }

    public Double getPreLaunchPv() {
        return this.preLaunchPv;
    }

    public Double getStatLaunchPv() {
        return this.statLaunchPv;
    }

    public Double getLaunchPv() {
        return this.launchPv;
    }

    public Double getArpu() {
        return this.arpu;
    }

    public Double getPreArpu() {
        return this.preArpu;
    }

    public AdxStatsDo getAdxStatsDo() {
        return this.adxStatsDo;
    }

    public Double getAdEcpm() {
        return this.adEcpm;
    }

    public Boolean getIsNew() {
        return this.isNew;
    }

    public Long getLt7DExp() {
        return this.lt7DExp;
    }

    public Long getLt7DAdCost() {
        return this.lt7DAdCost;
    }

    public Long getLt1DExp() {
        return this.lt1DExp;
    }

    public Long getLt1DAdCost() {
        return this.lt1DAdCost;
    }

    public void setIdeaUnitId(Long ideaUnitId) {
        this.ideaUnitId = ideaUnitId;
    }

    public void setAdIdeaId(Long adIdeaId) {
        this.adIdeaId = adIdeaId;
    }

    public void setMaterialIds(List<Long> materialIds) {
        this.materialIds = materialIds;
    }

    public void setRatioType(Integer ratioType) {
        this.ratioType = ratioType;
    }

    public void setType(Long type) {
        this.type = type;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public void setPreCtr(Double preCtr) {
        this.preCtr = preCtr;
    }

    public void setStatCtr(Double statCtr) {
        this.statCtr = statCtr;
    }

    public void setCtr(Double ctr) {
        this.ctr = ctr;
    }

    public void setPreLaunchPv(Double preLaunchPv) {
        this.preLaunchPv = preLaunchPv;
    }

    public void setStatLaunchPv(Double statLaunchPv) {
        this.statLaunchPv = statLaunchPv;
    }

    public void setLaunchPv(Double launchPv) {
        this.launchPv = launchPv;
    }

    public void setArpu(Double arpu) {
        this.arpu = arpu;
    }

    public void setPreArpu(Double preArpu) {
        this.preArpu = preArpu;
    }

    public void setAdxStatsDo(AdxStatsDo adxStatsDo) {
        this.adxStatsDo = adxStatsDo;
    }

    public void setAdEcpm(Double adEcpm) {
        this.adEcpm = adEcpm;
    }

    public void setIsNew(Boolean isNew) {
        this.isNew = isNew;
    }

    public void setLt7DExp(Long lt7DExp) {
        this.lt7DExp = lt7DExp;
    }

    public void setLt7DAdCost(Long lt7DAdCost) {
        this.lt7DAdCost = lt7DAdCost;
    }

    public void setLt1DExp(Long lt1DExp) {
        this.lt1DExp = lt1DExp;
    }

    public void setLt1DAdCost(Long lt1DAdCost) {
        this.lt1DAdCost = lt1DAdCost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdeaUnitDo)) {
            return false;
        }
        IdeaUnitDo other = (IdeaUnitDo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$ideaUnitId = this.getIdeaUnitId();
        Long other$ideaUnitId = other.getIdeaUnitId();
        if (this$ideaUnitId == null ? other$ideaUnitId != null : !((Object)this$ideaUnitId).equals(other$ideaUnitId)) {
            return false;
        }
        Long this$adIdeaId = this.getAdIdeaId();
        Long other$adIdeaId = other.getAdIdeaId();
        if (this$adIdeaId == null ? other$adIdeaId != null : !((Object)this$adIdeaId).equals(other$adIdeaId)) {
            return false;
        }
        List<Long> this$materialIds = this.getMaterialIds();
        List<Long> other$materialIds = other.getMaterialIds();
        if (this$materialIds == null ? other$materialIds != null : !((Object)this$materialIds).equals(other$materialIds)) {
            return false;
        }
        Integer this$ratioType = this.getRatioType();
        Integer other$ratioType = other.getRatioType();
        if (this$ratioType == null ? other$ratioType != null : !((Object)this$ratioType).equals(other$ratioType)) {
            return false;
        }
        Long this$type = this.getType();
        Long other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Double this$price = this.getPrice();
        Double other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        Double this$preCtr = this.getPreCtr();
        Double other$preCtr = other.getPreCtr();
        if (this$preCtr == null ? other$preCtr != null : !((Object)this$preCtr).equals(other$preCtr)) {
            return false;
        }
        Double this$statCtr = this.getStatCtr();
        Double other$statCtr = other.getStatCtr();
        if (this$statCtr == null ? other$statCtr != null : !((Object)this$statCtr).equals(other$statCtr)) {
            return false;
        }
        Double this$ctr = this.getCtr();
        Double other$ctr = other.getCtr();
        if (this$ctr == null ? other$ctr != null : !((Object)this$ctr).equals(other$ctr)) {
            return false;
        }
        Double this$preLaunchPv = this.getPreLaunchPv();
        Double other$preLaunchPv = other.getPreLaunchPv();
        if (this$preLaunchPv == null ? other$preLaunchPv != null : !((Object)this$preLaunchPv).equals(other$preLaunchPv)) {
            return false;
        }
        Double this$statLaunchPv = this.getStatLaunchPv();
        Double other$statLaunchPv = other.getStatLaunchPv();
        if (this$statLaunchPv == null ? other$statLaunchPv != null : !((Object)this$statLaunchPv).equals(other$statLaunchPv)) {
            return false;
        }
        Double this$launchPv = this.getLaunchPv();
        Double other$launchPv = other.getLaunchPv();
        if (this$launchPv == null ? other$launchPv != null : !((Object)this$launchPv).equals(other$launchPv)) {
            return false;
        }
        Double this$arpu = this.getArpu();
        Double other$arpu = other.getArpu();
        if (this$arpu == null ? other$arpu != null : !((Object)this$arpu).equals(other$arpu)) {
            return false;
        }
        Double this$preArpu = this.getPreArpu();
        Double other$preArpu = other.getPreArpu();
        if (this$preArpu == null ? other$preArpu != null : !((Object)this$preArpu).equals(other$preArpu)) {
            return false;
        }
        AdxStatsDo this$adxStatsDo = this.getAdxStatsDo();
        AdxStatsDo other$adxStatsDo = other.getAdxStatsDo();
        if (this$adxStatsDo == null ? other$adxStatsDo != null : !((Object)this$adxStatsDo).equals(other$adxStatsDo)) {
            return false;
        }
        Double this$adEcpm = this.getAdEcpm();
        Double other$adEcpm = other.getAdEcpm();
        if (this$adEcpm == null ? other$adEcpm != null : !((Object)this$adEcpm).equals(other$adEcpm)) {
            return false;
        }
        Boolean this$isNew = this.getIsNew();
        Boolean other$isNew = other.getIsNew();
        if (this$isNew == null ? other$isNew != null : !((Object)this$isNew).equals(other$isNew)) {
            return false;
        }
        Long this$lt7DExp = this.getLt7DExp();
        Long other$lt7DExp = other.getLt7DExp();
        if (this$lt7DExp == null ? other$lt7DExp != null : !((Object)this$lt7DExp).equals(other$lt7DExp)) {
            return false;
        }
        Long this$lt7DAdCost = this.getLt7DAdCost();
        Long other$lt7DAdCost = other.getLt7DAdCost();
        if (this$lt7DAdCost == null ? other$lt7DAdCost != null : !((Object)this$lt7DAdCost).equals(other$lt7DAdCost)) {
            return false;
        }
        Long this$lt1DExp = this.getLt1DExp();
        Long other$lt1DExp = other.getLt1DExp();
        if (this$lt1DExp == null ? other$lt1DExp != null : !((Object)this$lt1DExp).equals(other$lt1DExp)) {
            return false;
        }
        Long this$lt1DAdCost = this.getLt1DAdCost();
        Long other$lt1DAdCost = other.getLt1DAdCost();
        return !(this$lt1DAdCost == null ? other$lt1DAdCost != null : !((Object)this$lt1DAdCost).equals(other$lt1DAdCost));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IdeaUnitDo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $ideaUnitId = this.getIdeaUnitId();
        result = result * 59 + ($ideaUnitId == null ? 43 : ((Object)$ideaUnitId).hashCode());
        Long $adIdeaId = this.getAdIdeaId();
        result = result * 59 + ($adIdeaId == null ? 43 : ((Object)$adIdeaId).hashCode());
        List<Long> $materialIds = this.getMaterialIds();
        result = result * 59 + ($materialIds == null ? 43 : ((Object)$materialIds).hashCode());
        Integer $ratioType = this.getRatioType();
        result = result * 59 + ($ratioType == null ? 43 : ((Object)$ratioType).hashCode());
        Long $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Double $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        Double $preCtr = this.getPreCtr();
        result = result * 59 + ($preCtr == null ? 43 : ((Object)$preCtr).hashCode());
        Double $statCtr = this.getStatCtr();
        result = result * 59 + ($statCtr == null ? 43 : ((Object)$statCtr).hashCode());
        Double $ctr = this.getCtr();
        result = result * 59 + ($ctr == null ? 43 : ((Object)$ctr).hashCode());
        Double $preLaunchPv = this.getPreLaunchPv();
        result = result * 59 + ($preLaunchPv == null ? 43 : ((Object)$preLaunchPv).hashCode());
        Double $statLaunchPv = this.getStatLaunchPv();
        result = result * 59 + ($statLaunchPv == null ? 43 : ((Object)$statLaunchPv).hashCode());
        Double $launchPv = this.getLaunchPv();
        result = result * 59 + ($launchPv == null ? 43 : ((Object)$launchPv).hashCode());
        Double $arpu = this.getArpu();
        result = result * 59 + ($arpu == null ? 43 : ((Object)$arpu).hashCode());
        Double $preArpu = this.getPreArpu();
        result = result * 59 + ($preArpu == null ? 43 : ((Object)$preArpu).hashCode());
        AdxStatsDo $adxStatsDo = this.getAdxStatsDo();
        result = result * 59 + ($adxStatsDo == null ? 43 : ((Object)$adxStatsDo).hashCode());
        Double $adEcpm = this.getAdEcpm();
        result = result * 59 + ($adEcpm == null ? 43 : ((Object)$adEcpm).hashCode());
        Boolean $isNew = this.getIsNew();
        result = result * 59 + ($isNew == null ? 43 : ((Object)$isNew).hashCode());
        Long $lt7DExp = this.getLt7DExp();
        result = result * 59 + ($lt7DExp == null ? 43 : ((Object)$lt7DExp).hashCode());
        Long $lt7DAdCost = this.getLt7DAdCost();
        result = result * 59 + ($lt7DAdCost == null ? 43 : ((Object)$lt7DAdCost).hashCode());
        Long $lt1DExp = this.getLt1DExp();
        result = result * 59 + ($lt1DExp == null ? 43 : ((Object)$lt1DExp).hashCode());
        Long $lt1DAdCost = this.getLt1DAdCost();
        result = result * 59 + ($lt1DAdCost == null ? 43 : ((Object)$lt1DAdCost).hashCode());
        return result;
    }

    public String toString() {
        return "IdeaUnitDo(ideaUnitId=" + this.getIdeaUnitId() + ", adIdeaId=" + this.getAdIdeaId() + ", materialIds=" + this.getMaterialIds() + ", ratioType=" + this.getRatioType() + ", type=" + this.getType() + ", price=" + this.getPrice() + ", preCtr=" + this.getPreCtr() + ", statCtr=" + this.getStatCtr() + ", ctr=" + this.getCtr() + ", preLaunchPv=" + this.getPreLaunchPv() + ", statLaunchPv=" + this.getStatLaunchPv() + ", launchPv=" + this.getLaunchPv() + ", arpu=" + this.getArpu() + ", preArpu=" + this.getPreArpu() + ", adxStatsDo=" + this.getAdxStatsDo() + ", adEcpm=" + this.getAdEcpm() + ", isNew=" + this.getIsNew() + ", lt7DExp=" + this.getLt7DExp() + ", lt7DAdCost=" + this.getLt7DAdCost() + ", lt1DExp=" + this.getLt1DExp() + ", lt1DAdCost=" + this.getLt1DAdCost() + ")";
    }
}

