/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.activity;

import cn.com.duiba.nezha.alg.alg.activity.ActivityParams;
import cn.com.duiba.nezha.alg.alg.activity.ActivityRcmdReq;
import cn.com.duiba.nezha.alg.alg.activity.ActivityRcmdRet;
import cn.com.duiba.nezha.alg.alg.activity.ActivitySubParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.v2.ActivityFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.v2.ActFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityRcmder {
    private static final Logger logger = LoggerFactory.getLogger(ActivityRcmder.class);
    private static String LOG_PRIFIX = "ActivityRcmder";
    private static Random random = new Random();

    public static Map<Long, FeatureMapDo> getFeatureMap(List<ActivityRcmdReq> activityRcmdReqList, ContextFeatureDoV2 contextFeatureDoV2, UserFeatureDoV2 userFeatureDoV2) throws Exception {
        HashMap<Long, FeatureMapDo> featureMap = new HashMap<Long, FeatureMapDo>();
        Map staticFeatureMap = ActivityFeatureParse.generateFeatureMapStatic((ContextFeatureDoV2)contextFeatureDoV2, (UserFeatureDoV2)userFeatureDoV2);
        if (AssertUtil.isEmpty(activityRcmdReqList)) {
            logger.warn(LOG_PRIFIX + ".getFeatureMap activityRcmdReqList is null");
            return featureMap;
        }
        for (ActivityRcmdReq activityRcmdReq : activityRcmdReqList) {
            Long activityId = activityRcmdReq.getActivityId();
            String str = JSON.toJSONString((Object)activityRcmdReq);
            ActFeatureDoV2 actFeatureDoV2 = (ActFeatureDoV2)JSON.parseObject((String)str, ActFeatureDoV2.class);
            Map dynamicFeatureMap = ActivityFeatureParse.generateFeatureMapDynamic((ActFeatureDoV2)actFeatureDoV2, (UserFeatureDoV2)userFeatureDoV2);
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMap.put(activityId, featureMapDo);
        }
        return featureMap;
    }

    public static Map<Long, Double> predict(Map<Long, FeatureMapDo> featureMapDoMap, DeepModelV2 deepModelV2, LocalTFModelV2 localTFModelV2) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{deepModelV2, localTFModelV2})) {
            return deepModelV2.predictWithLocalTFV2(featureMapDoMap, localTFModelV2);
        }
        return new HashMap<Long, Double>();
    }

    public static ActivityRcmdRet rcmd(List<ActivityRcmdReq> activityRcmdReqList, ActivityParams activityParams, Map<Long, Double> preEcpmMap, Long slotId) throws Exception {
        List<ActivityRcmdRet> activityRcmdRetList = ActivityRcmder.getScore(activityRcmdReqList, activityParams, preEcpmMap, slotId);
        ActivityRcmdRet ret = ActivityRcmder.select(activityRcmdRetList);
        return ret;
    }

    private static ActivityRcmdRet select(List<ActivityRcmdRet> activityRcmdRetList) throws Exception {
        ActivityRcmdRet ret = null;
        if (AssertUtil.isEmpty(activityRcmdRetList)) {
            logger.warn(LOG_PRIFIX + ".rank select is Empty,invaild");
            return ret;
        }
        if (Math.random() < 0.9) {
            activityRcmdRetList = activityRcmdRetList.stream().sorted(Comparator.comparing(ActivityRcmdRet::getScore).reversed()).collect(Collectors.toList());
            ret = activityRcmdRetList.get(0);
            ret.setAlgRcmdType(1);
        } else {
            int n = random.nextInt(activityRcmdRetList.size());
            ret = activityRcmdRetList.get(n);
            ret.setAlgRcmdType(2);
        }
        return ret;
    }

    private static List<ActivityRcmdRet> getScore(List<ActivityRcmdReq> activityRcmdReqList, ActivityParams activityParams, Map<Long, Double> preEcpmMap, Long slotId) throws Exception {
        ArrayList<ActivityRcmdRet> ret = new ArrayList<ActivityRcmdRet>();
        if (AssertUtil.isEmpty(activityRcmdReqList)) {
            logger.warn(LOG_PRIFIX + ".getScore  activityRcmdReqList is Empty,invaild");
            return ret;
        }
        for (ActivityRcmdReq activityRcmdReq : activityRcmdReqList) {
            Long activityId = activityRcmdReq.getActivityId();
            String activitySourceType = activityRcmdReq.getActivitySourceType();
            Double preEcpm = preEcpmMap.get(activityId);
            if (preEcpm == null) {
                preEcpm = 0.0011;
            }
            ActivitySubParams activitySubParams = null;
            if (activityParams != null) {
                activitySubParams = activityParams.getFactor(activityId, activitySourceType, slotId);
            }
            Double score = ActivityRcmder.getScore(preEcpm, activitySubParams);
            ActivityRcmdRet activityRcmdRet = new ActivityRcmdRet();
            activityRcmdRet.setActivityId(activityId);
            activityRcmdRet.setActivitySubParams(activitySubParams);
            activityRcmdRet.setScore(score);
            ret.add(activityRcmdRet);
        }
        return ret;
    }

    private static Double getScore(double preEcpm, ActivitySubParams activitySubParams) {
        double ret = preEcpm;
        if (activitySubParams != null) {
            Double statEcpm = activitySubParams.getEcpm();
            Double statRatio = activitySubParams.getStatRatio();
            Double factor = activitySubParams.getFactor();
            if (statEcpm != null) {
                ret = Math.random() > statRatio ? preEcpm * 0.7 + statEcpm * 0.3 : statEcpm;
            }
            ret *= factor.doubleValue();
        }
        return ret;
    }
}

