package cn.com.duiba.nezha.alg.alg.activity;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.DateUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSON;
import org.joda.time.DateTime;

import javax.xml.crypto.Data;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 活动推荐接口，工程系统推荐调用，只和该对象交互
 */
public class ActivityAlg {


    /**
     * 活动推荐接口
     *
     * @param activityRcmdReqList 活动列表
     * @param contextFeatureDoV2  上下文特征
     * @param userFeatureDoV2     用户特征
     * @param deepModelV2         编码器模型
     * @param localTFModelV2      TF预估模型
     * @param activityParams      算法控制参数,广告位
     * @return
     * @throws Exception
     */
    public static ActivityRcmdRet rcmd(List<ActivityRcmdReq> activityRcmdReqList,

                                       ContextFeatureDoV2 contextFeatureDoV2,
                                       UserFeatureDoV2 userFeatureDoV2,
                                       DeepModelV2 deepModelV2,
                                       LocalTFModelV2 localTFModelV2,
                                       ActivityParams activityParams) throws Exception {

        if (contextFeatureDoV2 == null) {
            contextFeatureDoV2 = new ContextFeatureDoV2();
        }

        /**
         * 基础信息获取
         */
        Long slotId = contextFeatureDoV2.getSlotId();
        String abTestId = contextFeatureDoV2.getAbTestId();
        Integer rcmdType = contextFeatureDoV2.getRcmdType();
        String appPkgTrade2 = contextFeatureDoV2.getUaAppPackageTrade2();

        Long algRcmdType = ActivityRcmder.getAlgRcmdType();

        /**
         * 召回
         * 算法推荐时，走召回逻辑，过滤媒体包定制活动
         */
        List<ActivityRcmdReq> activityRcmdRecallList = activityRcmdReqList;
        if ("openRCMD".equals(abTestId)) {

            activityRcmdRecallList = ActivityRcmder.recall(activityRcmdReqList, appPkgTrade2, slotId, algRcmdType);

        }

        /**
         * 特征解析
         */
        Map<Long, FeatureMapDo> featureMapDoMap = ActivityRcmder.getFeatureMap(activityRcmdRecallList, contextFeatureDoV2, userFeatureDoV2);

        /**
         * 模型预估
         */
        Map<Long, Double> preEcpmMap = ActivityRcmder.predict(featureMapDoMap, deepModelV2, localTFModelV2);


        /**
         * 推荐
         */
        ActivityRcmdRet ret = ActivityRcmder.rcmd(activityRcmdRecallList, activityParams, preEcpmMap, slotId, appPkgTrade2, algRcmdType);


        if (ret != null) {
            ret.setAbTestId(abTestId);
            ret.setRcmdType(rcmdType);
            ret.setFeatureMap(featureMapDoMap.get(ret.getActivityId()).getFeatureMap());
        }


        return ret;
    }


    public static void main(String[] args) {

        try {
            run2();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static void run2() throws Exception {

        List<ActivityRcmdReq> activityRcmdReqList = new ArrayList<>();

        //定制1，玩法不匹配
        ActivityRcmdReq activityRcmdReq0 = new ActivityRcmdReq();
        activityRcmdReq0.setActivityId(31184L);
        activityRcmdReqList.add(activityRcmdReq0);
        // 未知活动
        ActivityRcmdReq activityRcmdReq1 = new ActivityRcmdReq();
        activityRcmdReq1.setActivityId(30915L);
        activityRcmdReqList.add(activityRcmdReq1);

        //定制1
        ActivityRcmdReq activityRcmdReq2 = new ActivityRcmdReq();
        activityRcmdReq2.setActivityId(31143L);
        activityRcmdReqList.add(activityRcmdReq2);

        // 随机测试活动、广告位默认活动
        ActivityRcmdReq activityRcmdReq3 = new ActivityRcmdReq();
        activityRcmdReq3.setActivityId(30942L);
        activityRcmdReqList.add(activityRcmdReq3);

        //随机测试活动
        ActivityRcmdReq activityRcmdReq4 = new ActivityRcmdReq();
        activityRcmdReq4.setActivityId(26497L);
        activityRcmdReqList.add(activityRcmdReq4);

        UserFeatureDoV2 userFeatureDoV2 = new UserFeatureDoV2();
        ContextFeatureDoV2 contextFeatureDoV2 = new ContextFeatureDoV2();
        contextFeatureDoV2.setAbTestId("openRCMD");

        contextFeatureDoV2.setUaAppPackageTrade2("1");
        contextFeatureDoV2.setSlotId(422622L);

        Map<Long, Integer> retMap = new HashMap<>();
        System.out.println("time start=" + LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));

        for (int i = 0; i < 200; i++) {
            ActivityRcmdRet ret = ActivityAlg.rcmd(activityRcmdReqList, contextFeatureDoV2, userFeatureDoV2,
                    null,
                    null,
                    null);

            Long act = ret.getActivityId();
            retMap.put(act, retMap.getOrDefault(act, 0) + 1);
        }
        System.out.println("retMap=" + JSON.toJSONString(retMap));

        System.out.println("time end=" + LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));

    }

    public static void run() throws Exception {

        List<ActivityRcmdReq> activityRcmdReqList = new ArrayList<>();

        for (int i = 0; i < 50; i++) {
            ActivityRcmdReq activityRcmdReq = new ActivityRcmdReq();
            activityRcmdReq.setActivityId(1001L);
        }
        UserFeatureDoV2 userFeatureDoV2 = new UserFeatureDoV2();
        ContextFeatureDoV2 contextFeatureDoV2 = new ContextFeatureDoV2();


        System.out.println("time start=" + LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));

        long d1 = System.currentTimeMillis();
        for (int j = 0; j < 1000; j++) {

            ActivityAlg.rcmd(activityRcmdReqList, contextFeatureDoV2, userFeatureDoV2,
                    null,
                    null,
                    null);
        }
        long d2 = System.currentTimeMillis();

        System.out.println("time end=" + LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        System.out.println("耗时：" + (d2 - d1) + " ms");
    }

    public static void run3() throws Exception {

        List<ActivityRcmdRet> activityRcmdRetList = new ArrayList<>();
        ActivityRcmdRet r1 = new ActivityRcmdRet();
        r1.setActivityId(1L);
        r1.setScore(1.0);

        activityRcmdRetList.add(r1);

        ActivityRcmdRet r2 = new ActivityRcmdRet();
        r2.setActivityId(0L);
        r2.setScore(2.0);

        activityRcmdRetList.add(r2);
        activityRcmdRetList = activityRcmdRetList.stream()
                .sorted(Comparator.comparing(ActivityRcmdRet::getScore).reversed())
                .collect(Collectors.toList());

        System.out.println("activityRcmdRetList=" + JSON.toJSONString(activityRcmdRetList));

    }

}
