package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.pd.ClickValueRectifyDo;

@SuppressWarnings("AlibabaEnumConstantsMustHaveComment")
public enum PredictType {

    CTR(0, "ctr(redis)"),
    PVLAUNCH(1, "pvlaunch(redis)"),
    ARPU(2, "ARPU(redis)"),
    CVR(3, "CVR(nas)"),
    CTR2(4, "互动首发券的CTR模型(nas)"),
    ESMM(5, "ESMM模型，同时预测CTR和Click（nas）"),
    CLICKPV(6, "每pv点券模型"),
    ADCPC(7, "券cpc模型"),
    PVLAUNCHV2(8, "pvlaunch-v2"),
    ARPUV2(9, "ARPU-v2"),
    SCORE(10, "user-score"),
    SCOREV2(11, "user-score-V2"),
    ADCPCV2(12, "券cpc模型-v2"),



    /**
     * ctr -2
     * clcik -2
     */




    CLICKPV_V2(13, "每pv点券模型-v2"),
    CTR_V2(14, "ctr-v2"),


    /**
     * 百度 离线模型
     */
    CTR_BAIDU_V2(15, "ctr-baidu-v2"),
    CLICKPV_BAIDU_V2(16, "clickpv-baidu-v2"),
    CPC_BAIDU_V2(17, "cpc-baidu-v2"),

    ;

    private int type;
    private String desc;

    PredictType(int type, String desc) {

        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }


    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }



}
