package cn.com.duiba.nezha.alg.alg.vo.adx.rtb2;

import lombok.Data;

import java.io.Serializable;

@Data
public class AdxRtbBidRequestDo implements Serializable {

    /**
     * 推广组ID
     */
    private Long groupId;

    /**
     * 资源位ID
     */
    private Long resourceId;

    /**
     * 创意ID
     */
    private Long ideaId;

    /**
     * app ID
     */
    private String appId;

    /**
     * 出价方式：1-roi出价、2-cpc出价
     */
    private Integer bidMode;

    /**
     * 创意设置的目标roi
     */
    private Double roi;

    /**
     * 创意设置的目标cpc
     */
    private Double cpc;

    /**
     * 直投cpc
     */
    private Double directCpc;

    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     * 预估每pv发券
     */
    private Double preLaunchPv;

    /**
     * 预估点击价值
     */
    private Double clickValue;

    /**
     * 维稳参数对象
     */
    private AdxFactorBaseDo adxFactorDo;

    /**
     * 实验分组ID
     * 1、2 老接口
     * 3、4 新接口
     */
    private Integer groupTag;

    /**
     * 出价类型：1-互动算法出价、2-直投
     */
    private Integer priceType;

    /**
     * 新老架构-实验分组
     */
    private Integer newGroupTag;

    /**
     * 根据网络状态决定是否提价
     */
    private boolean isLiftByNetwork;

}
