/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.vo.AdvertRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlFactors;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepBidControl {
    private static final Logger log = LoggerFactory.getLogger(DeepBidControl.class);
    static Double targetCost = 1.0;

    public static DeepControlFactors calculateNormal(Long deepFee, Long aFee, Double preDcvr, Double confWeight, Double preMergeWeight, Double statFactor, Double preMergeDiffU, Double preMergeDiffL) {
        DeepControlFactors retDto = new DeepControlFactors();
        Double preFactor = targetCost * (double)deepFee.longValue() * preDcvr / (double)aFee.longValue();
        preFactor = MathUtil.formatDouble((double)preFactor, (int)5);
        if (preDcvr < 1.0E-8) {
            preMergeWeight = 0.0;
        }
        Double conFactor = confWeight * preMergeWeight * preFactor + (1.0 - confWeight * preMergeWeight) * statFactor;
        Double factor = MathUtil.formatDouble((double)MathUtil.stdwithBoundary((double)conFactor, (double)preMergeDiffL, (double)preMergeDiffU), (int)5);
        retDto.setPreDeepFactor(preFactor);
        retDto.setStatDeepFactor(statFactor);
        retDto.setDeepFactor(factor);
        return retDto;
    }

    public static DeepControlFactors getDeepFactor(OcpxControlParams costParams, DeepControlParams params, AdBidParamsDo adBidParamsDo) {
        Long deepFee = adBidParamsDo.getDeepFee();
        Long aFee = adBidParamsDo.getAFee();
        Long appAFee = adBidParamsDo.getAppAFee();
        Long usefulAfee = aFee;
        if (appAFee != null && appAFee > 0L) {
            usefulAfee = appAFee;
        }
        Double preDcvr = adBidParamsDo.getPreDcvr();
        DeepControlFactors retDto = new DeepControlFactors();
        Double ret = null;
        if (params == null || params.getDeepFactor() == null) {
            return retDto;
        }
        ret = params.getDeepFactor();
        Double statFactor = params.getDeepFactor();
        retDto.setDeepFactor(ret);
        retDto.setStatDeepFactor(statFactor);
        Long controlType = params.getControlType();
        Double confWeight = params.getConfWeight();
        Double preMergeWeight = params.getPreMergeWeight();
        Double preMergeDiffU = params.getPreMergeDiffU();
        Double preMergeDiffL = params.getPreMergeDiffL();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{confWeight, controlType, preDcvr, deepFee, usefulAfee, preMergeWeight, preMergeDiffU, preMergeDiffL, statFactor})) {
            retDto = DeepBidControl.calculateNormal(deepFee, usefulAfee, preDcvr, confWeight, preMergeWeight, statFactor, preMergeDiffU, preMergeDiffL);
        }
        return retDto;
    }

    public static Boolean dcvrConstrain(DeepControlParams params, AdBidParamsDo adBidParamsDo) {
        Boolean result = false;
        return result;
    }

    public static void main(String[] args) {
        String str2 = "[{\"ctr\":0.190892,\"t_tag\":\"15\",\"ad\":79991,\"fee\":4,\"rankScore\":0.7636,\"preDcvr\":0.0,\"cy\":3,\"scvr\":0.0017,\"arpu\":0.7636,\"pk\":0,\"pre_ctr\":0.15726,\"sctr\":0.493581,\"pre_cvr\":0.0026,\"cvr\":0.00251},{\"ctr\":0.114657,\"t_tag\":\"1\",\"ad\":80651,\"fee\":5,\"rankScore\":0.5733,\"preDcvr\":0.0,\"cy\":3,\"scvr\":0.01,\"arpu\":0.5733,\"pk\":198617,\"pre_ctr\":0.07141,\"sctr\":0.50388,\"pre_cvr\":0.00053,\"cvr\":0.001477}]";
        List ret = JSON.parseArray((String)str2, AdvertRcmdDo.class);
        System.out.println(JSON.toJSONString((Object)ret));
    }
}

