package cn.com.duiba.nezha.alg.alg.activity;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.v2.ActivityFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.v2.ActFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;


public class ActivityRecaller {
    private static final Logger logger = LoggerFactory.getLogger(ActivityRecaller.class);

    private static String LOG_PRIFIX = "ActivityRcmder";

    private static HashMap<Long, String> sActMap = new HashMap<>();//定制

    private static HashMap<Long, Long> dActMap = new HashMap<>();//默认


    private static Random random = new Random();


    private static HashMap<Long, ActivityInfo> actWhiteList = new HashMap<>();//活动白名单配置信息
    private static HashMap<Long, SlotInfo> slotWhiteList = new HashMap<>();//广告位白名单配置信息

    private static List testList = Arrays.asList(30942L, 30828L, 26497L, 30222L, 30784L, 31234L, 31352L, 31185L, 31475L, 31557L, 31545L, 30192L, 31595L);//随机测试活动-配置信息

    static {
        actWhiteList.put(30942L, new ActivityInfo(30942L, 1L, null));
        actWhiteList.put(31143L, new ActivityInfo(31143L, 1L, "1"));
        actWhiteList.put(31346L, new ActivityInfo(31346L, 1L, "1"));
        actWhiteList.put(31144L, new ActivityInfo(31144L, 1L, "2"));
        actWhiteList.put(31145L, new ActivityInfo(31145L, 1L, "3"));
        actWhiteList.put(31146L, new ActivityInfo(31146L, 1L, "4"));
        actWhiteList.put(30828L, new ActivityInfo(30828L, 2L, null));
        actWhiteList.put(31184L, new ActivityInfo(31184L, 2L, "1"));
        actWhiteList.put(30998L, new ActivityInfo(30998L, 2L, "2"));
        actWhiteList.put(31101L, new ActivityInfo(31101L, 2L, "3"));
        actWhiteList.put(31307L, new ActivityInfo(31307L, 2L, "8"));
        actWhiteList.put(31308L, new ActivityInfo(31308L, 2L, "11"));
        actWhiteList.put(31183L, new ActivityInfo(31183L, 2L, "4"));
        actWhiteList.put(30222L, new ActivityInfo(30222L, 1L, null));
        actWhiteList.put(31545L, new ActivityInfo(31545L, 5L, null));
        actWhiteList.put(31595L, new ActivityInfo(31595L, 3L, null));

    }

    static {

        slotWhiteList.put(417764L, new SlotInfo(417764L, 30942L, 1L));
        slotWhiteList.put(422622L, new SlotInfo(422622L, 30942L, 1L));
        slotWhiteList.put(404873L, new SlotInfo(404873L, 31545L, 5L));
        slotWhiteList.put(417855L, new SlotInfo(417855L, 31595L, 3L));
        slotWhiteList.put(423985L, new SlotInfo(423985L, 30222L, 1L));
        slotWhiteList.put(420877L, new SlotInfo(420877L, 31545L, 5L));
        slotWhiteList.put(404106L, new SlotInfo(404106L, 30828L, 2L));

    }


    public static Long getActType(Long activityId) {
        Long ret = null;
        ActivityInfo activityInfo = actWhiteList.get(activityId);
        if (activityInfo != null && activityInfo.getActType() != null) {
            ret = activityInfo.getActType();
        }
        return ret;
    }

    public static String getActTrade2(Long activityId) {
        String ret = null;
        ActivityInfo activityInfo = actWhiteList.get(activityId);
        if (activityInfo != null && activityInfo.getActTrade2() != null) {
            ret = activityInfo.getActTrade2();
        }
        return ret;
    }


    public static Long getDefActId(Long slotId) {
        Long ret = null;
        SlotInfo slotInfo = slotWhiteList.get(slotId);
        if (slotInfo != null && slotInfo.getDefActId() != null) {
            ret = slotInfo.getDefActId();
        }
        return ret;
    }

    public static Long getDefActType(Long slotId) {
        Long ret = null;
        SlotInfo slotInfo = slotWhiteList.get(slotId);
        if (slotInfo != null && slotInfo.getDefActType() != null) {
            ret = slotInfo.getDefActType();
        }
        return ret;
    }

    /**
     * @param activityRcmdReqList 活动列表
     * @param appPkgTrade2        媒体包
     * @param slotId
     * @param algRcmdType         算法策略类型
     * @param filterActSet        已投放活动，过滤
     * @return
     * @throws Exception
     */
    public static List<ActivityRcmdReq> recall(List<ActivityRcmdReq> activityRcmdReqList, String appPkgTrade2, Long slotId, Long algRcmdType, Set<Long> filterActSet) throws Exception {

        List<ActivityRcmdReq> ret = new ArrayList<>();
        Long dAct = getDefActId(slotId); //默认活动id
        Long dActType = getDefActType(slotId); //默认活动玩法

        List<ActivityRcmdReq> retDef = new ArrayList<>();//默认活动
        List<ActivityRcmdReq> retSpe = new ArrayList<>();//定制活动，媒体包+定制活动+玩法一致
        List<ActivityRcmdReq> retOther = new ArrayList<>();//非定制活动


        for (int i = 0; i < activityRcmdReqList.size(); i++) {
            ActivityRcmdReq activityRcmdReq = activityRcmdReqList.get(i);
            Long activityId = activityRcmdReq.getActivityId();
            String actTrade2 = getActTrade2(activityId);//当前活动行业标签
            Long actType = getActType(activityId);//当前活动玩法


            // 1、重复活动，过滤
            if (filterActSet.contains(activityId)) {
                continue;
            }

            // 2、召回 默认活动
            if (dAct != null && activityId.equals(dAct)) {
                retDef.add(activityRcmdReq);
                continue;
            }

            // 3、召回 定制活动，流量携带媒体包标签、且与活动活动标签一致，且 活动玩法一致
            if (appPkgTrade2 != null && appPkgTrade2.equals(actTrade2)) {
                retSpe.add(activityRcmdReq);
                continue;
//                if (dActType != null && dActType.equals(actType)) {
//                    retSpe.add(activityRcmdReq);
//                    continue;
//                }
            }

            // 4、召回 非定制活动
            if (actTrade2 == null) {
                retOther.add(activityRcmdReq);
                continue;
            }

        }

        if (algRcmdType.equals(1L) || algRcmdType.equals(2L)) {
            ret = recallA(retDef, retSpe, retOther);
        }
//        if (algRcmdType.equals(2L)) {
//            ret = recallB(retDef, retSpe, retOther);
//        }
        if (algRcmdType.equals(3L)) {
            ret = recallC(retDef, retSpe, retOther);
        }

        if (ret.isEmpty()) {
            ret.add(activityRcmdReqList.get(0));
        }

        return ret;

    }


    /**
     * 策略1
     * 1、有定制活动流量：默认活动、媒体包+定制+玩法一致活动
     * 2、无定制活动流量：默认活动、非定制活动
     */
    public static List<ActivityRcmdReq> recallA(List<ActivityRcmdReq> retDef,
                                                List<ActivityRcmdReq> retSpe,
                                                List<ActivityRcmdReq> retOther) throws Exception {
        List<ActivityRcmdReq> ret = new ArrayList<>();
        if (retSpe.isEmpty()) {
            // 无定制活动
            ret.addAll(retOther);
            ret.addAll(retDef);
        } else {
            // 有定制活动
            ret.addAll(retSpe);
            ret.addAll(retDef);
            ret.addAll(retOther);
        }
        return ret;
    }


    /**
     * 策略2
     * <p>
     * 1、有定制活动流量：媒体包+定制+玩法一致活动
     * 2、无定制活动流量：默认活动、非定制活动
     */
    public static List<ActivityRcmdReq> recallB(List<ActivityRcmdReq> retDef,
                                                List<ActivityRcmdReq> retSpe,
                                                List<ActivityRcmdReq> retOther) throws Exception {
        List<ActivityRcmdReq> ret = new ArrayList<>();
        if (retSpe.isEmpty()) {
            // 无定制活动
            ret.addAll(retOther);
            ret.addAll(retDef);
        } else {
            // 有定制活动
            ret.addAll(retSpe);
        }
        return ret;
    }

    /**
     * 策略3
     * <p>
     * 1、有定制活动流量：媒体包+定制+玩法一致活动
     * 2、无定制活动流量：默认活动、非定制活动
     */
    public static List<ActivityRcmdReq> recallC(List<ActivityRcmdReq> retDef,
                                                List<ActivityRcmdReq> retSpe,
                                                List<ActivityRcmdReq> retOther) throws Exception {
        List<ActivityRcmdReq> ret = new ArrayList<>();
        ret.addAll(retOther);
        ret.addAll(retDef);

        return ret;
    }
}
