package cn.com.duiba.nezha.alg.alg.vo.adx;

import cn.com.duiba.nezha.alg.alg.adx.rcmd2.priceExploreLevelEnum;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import lombok.Data;

import java.util.ArrayList;
import java.util.HashMap;

@Data
public class AdxPriceExploreDo {

    /**
     * 联盟媒体id
     */
    private String appId;

    /**
     * slot ID：联盟广告位id
     */
    private String slotId;

    /**
     * 探价分桶标记："1"，"2"，"3"，"4"，"5"，"6", "7"，"8"，"9"，"10"，"11"，"12"
     */
    private String level;

    /**
     * 竞价返回次数
     */
    private Long bid;

    /**
     * 入口素材曝光次数
     */
    private Long exp;

    /**
     * adx消耗(分*10^4/cpm)
     */
    private Long adxConsume;

    /**
     * 广告消耗(分)
     */
    private Long advertConsume;

    /**
     * 针对每次更新请求生成的随机数
     */
    private double random;

    public static Double getEffect(AdxPriceExploreDo levelDo, String effectMode) {
        int expLimit = 100;  // 曝光次数需大于100次
        int advConsumeLimit = 500;  // 广告消耗需大于500分
        if (effectMode.equals(priceExploreLevelEnum.profitLevelStart.getName())) {
            return getProfitEffect(levelDo, expLimit, advConsumeLimit);
        }
        else {
            return  getConsumeEffect(levelDo, expLimit, advConsumeLimit);
        }
    }

    public static Double getProfitEffect(AdxPriceExploreDo levelDo, int expLimit, int advConsumeLimit) {
        Double ret = null;
        if(levelDo != null && levelDo.getExp() != null && (levelDo.getExp() > expLimit || levelDo.getAdvertConsume() > advConsumeLimit)) {
            Long adxConsume = levelDo.getAdxConsume();
            Long advertConsume = levelDo.getAdvertConsume();
            Double shareRate = DataUtil.division(adxConsume, advertConsume);
            if(AssertUtil.isAllNotEmpty(adxConsume, advertConsume, shareRate)) {
                double profit = advertConsume - adxConsume;
                // 当分成比例<1.1（roi>0.9）时，为利润优先模式，会综合考虑消耗规模
                if (shareRate < 1.1) {
                    ret = profit * shareRate;
                }
                else {
                    // 当roi小于0.9时，为纯利润模式，尽量减少亏损
                    ret = profit;
                }
            }
        }
        return ret;

    }

    public static Double getConsumeEffect(AdxPriceExploreDo levelDo, int expLimit, int advConsumeLimit) {
        Double ret = null;
        if(levelDo != null && levelDo.getExp() != null && (levelDo.getExp() > expLimit || levelDo.getAdvertConsume() > advConsumeLimit)) {
            Long adxConsume = levelDo.getAdxConsume();
            Long advertConsume = levelDo.getAdvertConsume();
            Double shareRate = DataUtil.division(adxConsume, advertConsume);
            if(AssertUtil.isAllNotEmpty(adxConsume, advertConsume, shareRate)) {
                double profit = advertConsume - adxConsume;
                // 当分成比例<1.05（roi>0.95）时，为纯消耗模式
                if (shareRate < 1.05) {
                    ret = advertConsume * 1.0;
                }
                else {
                    // 当roi小于0.95时，为利润优先模式，会综合考虑消耗规模
                    ret = profit * shareRate;
                }

            }
        }
        return ret;

    }
}
