package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import lombok.Data;

import java.util.Map;

@Data
public class AdxAppReqDo {
    /**
     * 分流标志: 0：原逻辑；1：实验组；2：对照组
     */
    private Integer groupTag;

    /**
     * 探价ab实验标记： 1=实验组，2=对照组
     */
    private Integer expGroupTag;

    /**
     * app ID：联盟媒体id
     */
    private String appId;

    /**
     * slot ID：联盟广告位id
     */
    private String slotId;

    /**
     * 底价
     * 单位：分/千次曝光
     */
    private Double basePrice;

    private AdxExploreDo adxExploreDo;

    /**
     * 排期单价格(当pmpType=1/2时，有值)
     */
    private Long pmpPrice;

    /**
     * pmpType类型：0-RTB，1-PD，2-PDB
     */
    private Integer pmpType;

    /**
     * arpu预估纠偏参数
     */
    private Double arpuRectifyFactor;

    /**
     *竞价阈值
     *
     */
    private Double bidEcpmThreadhold;

}
