package cn.com.duiba.nezha.alg.alg.adsupport;

import cn.com.duiba.nezha.alg.alg.vo.advertsupport.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;

import java.util.*;

/**
 * 统计CVR异常监控
 *
 * 注：
 *  1、现存的一个风险：若冷启计划前后端转化类型转化率相差较大会有问题；  => 解决方案：重新提数据需求，按照转化类型去统计数据
 */

public class StatCvrMonitor {

    public static CvrMonitorRes getCvrMonitorRes(AdvertSupportInfoV1 advertSupportInfo,
                                                 CvrMonitorInfoV1 cvrMonitorInfo,
                                                 SupportParams params,
                                                 Long advStartExposure) {

        CvrMonitorRes res = new CvrMonitorRes();

        if (AssertUtil.isAnyEmpty(advertSupportInfo, params, cvrMonitorInfo)) {
            return res;
        }

        Double curStatCvr = getCurStatCvr(cvrMonitorInfo, advertSupportInfo, params.getMinDimClickThresh(), params.getHyperParam());   // 获取当前各维度融合后的统计CVR

        if ((AssertUtil.isNotEmpty(advStartExposure) && advStartExposure > 0) && (advertSupportInfo.getAdvert1Day().getExposure()-advStartExposure) <= params.getExposeThresh()) {
            //冷启计划统计CVR异常且在高倍提权期间
            res.setAdjustStaCvr(curStatCvr);
            res.setHighCvrAjaRatio("2");
        }else if ((AssertUtil.isNotEmpty(advStartExposure) && advStartExposure > 0) && (advertSupportInfo.getAdvert1Day().getExposure()-advStartExposure) > params.getExposeThresh()) {
            //冷启计划统计CVR异常且在高倍提权结束
            res.setHighCvrAjaRatio("3");
        }else if (cvrMonitor(cvrMonitorInfo.getCurTenMinStaCvr(), curStatCvr, params.getCvrDisRatio())) {
            //冷启计划刚开始异常:1)将当前融合统计CVR的值、广告此时的曝光值塞到res中;2)将当前计划的状态存入redis指定的key下，nezha完成
            res.setAdjustStaCvr(curStatCvr);
            res.setExposure(advertSupportInfo.getAdvert1Day().getExposure());
            res.setHighCvrAjaRatio("1");
        }else {
            res.setHighCvrAjaRatio("0");
        }

        res.setAdvertId(advertSupportInfo.getAdvertId());

        return res;
    }

    /**
     * 统计CVR异常监控：近10min的统计CVR小于融合统计CVR的1/10，则报告统计CVR异常
     * @param curStatCvr => 当前冷启的统计CVR列表
     * @param comCvr => 融合统计CVR
     * @return 统计CVR是否异常,用于辅助判当前是否需要对统计CVR进行高倍系数提权
     */
    public static Boolean cvrMonitor(double curStatCvr, Double comCvr, double ratio) {
        if (AssertUtil.isEmpty(comCvr)) {
            return false;
        }else {
            return curStatCvr < ratio * comCvr;
        }
    }

    /**
     * 用于获取当前个维度融合的统计CVR值
     * 数据置信判断；时间加权+维度加权；
     * @param advertSupportInfoV1
     * @param threshold
     * @return 修正后的统计CVR值
     */
    public static Double getCurStatCvr(CvrMonitorInfoV1 cvrMonitorInfo, AdvertSupportInfoV1 advertSupportInfoV1, Long threshold, Double hyperParam) {

        double res = 0.0D;

        if (AssertUtil.isAnyEmpty(advertSupportInfoV1)) {
            return res;
        }

        //获取统计信息
        Long dayTradeAppClick = cvrMonitorInfo.getDayTradeAppData().getClick();
        Long dayTradeAppConvert = cvrMonitorInfo.getDayTradeAppData().getConvert();
        Long dayTradeClick = cvrMonitorInfo.getDayTradeData().getClick();
        Long dayTradeConvert = cvrMonitorInfo.getDayTradeData().getConvert();
        Long dayTradeAppSecTagClick = cvrMonitorInfo.getDayTradeAppSecTagData().getClick();
        Long dayTradeAppSecTagConvert = cvrMonitorInfo.getDayTradeAppSecTagData().getConvert();
        Long triDayTradeAppClick = cvrMonitorInfo.getTriDayTradeAppData().getClick();
        Long triDayTradeAppConvert = cvrMonitorInfo.getTriDayTradeAppData().getConvert();
        Long triDayTradeClick = cvrMonitorInfo.getTriDayTradeData().getClick();
        Long triDayTradeConvert = cvrMonitorInfo.getTriDayTradeData().getConvert();
        Long triDayTradeAppSecTagClick = cvrMonitorInfo.getTriDayTradeAppSecTagData().getClick();
        Long triDayTradeAppSecTagConvert = cvrMonitorInfo.getTriDayTradeAppSecTagData().getConvert();

        // 计算各维度统计值
        Double dayTradeAppCvr = Optional.ofNullable(MathUtil.division(dayTradeAppConvert, dayTradeAppClick, 6)).orElse(0.0);
        Double dayTradeCvr = Optional.ofNullable(MathUtil.division(dayTradeConvert, dayTradeClick, 6)).orElse(0.0);
        Double dayTradeAppSecTagCvr = Optional.ofNullable(MathUtil.division(dayTradeAppSecTagConvert, dayTradeAppSecTagClick, 6)).orElse(0.0);
        Double triDayTradeAppCvr = Optional.ofNullable(MathUtil.division(triDayTradeAppConvert, triDayTradeAppClick, 6)).orElse(0.0);
        Double triDayTradeCvr = Optional.ofNullable(MathUtil.division(triDayTradeConvert, triDayTradeClick, 6)).orElse(0.0);
        Double triDayTradeAppSecTagCvr = Optional.ofNullable(MathUtil.division(triDayTradeAppSecTagConvert, triDayTradeAppSecTagClick, 6)).orElse(0.0);

        List<Long> clickList = Arrays.asList(dayTradeAppClick, dayTradeAppSecTagClick, dayTradeClick, triDayTradeAppClick, triDayTradeAppSecTagClick, triDayTradeClick);
        List<Double> cvrList = Arrays.asList(dayTradeAppCvr, dayTradeAppSecTagCvr, dayTradeCvr, triDayTradeAppCvr, triDayTradeAppSecTagCvr, triDayTradeCvr);

        int index = getMinDim(clickList, threshold);
        // 兜底
        if (index == 6) {
            return 0.025D;  //兜底StatCvr=0.025
        }

        List<Double> dimsWeights = getEachDimWeight(clickList.size()-index, hyperParam);

        for (int i=0;i<dimsWeights.size();i++) {
            res += dimsWeights.get(i) * cvrList.get(i+index);
        }

        return res;
    }

    /**
     * 获取数据置信的最小维度，若最大维度数据都不置信的话只能使用最大维度的数据
     * @param diffDimsClickList
     * @param threshold
     * @return
     */
    public static Integer getMinDim(List<Long> diffDimsClickList, Long threshold) {
        Integer res = 6;

        if (AssertUtil.isAnyEmpty(diffDimsClickList, threshold)) {
            return res;
        }

        for (Long diffDimsClick: diffDimsClickList) {
            diffDimsClick = diffDimsClick == null ? 0 : diffDimsClick;
            if (diffDimsClick >= threshold) {
                return diffDimsClickList.indexOf(diffDimsClick);
            }
        }

        return res;
    }

    /**
     * 获取各维度上加权因子的大小 => 根据要加权的维度的个数动态的调整各维度的加权系数
     * @param size
     * @return 各维度上加权因子的大小
     */
    public static List<Double> getEachDimWeight(Integer size, double hyperParam) {

        List<Double> res = new ArrayList<>();
        List<Double> tmp_y = new ArrayList<>();
        double totValue = 0.0D;

        if (size.equals(0)) {
            return res;
        }

        // 从最小置信维度开始做指数衰减
        for (int i=0;i<size;i++) {
            double curValue = Math.exp(-1*i*hyperParam);
            tmp_y.add(curValue);
            totValue += curValue;
        }

        // 归一化
        for (double item: tmp_y) {
            res.add(MathUtil.division(item, totValue, 6));
        }

        return res;
    }

    public static void main(String[] args) {
        AdvertSupportInfoV1 info = new AdvertSupportInfoV1();
        CvrMonitorInfoV1 cvrInfo = new CvrMonitorInfoV1();

        SupportData advert3Day = new SupportData();
        advert3Day.setClick(10L);
        Map convs = new HashMap();
        convs.put(1,10L);
        convs.put(3,10L);
        advert3Day.setConv(convs);
        advert3Day.setExposure(100L);
        advert3Day.setConsume(100L);
        advert3Day.setOcpcConsume(100L);
        advert3Day.setCost(50.0);
        advert3Day.setCostBias(1.0);
        info.setAdvert1Day(advert3Day);
        info.setAdvertId(12346L);

        double curTenMinStaCvr = 0.00025D;
        cvrInfo.setCurTenMinStaCvr(curTenMinStaCvr);

        SupportDataAdd dayTradeAppData = new SupportDataAdd();
        SupportDataAdd dayTradeData = new SupportDataAdd();
        SupportDataAdd dayTradeAppSecTagData = new SupportDataAdd();
        SupportDataAdd triDayTradeAppData = new SupportDataAdd();
        SupportDataAdd triDayTradeData = new SupportDataAdd();
        SupportDataAdd triDayTradeAppSecTagData = new SupportDataAdd();
        dayTradeAppData.setClick(10L);
        dayTradeAppData.setConvert(0L);
        dayTradeData.setClick(3000L);
        dayTradeData.setConvert(200L);
        dayTradeAppSecTagData.setClick(6000L);
        dayTradeAppSecTagData.setConvert(300L);
        triDayTradeAppData.setClick(100000L);
        triDayTradeAppData.setConvert(2500L);
        triDayTradeData.setClick(500000L);
        triDayTradeData.setConvert(10000L);
        triDayTradeAppSecTagData.setClick(1000000L);
        triDayTradeAppSecTagData.setConvert(15000L);
//        dayTradeAppData.setClick(null);
//        dayTradeAppData.setConvert(0L);
//        dayTradeData.setClick(null);
//        dayTradeData.setConvert(200L);
//        dayTradeAppSecTagData.setClick(null);
//        dayTradeAppSecTagData.setConvert(300L);
//        triDayTradeAppData.setClick(null);
//        triDayTradeAppData.setConvert(2500L);
//        triDayTradeData.setClick(null);
//        triDayTradeData.setConvert(10000L);
//        triDayTradeAppSecTagData.setClick(null);
//        triDayTradeAppSecTagData.setConvert(15000L);
        cvrInfo.setDayTradeAppData(dayTradeAppData);
        cvrInfo.setDayTradeData(dayTradeData);
        cvrInfo.setDayTradeAppSecTagData(dayTradeAppSecTagData);
        cvrInfo.setTriDayTradeAppData(triDayTradeAppData);
        cvrInfo.setTriDayTradeData(triDayTradeData);
        cvrInfo.setTriDayTradeAppSecTagData(triDayTradeAppSecTagData);

        SupportParams params = new SupportParams();
        params.setMinDimClickThresh(5000L);
        params.setExposeThresh(2000L);
        params.setCvrDisRatio(0.1D);
        params.setHyperParam(1.0D);

//        CvrMonitorRes f = getCvrMonitorRes(info, cvrInfo, params,10L );
        CvrMonitorRes f = getCvrMonitorRes(info, cvrInfo, params,null );
        System.out.println(JSON.toJSONString(f));

    }

}
