package cn.com.duiba.nezha.alg.alg.material;

import cn.com.duiba.nezha.alg.alg.vo.material.MaterialIDselectReturnDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialSelectModel;
import com.alibaba.fastjson.JSON;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MaterialIDSelectAlg {   //新增两个素材优选的策略；更新版本


    /**
     * 素材优选策略1
     * <p>
     * 离线+实时，统计 最优素材
     * <p>
     * 最优素材维度：计划、配置、计划+媒体、配置+媒体
     *
     * @param orientationId       配置ID
     * @param appId               媒体ID
     * @param currentMaterialIds  配置维度，可投放素材集合，不为空
     * @param materialSelectModel 计划维度，素材推荐控制参数,redis 存储对象
     * @return 推荐素材
     */
    public static MaterialIDselectReturnDo materialSelect(Long orientationId, Long appId, List<Long> currentMaterialIds, MaterialSelectModel materialSelectModel) {

        return MaterialSelect.materialSelect(orientationId, appId, currentMaterialIds, materialSelectModel);

    }


    public static MaterialIDselectReturnDo materialSelect2(Long orientationId, Long appId, List<Long> currentMaterialIds, MaterialSelectModel materialSelectModel) {

        return MaterialSelect.materialSelect2(orientationId, appId, currentMaterialIds, materialSelectModel);

    }


    public static void main(String[] args) {

        Double value= 1.1;

        System.out.println(value);
        System.out.println(value.intValue());
        System.out.println(value.intValue()==1);

    }
    public static void main2(String[] args) {


        String str="{\"advertId\":81108,\"bestMaterialIdMap\":{\"81108_198978_null\":136317,\"81108_199118_null\":136318,\"81108_198969_null\":136319,\"81108_198979_null\":136318,\"81108_198971_null\":136319,\"81108_198953_null\":136319,\"81108_null_null\":136319,\"81108_198935_null\":136317,\"81108_199034_null\":136319,\"81108_0_null\":136319,\"81108_199061_null\":136318},\"pkgSet\":[198979,0,198978,198935,199061,198971,199034,198969,198953,199118,199164],\"randomWeight\":0.15,\"updateTime\":\"2022-04-21 15:39\"}";


        MaterialSelectModel materialSelectModel = JSON.parseObject(str,MaterialSelectModel.class);
        MaterialSelectModel materialSelectModel2 = new MaterialSelectModel();

        materialSelectModel.getBestMaterialIdMap().put(materialSelectModel.getKey(null, null), 1L);
        //materialSelectModel.getBestMaterialIdMap().put(materialSelectModel.getKey(2L, null), 2L);
        //materialSelectModel.getBestMaterialIdMap().put(materialSelectModel.getKey(2L, 3L), 3L);
        //materialSelectModel.getBestMaterialIdMap().put(materialSelectModel.getKey(null, 3L), 4L);

        materialSelectModel.setRandomWeight(0.15);
        List<Long> currentMaterialIds = new ArrayList<>();
//        currentMaterialIds.add(0L);
//        currentMaterialIds.add(1L);
//        currentMaterialIds.add(2L);
        currentMaterialIds.add(5L);
        currentMaterialIds.add(6L);
        currentMaterialIds.add(7L);


        /**
         * 测试0 计划/配置ID 空
         */

        test("1", null, null, currentMaterialIds, materialSelectModel);


        /**
         * 测试1，可投放列表空
         */
        test("2", 2L, 3L, null, materialSelectModel);

        /**
         * 测试2 最优素材对象空
         */
        test("3", 2L, 3L, currentMaterialIds, null);

        /**
         * 测试3 无最优素材
         */
        test("4", 2L, 3L, currentMaterialIds, materialSelectModel2);

        /**
         * 测试4 最优素材不在可投放列表
         */
        test("5", 2L, 3L, currentMaterialIds, materialSelectModel);

        currentMaterialIds.add(0L);
        currentMaterialIds.add(1L);
        currentMaterialIds.add(2L);
        currentMaterialIds.add(3L);
        currentMaterialIds.add(4L);

        /**
         * 测试5 常规
         */


        test("6", 2L, 3L, currentMaterialIds, materialSelectModel);

        Long b = materialSelectModel.getBestMaterial(2L, 3L);
        System.out.println("b=" + b);
    }

    public static void test(String testId, Long orientationId, Long appId, List<Long> currentMaterialIds, MaterialSelectModel materialSelectModel) {
        Map<Long, Long> retMap = new HashMap<>();
        Map<String, Long> retMap2 = new HashMap<>();

        System.out.println(testId + ",start");
        for (int i = 0; i < 100; i++) {
            MaterialIDselectReturnDo ret = materialSelect2(orientationId, appId, currentMaterialIds, materialSelectModel);
            if (ret != null) {
                retMap.put(ret.getStrategyOneRecmaterialId(), retMap.getOrDefault(ret.getStrategyOneRecmaterialId(), 0L) + 1);
                retMap2.put(ret.getRandom1(), retMap2.getOrDefault(ret.getRandom1(), 0L) + 1);
            }


        }
        System.out.println(testId + ",end,m=" + JSON.toJSONString(retMap) + ",type=" + JSON.toJSONString(retMap2));


    }



}