package cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import lombok.Data;

import java.io.Serializable;

@Data
public class FilterReqDo implements Serializable {

    private static final long serialVersionUID = 6847284961378258830L;

    /**
     * 分流标志: 0：原逻辑；1：实验组；2：对照组
     */
    private Integer groupTag;

    /**
     * 推广组ID
     */
    private Long groupId;

    /**
     * 资源位ID
     */
    private Long resId;

    /**
     * 联盟媒体行业id
     */
    private String extAppTrade;

    /**
     * appId 联盟媒体id
     */
    private String appId;

    /**
     * slot ID：联盟广告位id
     */
    private String slotId;

    /**
     * pmpType类型：0-RTB，1-PD，2-PDB
     */
    private Integer pmpType;

    /**
     * 底价/分
     */
    private Double basePrice;

    /**
     * 流量聚合ID
     */
    private String flowPolyId;

    /**
     * 流量初筛预估ctr
     */
    private Double filterPreCtr;

    /**
     * 资源位+flowPolyId 统计数据：近20min/近1h/近1d
     */
    private AdxStatsDo flowPolyIdStatsDo;

    /**
     * 资源位+实验id21+对比组0 统计数据：近1d
     */
    private AdxIndexStatDo groupTag0StatsDo;

    /**
     * 资源位+实验id21+对比组1 统计数据：近1d
     */
    private AdxIndexStatDo groupTag1StatsDo;

    /**
     * 资源位+实验id21+实验组2 统计数据：近1d
     */
    private AdxIndexStatDo groupTag2StatsDo;

}
