package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import cn.com.duiba.nezha.alg.alg.advert.DeepBidControl;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import lombok.Data;


@Data
public class DeepControlParams {

    /**
     * 深度 双出价 控制参数
     */
    private Double deepFactor; //深度目标调价因子

    private Double limitDeepFactor; //限流释放媒体-深度目标调价因子，弃用

    private Double confWeight;//预估置信权重

    private Double preMergeWeight;//预估融合权重

    private Double preMergeDiffU;//预估偏离统计上限 1.2
    private Double preMergeDiffL;//预估偏离统计下限 0.9

    private Long controlType; //实际控制类型 1：成本优先  2：消耗优先  3：延迟类型处理

    private Double slotStatDcvr; //配置+广告位，离线统计转化率
    private Double pkStatDcvr; //配置，离线统计转化率

    private Double preDeepCalibrate ;//深度模型预估校准参数 22.11.9


    private String updateTime;// 更新时间

    private Integer dcvrConstraint = 0; // 是否需要保率双出价，弃用

    private Double dcvrLowerBound = 0.0; //开启保率双出价的话，需要dcvr大于多少，弃用


    public static void main(String args[]) {

        DeepControlParams params = new DeepControlParams();
        params.setConfWeight(1.0);
        params.setDeepFactor(1.1);
        //params.setLimitDeepFactor(0.8);
        params.setControlType(1L);
        params.setPreMergeDiffL(0.3);
        params.setPreMergeDiffU(2.0);
        params.setPreMergeWeight(0.8);

        OcpxControlParams costParams = new OcpxControlParams();
        costParams.setPreDiscountUpperBound(null);
        costParams.setExtraRiseLowerBound(null);

        AdBidParamsDo adBidParamsDo = new AdBidParamsDo();
        adBidParamsDo.setAppLimitReleaseMark(0);
        adBidParamsDo.setPackageId(184438L);
        adBidParamsDo.setDeepFee(22000L);
        adBidParamsDo.setAFee(1000L);
        adBidParamsDo.setPreDcvr(0.02);
        adBidParamsDo.setAbTestId(2);

        DeepControlFactors result=DeepBidControl.getDeepFactor(costParams,params,adBidParamsDo);
        System.out.println(result);

    }

}
