package cn.com.duiba.nezha.alg.alg.plugins;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.plug.PreSelectActResPlugDo;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInStatDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.ActFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.ActFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

//import javax.xml.bind.util.JAXBSource;

public class ActPlugInDQNRcmder2 {

    private static final Logger logger = LoggerFactory.getLogger(ActPlugInDQNRcmder2.class);

    private static long ADX_MULTIPLIER = 10000000;

    private static int MAP_DF_SIZE = 8;


    /**
     * pcpm权重分配1 top1>0
     */
    static double[] pCpmBucket = {0.5, 0.8, 0.90, 0.95, 0.98, 1};
    static double[] pCpmWeight = {0.2, 1, 2, 3, 5, 100};


    /**
     * 响应式插件推荐
     *
     * @param plugList
     * @return
     */
    public static ResPlugInRcmdDo rcmd3(List<ResPlugInRcmdDo> plugList,
                                        ActFeatureDo actFeatureDo,
                                        CODER coderModel,
                                        LocalTFModel ltfModel,
                                        List<PreSelectActResPlugDo> preSelectActResPlugIndexDoList,
                                        List<PreSelectActResPlugDo> preSelectActResPlugIdDoList
    ) throws Exception {
        // 接口1.0
        return rcmdIndexAndIdBase(plugList, actFeatureDo, coderModel, ltfModel, preSelectActResPlugIndexDoList, preSelectActResPlugIdDoList, 3, 1.0);

    }


    /**
     * 响应式插件推荐
     *
     * @param plugList
     * @return
     */
    public static ResPlugInRcmdDo rcmdIndexAndIdBase(List<ResPlugInRcmdDo> plugList,
                                                     ActFeatureDo actFeatureDo,
                                                     CODER coderModel,
                                                     LocalTFModel ltfModel,
                                                     List<PreSelectActResPlugDo> preSelectActResPlugIndexDoList,
                                                     List<PreSelectActResPlugDo> preSelectActResPlugIdDoList,
                                                     int rcmd_type, Double statWeight) throws Exception {
        ResPlugInRcmdDo ret = null;


        if (valid(plugList, actFeatureDo)) {

            Map<String, Map<String, String>> featureMap = new HashMap<>();


            //1 静态特征解析
            Map<String, String> staticFeatureMap = ActFeatureParse.generateFeatureMapStatic(actFeatureDo);

            //2 封装1 统计ROI、RPM
            for (ResPlugInRcmdDo resPlugInRcmdDo : plugList) {
                resPlugInRcmdDo.setKey();

                String key = resPlugInRcmdDo.getKey();
                ResPlugInStatDo statDo = resPlugInRcmdDo.getResPlugInStatDo();

                resPlugInRcmdDo.setSRpm(ResPlugInStatModel.getRpm(statDo));
                resPlugInRcmdDo.setSRoi(ResPlugInStatModel.getRoi(statDo));


                // 解析动态特征
                ActFeatureDo dynamicDo = new ActFeatureDo();

                dynamicDo.setResPlugInId(resPlugInRcmdDo.getResPlugInId());
                dynamicDo.setResPlugInIndex(resPlugInRcmdDo.getResPlugInIndex());

                Map<String, String> dynamicFeatureMap = ActFeatureParse.generateFeatureMapDynamic(dynamicDo, actFeatureDo);
                dynamicFeatureMap.putAll(staticFeatureMap);

                // 封装特征
                featureMap.put(key, dynamicFeatureMap);

            }

            //3 模型预估RPM
            Map<String, Double> pRpmMap = new HashMap<>();

            if (validModel(coderModel, ltfModel)) {
                pRpmMap = coderModel.predictWithLocalTF(featureMap, ltfModel);
            }

            //4 封装2 预估RPM
            // 封装 按 插件、次序


            Map<Long, List<ResPlugInRcmdDo>> rcmdIndexMap = new HashMap<>();// 次序

            Map<Long, List<ResPlugInRcmdDo>> rcmdPlugMap = new HashMap<>(); // 插件

//            Map<Long, List<ResPlugInRcmdDo>> rcmdPlugAllMap = new HashMap<>(); // 插件，全量

            Map<String, ResPlugInRcmdDo> rcmdMap = new HashMap<>();// 次序+插件

            for (ResPlugInRcmdDo resPlugInRcmdDo : plugList) {
                String key = resPlugInRcmdDo.getKey();

                Double pRpm = pRpmMap.get(key);
                resPlugInRcmdDo.setPRpm(pRpm);

                // 融合RPM
                Double mergeRpm = getMergeRpm(pRpm, resPlugInRcmdDo.getSRpm(), statWeight);

                resPlugInRcmdDo.setMergeRpm(mergeRpm);

                // 重新封装 新数据结构
                Long plugId = resPlugInRcmdDo.getResPlugInId();
                Long plugIndex = resPlugInRcmdDo.getResPlugInIndex();

                if (!rcmdIndexMap.containsKey(plugIndex)) {
                    rcmdIndexMap.put(plugIndex, new ArrayList<>());
                }

                if (!rcmdPlugMap.containsKey(plugId)) {
                    rcmdPlugMap.put(plugId, new ArrayList<>());
                }


//                if (!rcmdPlugAllMap.containsKey(plugId)) {
//                    rcmdPlugAllMap.put(plugId, new ArrayList<>());
//                }


//                System.out.println("key2="+key+",merge="+mergeRpm);
                // 过滤 有效次序约束 0～4
                if (plugId != null && plugIndex != null) {
                    if (plugIndex > 4) {
//                        System.out.println("2filter,plugId="+plugId+",plugIndex="+plugIndex);
                        continue;
                    }
                }

                // 过滤无效次序 null
                if (plugId != null && plugIndex == null) {
                    if (plugIndex > 4)
//                        System.out.println("3filter,plugId="+plugId+",plugIndex="+plugIndex);
                        continue;
                }

                // 过滤无效次序 非 null
                if (plugId == null && plugIndex != null) {
//                    System.out.println("4filter,plugId="+plugId+",plugIndex="+plugIndex);
                    continue;
                }

//                System.out.println(1);

                rcmdIndexMap.get(plugIndex).add(resPlugInRcmdDo);

                rcmdPlugMap.get(plugId).add(resPlugInRcmdDo);

//                rcmdPlugAllMap.get(plugId).add(resPlugInRcmdDo);

//                System.out.println(plugId + "-" + plugIndex);
                rcmdMap.put(plugId + "-" + plugIndex, resPlugInRcmdDo);

            }


            //5 数据解析 海选数据
            // 次序
            Map<Long, PreSelectActResPlugDo> preSelectActResPlugIndexDoMap = getLastSelectPlug(preSelectActResPlugIndexDoList, rcmdIndexMap, 2);
//            System.out.println("index=" + JSON.toJSONString(preSelectActResPlugIndexDoMap));
            // 插件
            Map<Long, PreSelectActResPlugDo> preSelectActResPlugIdDoMap = getLastSelectPlug(preSelectActResPlugIdDoList, rcmdPlugMap, 1);

//            System.out.println("id=" + JSON.toJSONString(preSelectActResPlugIdDoMap));
            //6 推荐


            if (rcmd_type == 2) {
                ret = rcmdWithMap3(rcmdIndexMap, rcmdPlugMap, rcmdMap);
            }
//
            if (rcmd_type == 1) {

//                ret = rcmdWithMap2(rcmdPlugMap);

                // 测试 1.14
                ret = rcmdWithMap2041(rcmdPlugMap);
            }

            if (rcmd_type == 3) {
                if (AssertUtil.isAnyEmpty(preSelectActResPlugIdDoMap, preSelectActResPlugIndexDoMap)) {
                    ret = rcmdWithMap4(rcmdIndexMap, rcmdPlugMap, rcmdMap);
                } else {
                    if (Math.random() < 0.98) {
                        ret = rcmdWithPreSelectMap(preSelectActResPlugIndexDoMap, preSelectActResPlugIdDoMap, rcmdMap);
                    } else {
                        ret = rcmdWithMap4(rcmdIndexMap, rcmdPlugMap, rcmdMap);
                    }
                }
            }

            if (ret == null) {
                ret = rcmdMap.get("null-null");
            }
        }


        return ret;


    }


    private static Boolean valid(List<ResPlugInRcmdDo> plugList,
                                 ActFeatureDo actFeatureDo) {
        Boolean ret = true;

        if (AssertUtil.isAnyEmpty(plugList, actFeatureDo)) {
            logger.error("ResPlugInRcmdDo.rcmd() input valid ,params plugList or adxFeatureDo is null");
            ret = false;
        }
        return ret;
    }

    private static Boolean validModel(
            CODER coderModel,
            LocalTFModel ltfModel) {
        Boolean ret = true;


        if (ltfModel == null || coderModel == null) {
//            logger.error("ResPlugInRcmdDo.rcmd() input valid ,params ltfModel is null");
            ret = false;
        }


        return ret;
    }


    public static Map<Long, PreSelectActResPlugDo> getLastSelectPlug(List<PreSelectActResPlugDo> preSelectActResPlugDoList, Map<Long, List<ResPlugInRcmdDo>> rcmdKeyMap, int type) {
        Map<Long, PreSelectActResPlugDo> ret = new HashMap<>();
        Map<Date, Map<Long, PreSelectActResPlugDo>> groupMap = new HashMap<>();
        Date lastDateTime = null;
        if (AssertUtil.isAllNotEmpty(preSelectActResPlugDoList, rcmdKeyMap)) {
            for (int i = 0; i < preSelectActResPlugDoList.size(); i++) {
                PreSelectActResPlugDo preSelectActResPlugDo = preSelectActResPlugDoList.get(i);
                if (preSelectActResPlugDo != null) {
                    Date cDateTime = preSelectActResPlugDo.getCurDate();
                    Long index = preSelectActResPlugDo.getResPlugInIndex();
                    Long id = preSelectActResPlugDo.getResPlugInId();
                    if (!groupMap.containsKey(cDateTime)) {
                        groupMap.put(cDateTime, new HashMap<>());
                    }

                    // 2=id 1=index
                    Long key = type == 1 ? id : index;
                    if (type == 1 && key == null) {
                        continue;
                    }

                    if (!groupMap.get(cDateTime).containsKey(key) && rcmdKeyMap.containsKey(key)) {
                        groupMap.get(cDateTime).put(key, preSelectActResPlugDo);
                    }

                    if (lastDateTime == null) {
                        lastDateTime = cDateTime;
                    } else if (lastDateTime.before(cDateTime)) {
                        lastDateTime = cDateTime;
                    }
                }


            }
        }


        ret = groupMap.get(lastDateTime);


        return ret;
    }

    /**
     * @param plugIndexMap 次序
     * @return
     */
    public static ResPlugInRcmdDo rcmdWithMap3(Map<Long, List<ResPlugInRcmdDo>> plugIndexMap, Map<Long, List<ResPlugInRcmdDo>> plugIdMap, Map<String, ResPlugInRcmdDo> rcmdMap) {


        ResPlugInRcmdDo ret = null;

        if (AssertUtil.isAllNotEmpty(plugIndexMap, plugIdMap)) {

            // 选最优次序

            Map<Long, ResPlugInStatDo> indexMap = new HashMap<>();

            for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugIndexMap.entrySet()) {

                // 同一个次序下所有插件数据
                Long index = entry.getKey();
                List<ResPlugInRcmdDo> plugIndexList = entry.getValue();
                ResPlugInStatDo indexStatDo = ResPlugInStatModel.mergeIndexList(plugIndexList);
                indexMap.put(index, indexStatDo);
            }


            Long plugIndex = rcmdIndex(indexMap);

            List<ResPlugInRcmdDo> indexPlugList = plugIndexMap.get(plugIndex);
//            System.out.println("plugIndex=" + plugIndex);

            if (plugIndex == null) {
                ret = rcmd(indexPlugList, false);
//                System.out.println("plugId=null");
            } else {

                // 选最优插件
                Map<Long, ResPlugInStatDo> idMap = new HashMap<>();

                for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugIdMap.entrySet()) {

                    // 同一个次序下所有插件数据
                    Long id = entry.getKey();
                    List<ResPlugInRcmdDo> plugIdList = entry.getValue();
                    ResPlugInStatDo idStatDo = ResPlugInStatModel.mergeIdList(plugIdList);
                    idMap.put(id, idStatDo);
                }


                Long plugId = rcmdId(idMap);

                ret = rcmdMap.get(plugId + "-" + plugIndex);
            }


        }

        //4 返回
        return ret;
    }


    /**
     * @param plugIndexMap 次序
     * @return
     */
    public static ResPlugInRcmdDo rcmdWithMap4(Map<Long, List<ResPlugInRcmdDo>> plugIndexMap, Map<Long, List<ResPlugInRcmdDo>> plugIdMap, Map<String, ResPlugInRcmdDo> rcmdMap) {


        ResPlugInRcmdDo ret = null;

        if (AssertUtil.isAllNotEmpty(plugIndexMap, plugIdMap)) {

            // 选最优次序

            Map<Long, ResPlugInStatDo> indexMap = new HashMap<>();

            for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugIndexMap.entrySet()) {

                // 同一个次序下所有插件数据
                Long index = entry.getKey();
                List<ResPlugInRcmdDo> plugIndexList = entry.getValue();
                ResPlugInStatDo indexStatDo = ResPlugInStatModel.mergeIndexList(plugIndexList);
                indexMap.put(index, indexStatDo);
            }


            Long plugIndex = rcmdRandom(indexMap);
            Long plugId = null;
            List<ResPlugInRcmdDo> indexPlugList = plugIndexMap.get(plugIndex);
//            System.out.println("plugIndex=" + plugIndex);

            if (plugIndex != null) {

                // 选最优插件
                Map<Long, ResPlugInStatDo> idMap = new HashMap<>();

                for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugIdMap.entrySet()) {

                    // 同一个次序下所有插件数据
                    Long id = entry.getKey();
                    List<ResPlugInRcmdDo> plugIdList = entry.getValue();
                    ResPlugInStatDo idStatDo = ResPlugInStatModel.mergeIdList(plugIdList);
                    if (id != null) {
                        idMap.put(id, idStatDo);
                    }

                }


                plugId = rcmdRandom(idMap);


            }
            ret = rcmdMap.get(plugId + "-" + plugIndex);

        }

        //4 返回
        return ret;
    }

    /**
     * 海选挑插件、次序
     *
     * @param preSelectActResPlugIdDoMap
     * @param preSelectActResPlugIndexDoMap
     * @param rcmdMap
     * @return
     */
    public static ResPlugInRcmdDo rcmdWithPreSelectMap(Map<Long, PreSelectActResPlugDo> preSelectActResPlugIndexDoMap, Map<Long, PreSelectActResPlugDo> preSelectActResPlugIdDoMap, Map<String, ResPlugInRcmdDo> rcmdMap) {


        ResPlugInRcmdDo ret = null;


        // 选最优次序

        Long plugIndex = rcmdIndexAndIdWithSelect(preSelectActResPlugIndexDoMap, 2);
        Long plugId = null;

        if (plugIndex != null) {
            plugId = rcmdIndexAndIdWithSelect(preSelectActResPlugIdDoMap, 1);
        }

        ret = rcmdMap.get(plugId + "-" + plugIndex);
        //4 返回
        return ret;
    }


    /**
     * @param plugMap
     * @return
     */
    public static ResPlugInRcmdDo rcmdWithMap2(Map<Long, List<ResPlugInRcmdDo>> plugMap) {


        ResPlugInRcmdDo ret = null;
//        System.out.println(JSON.toJSONString(plugMap));

        if (AssertUtil.isNotEmpty(plugMap)) {

            List<ResPlugInRcmdDo> plugList = new ArrayList<>();
            for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugMap.entrySet()) {

                List<ResPlugInRcmdDo> plugIndexList = entry.getValue();
                if (AssertUtil.isEmpty(plugIndexList)) {
                    continue;
                }

                // 同一插件，最优次序
                if (plugIndexList.size() == 1) {
                    // 只有一个次序时
                    ResPlugInRcmdDo plugRcmdDo = plugIndexList.get(0);
                    plugList.add(plugRcmdDo);
                } else {
                    // 多个次序时
                    ResPlugInRcmdDo plugRcmdDo = getBestIndex(plugIndexList);

                    if (plugRcmdDo != null) {
                        plugList.add(plugRcmdDo);
                    }
                }

            }

            // 不同插件，最优插件
            ret = rcmd(plugList, false);

            // 相同插件，最优次序
            if (ret != null && ret.getResPlugInId() != null) {
                List<ResPlugInRcmdDo> plugIndexList = plugMap.get(ret.getResPlugInId());
                if (plugIndexList != null && plugIndexList.size() > 1) {
                    ret = rcmd(plugIndexList, true);
                }
            }

        }

        //4 返回
        return ret;
    }


    /**
     * @param plugMap
     * @return
     */
    public static ResPlugInRcmdDo rcmdWithMap(Map<Long, List<ResPlugInRcmdDo>> plugMap) {


        ResPlugInRcmdDo ret = null;

        if (AssertUtil.isNotEmpty(plugMap)) {

            List<ResPlugInRcmdDo> plugList = new ArrayList<>();

            for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugMap.entrySet()) {

                List<ResPlugInRcmdDo> plugIndexList = entry.getValue();

                // 同一插件，最优次序
                if (plugIndexList != null && plugIndexList.size() == 1) {
                    // 只有一个次序时
                    ResPlugInRcmdDo plugRcmdDo = plugIndexList.get(0);
                    plugList.add(plugRcmdDo);
                } else {
//                    System.out.println(3);
                    // 多个次序时
                    ResPlugInRcmdDo plugRcmdDo = rcmd(plugIndexList, true);

                    if (plugRcmdDo != null) {
                        plugList.add(plugRcmdDo);
                    }

                }
            }


            // 不同插件，最优插件
            ret = rcmd(plugList, false);

        }

        //4 返回
        return ret;
    }

    /**
     * @param plugMap
     * @return
     */
    public static ResPlugInRcmdDo rcmdWithMap2041(Map<Long, List<ResPlugInRcmdDo>> plugMap) {


        ResPlugInRcmdDo ret = null;

        if (AssertUtil.isNotEmpty(plugMap)) {

            Map<Long, ResPlugInRcmdDo> plugIndexMap = new HashMap<>();
            Map<ResPlugInRcmdDo, Double> weightMap = new HashMap<>();


            for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugMap.entrySet()) {
                Long plugId = entry.getKey();
                List<ResPlugInRcmdDo> plugIndexList = entry.getValue();


                if (plugId == null) {
                    if (AssertUtil.isNotEmpty(plugIndexList)) {
                        plugIndexMap.put(null, plugIndexList.get(0));

                        weightMap.put(plugIndexList.get(0), 1.0);
                    }

                } else if (plugId.equals(2041L)) {
                    if (AssertUtil.isNotEmpty(plugIndexList)) {

                        for (int i = 0; i < plugIndexList.size(); i++) {

                            ResPlugInRcmdDo resPlugInRcmdDo = plugIndexList.get(i);

                            if (resPlugInRcmdDo != null) {
                                plugIndexMap.put(resPlugInRcmdDo.getResPlugInIndex(), resPlugInRcmdDo);

                                weightMap.put(resPlugInRcmdDo, 1.0);
                            }
                        }
                    }
                }

            }

//            System.out.println(JSON.toJSONString(weightMap));

            ret = Roulette.doubleMap(weightMap);

        }

        //4 返回
        return ret;
    }


    /**
     * 插件最优次序
     *
     * @param plugIndexList
     * @return
     */
    public static ResPlugInRcmdDo getBestIndex(List<ResPlugInRcmdDo> plugIndexList) {
        ResPlugInRcmdDo ret = null;

        long size = plugIndexList.size();


        //1 获取最优RPM
        Double bestRpm = null;//最优
        String bestRpmKey = null;

        for (int i = 0; i < size; i++) {

            ResPlugInRcmdDo plugDo = plugIndexList.get(i);

            Double rpm = plugDo.getMergeRpm();
            if (rpm != null) {
                if (bestRpm == null || bestRpm < rpm) {
                    bestRpm = rpm;
                    bestRpmKey = plugDo.getKey();
                    ret = plugDo;
                }
            }
        }

        if (ret == null && plugIndexList != null) {
            ret = plugIndexList.get(0);
        }

        return ret;
    }


    /**
     * @param plugMap 海选插件 or次序
     * @param type    推荐类型 1：插件ID   2：次序
     * @return
     */
    public static Long rcmdIndexAndIdWithSelect(Map<Long, PreSelectActResPlugDo> plugMap, int type) {
        Long ret = null;


        if (AssertUtil.isNotEmpty(plugMap)) {

            List<Long> indexList = new ArrayList<>(plugMap.keySet());

            int size = indexList.size();


            //2 概率分配
            Map<Long, Double> weightMap = new HashMap<>(MAP_DF_SIZE);

            for (int i = 0; i < size; i++) {

                Long key = indexList.get(i);

                if (type == 1 && key == null) {
                    continue;
                }

                PreSelectActResPlugDo selectDo = plugMap.get(key);

                Integer isBest = selectDo.getIsBest();

                Double oWeight = selectDo.getScore();


                if (isBest != null && isBest > 0) {
                    Double subWeight = oWeight != null ? oWeight * 100 : 60.0;
                    weightMap.put(key, subWeight);

                } else {
                    Double subWeight = oWeight != null ? oWeight * 100 : 7.0;
                    weightMap.put(key, Math.min(subWeight, 7.0));
                }

            }

//            System.out.println("wmap=" + JSON.toJSONString(weightMap));
            ret = Roulette.doubleMap(weightMap);

        }


        return ret;
    }


    /**
     * @param indexMap
     * @return
     */
    public static Long rcmdRandom(Map<Long, ResPlugInStatDo> indexMap) {

        Long ret = null;
        //2 概率分配
        Map<Long, Double> weightMap = new HashMap<>(MAP_DF_SIZE);
        if (AssertUtil.isNotEmpty(indexMap)) {

            for (Map.Entry<Long, ResPlugInStatDo> entry : indexMap.entrySet()) {
                Long key = entry.getKey();
                weightMap.put(key, 1.0);
            }

            ret = Roulette.doubleMap(weightMap);

        }
        return ret;
    }

    /**
     * @param indexMap
     * @return
     */
    public static Long rcmdIndex(Map<Long, ResPlugInStatDo> indexMap) {
        Long ret = null;

        Double bestRpm = null;//最优

        Long bestIndex = null;

//        System.out.println("indexMap="+JSON.toJSONString(indexMap));
        if (AssertUtil.isNotEmpty(indexMap)) {

            List<Long> indexList = new ArrayList<>(indexMap.keySet());

            int size = indexList.size();


            Map<Long, Double> indexRpmMap = new HashMap<>();
            for (int i = 0; i < size; i++) {

                Long index = indexList.get(i);

                ResPlugInStatDo statDo = indexMap.get(index);

                Double rpm = ResPlugInStatModel.getRpm(statDo);
                indexRpmMap.put(index, rpm);

                if (rpm != null && index != null) {
                    if (bestRpm == null || bestRpm < rpm) {
                        bestRpm = rpm;
                        bestIndex = index;
                    }
                }

            }

            //2 概率分配
            Map<Long, Double> weightMap = new HashMap<>(MAP_DF_SIZE);

            for (int i = 0; i < size; i++) {
                Long index = indexList.get(i);
                Double rpm = indexRpmMap.get(index);

                if (index != null && index.equals(bestIndex)) {
                    weightMap.put(index, 85.0);
                } else {
                    weightMap.put(index, 3.0);
                }

            }

            ret = Roulette.doubleMap(weightMap);

        }


        return ret;
    }


    /**
     * @param idMap
     * @return
     */
    public static Long rcmdId(Map<Long, ResPlugInStatDo> idMap) {
        Long ret = null;

        Double bestRpm = null;//最优

        Long bestIndex = null;

        if (AssertUtil.isNotEmpty(idMap)) {

            List<Long> idList = new ArrayList<>(idMap.keySet());

            int size = idList.size();


            Map<Long, Double> indexRpmMap = new HashMap<>();
            for (int i = 0; i < size; i++) {

                Long index = idList.get(i);

                ResPlugInStatDo statDo = idMap.get(index);

                Double rpm = ResPlugInStatModel.getRpm(statDo);
                indexRpmMap.put(index, rpm);


                if (rpm != null) {
                    if (bestRpm == null || bestRpm < rpm) {
                        bestRpm = rpm;
                        bestIndex = index;
                    }
                }

            }

            //2 概率分配
            Map<Long, Double> weightMap = new HashMap<>(MAP_DF_SIZE);

            Double weightSum = 0.0;

            for (int i = 0; i < size; i++) {
                Long id = idList.get(i);
                Double rpm = indexRpmMap.get(id);

                Double weight = getRpmWeight(rpm, bestRpm);

                if (rpm == null) {
                    weight = 2.0;
                }

                if (weight != null) {
                    weightMap.put(id, weight);
                    weightSum += weight;
                } else {
                    weightMap.put(id, 1.0);
                    weightSum += 1.0;
                }


            }


            //3 权重调节

            for (int i = 0; i < size; i++) {
                Long id = idList.get(i);

                if (id == null) {
                    continue;
                }
                Double weight = weightMap.get(id);


                if (bestRpm != null) {


                    if (bestIndex != null && bestIndex.equals(id) && weight < weightSum) {

                        Double weightOther = weightSum - weight;
                        weight = weightOther * 0.85 / (1 - 0.85);
                        weightSum = weightOther + weight;
                        weightMap.put(id, weight);

                    }

                    if (bestIndex == null && id == null && weight < weightSum) {

                        Double weightOther = weightSum - weight;
                        weight = weightOther * 0.85 / (1 - 0.85);
                        weightSum = weightOther + weight;
                        weightMap.put(id, weight);
                    }

                }

            }

            // 4
            ret = Roulette.doubleMap(weightMap);

        }


        return ret;
    }

    /**
     * @param plugList
     * @return
     */
    public static ResPlugInRcmdDo rcmd(List<ResPlugInRcmdDo> plugList, boolean isIndex) {


        ResPlugInRcmdDo ret = null;


        if (AssertUtil.isEmpty(plugList)) {
            return ret;

        }
        long size = plugList.size();

        //1 获取最优RPM
        Double bestRpm = null;//最优
        String bestRpmKey = null;
        Double baseRpm = null;//不开启


        if (size == 1) {
            return plugList.get(0);
        }


        for (int i = 0; i < size; i++) {

            ResPlugInRcmdDo plugDo = plugList.get(i);

            Double rpm = plugDo.getMergeRpm();
            if (rpm != null) {
                if (bestRpm == null || bestRpm < rpm) {
                    bestRpm = rpm;
                    bestRpmKey = plugDo.getKey();
                }
            }

            if (plugDo.getResPlugInId() == null && plugDo.getResPlugInIndex() == null) {
                baseRpm = plugDo.getMergeRpm();
            }
        }


        //2 概率分配
        Map<ResPlugInRcmdDo, Double> weightMap = new HashMap<>(MAP_DF_SIZE);

        Double weightSum = 0.0;

        for (int i = 0; i < size; i++) {

            ResPlugInRcmdDo plugDo = plugList.get(i);


            Double rpm = plugDo.getMergeRpm();

            Double weight = getRpmWeight(rpm, bestRpm);

            if (plugDo.getSRpm() == null) {
                weight = MathBase.noiseSmoother(weight, 1.0, 2.0);
            }

            // 有统计数据 效果较差插件 ，按概率放弃
            if (plugDo.getSRpm() != null && weight < 1) {
                if (Math.random() > 0.5) {
                    weight = 0.1;
                }
            }

            // 统计数据不足 限制权重
//            if(plugDo.getSRpm()!=null&& weight>20){
//
//                if(plugDo.getResPlugInStatDo()!=null &&  plugDo.getResPlugInStatDo().getVisitPv()!=null){
//                    Long visitPv= plugDo.getResPlugInStatDo().getVisitPv();
//                   if(visitPv<=100){
//                       weight=Math.min(10,weight);
//                   }
//                    if(visitPv>100 && visitPv<=200){
//                        weight=Math.min(20,weight);
//                    }
//                    if(visitPv>200 && visitPv<=500){
//                        weight=Math.min(30,weight);
//                    }
//                }
//            }


            if (weight != null) {
                weightMap.put(plugDo, weight);
                weightSum += weight;
            } else {
                weightMap.put(plugDo, 1.0);
                weightSum += 1.0;
            }

        }
        // 权重调节
        /**
         * base：不低于%5
         * index=0，不大于10%（保守配置）
         *
         */

//        System.out.println(JSON.toJSONString(weightMap));
//        System.out.println(weightSum);
        for (Map.Entry<ResPlugInRcmdDo, Double> entry : weightMap.entrySet()) {
            ResPlugInRcmdDo plugDo = entry.getKey();
            Double weight = entry.getValue();

//            System.out.println("key="+plugDo.getKey()+",weight="+weight);
            // index=0，挑选次序
            if (isIndex) {
//
//                if (plugDo.getResPlugInIndex() == 0L || plugDo.getResPlugInIndex() == 3L) {
//                    weight = min(weight, (weightSum - weight) * 0.05);
//                }

                if (plugDo.getResPlugInIndex() == 3L) {
                    if (weight > weightSum * 0.05 && weight < weightSum) {

                        Double weightOther = weightSum - weight;

                        weight = weightOther * 0.05 / (1 - 0.05);
                        weightSum = weightOther + weight;
                        weightMap.put(plugDo, weight);


                    }

                }

//                if (plugDo.getResPlugInIndex() == 0L) {
//                    if (weight > weightSum * 0.05) {
//
//                        Double weightOther = weightSum - weight;
//                        weight = weightOther * 0.05 / (1 - 0.05);
//                        weightSum = weightOther + weight;
//                    }
//
//                }


                if (bestRpmKey != null && plugDo != null) {

                    if (bestRpmKey.equals(plugDo.getKey()) && weight < weightSum) {

                        Double weightOther = weightSum - weight;
                        weight = weightOther * 0.90 / (1 - 0.90);
                        weightSum = weightOther + weight;
                        weightMap.put(plugDo, weight);

                    }
                }


            }

            // base：不低于%5 不大于10%
            if (!isIndex) {

                if (plugDo.getResPlugInIndex() == null) {

//                    weight = MathBase.noiseSmoother(weight, weightSum * 0.05, weightSum * 0.20);
//                    if (weight < weightSum * 0.05) {
//                        Double weightOther = weightSum - weight;
//                        weight = weightOther * 0.05 / (1 - 0.05);
//                        weightSum = weightOther + weight;
//                        weightMap.put(plugDo, weight);
//
//                    }

                    if (weight > weightSum * 0.2 && weight < weightSum) {
                        Double weightOther = weightSum - weight;
                        weight = weightOther * 0.2 / (1 - 0.2);
                        weightSum = weightOther + weight;
                        weightMap.put(plugDo, weight);

                    }
//                    weight = weightSum * 0.05;//固定比例
                }

                if (bestRpmKey != null && plugDo != null && plugDo.getSRpm() != null) {

                    if (bestRpmKey.equals(plugDo.getKey()) && weight < weightSum) {

                        Double weightOther = weightSum - weight;
                        weight = weightOther * 0.85 / (1 - 0.85);
                        weightSum = weightOther + weight;

//                        weight = MathBase.noiseSmoother(weight, weightSum * 0.85, weightSum * 0.90);
                    }
                }
            }

//            System.out.println("key="+plugDo.getKey()+",weightnew="+weight);
            weightMap.put(plugDo, weight);
        }


//        System.out.println("weightMap=" + JSON.toJSONString(weightMap));

        //3 挑选
        ret = Roulette.doubleMap(weightMap);

        //4 返回
        return ret;
    }


    /**
     * @param rpm
     * @param bestRpm
     * @return
     */
    private static Double getRpmWeight(Double rpm, Double bestRpm) {
        Double ret = 0.001;

        if (rpm != null && bestRpm != null) {

            Double ratio = DataUtil.division(rpm, bestRpm, 3);
            if (bestRpm >= 0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            }

        }

        return ret;
    }


    /**
     * @param pRpm
     * @param sRpm
     * @return
     */
    private static Double getMergeRpm(Double pRpm, Double sRpm, double statWeight) {

        Double ret = pRpm;

        if (pRpm == null) {
            ret = sRpm;
        }

        if (sRpm != null && pRpm != null) {

            if (sRpm <= 0) {
                sRpm = 0.0;
            } else {
                pRpm = MathBase.noiseSmoother(pRpm, 0.5 * sRpm, 2.0 * sRpm);
            }
            ret = (1 - statWeight) * pRpm + statWeight * sRpm;
        }


        return ret;
    }


}
