package cn.com.duiba.nezha.alg.alg.activity;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class ActivitySubParams {


    private double factor = 1.0;//调节因子


    private double statRatio = 0.0;//只是调节比例

    private Boolean isNew;//是否新活动

    private Double statEcpm;//统计ecpm

    private Double statEcpm2;//统计ecpm,理论消耗

    private Boolean isConfidence;//是否置信

    private boolean conf;//统计数据是否置信


    /**
     * 统计数据
     */
    public long actReqCntPv;//活动请求PV

    public long expCntPv;//券曝光

    public long adClickPv;//计费点击



    public long landpageClickPv;//广告落地页点击PV

    public long targetConvertPv;//广告后端目标转化PV

    public long fee;//计费金额

    public long theoryFee;//广告计费-理论

    public long alpha;
    public long beta;



    private String updateTime;//更新时间


    /**
     * 取实际ecpm和理论ecpm的最大值
     *
     * @return
     */
    public Double getEcpm() {
        if (statEcpm == null) {
            return statEcpm2;
        }

        if (statEcpm2 == null) {
            return statEcpm;
        }

        return Math.max(statEcpm, statEcpm2);
    }

}
