package cn.com.duiba.nezha.alg.alg.advert.v2;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.ee.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ee.AdExploreModel;
import cn.com.duiba.nezha.alg.alg.vo.ee.AppGroupDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;

import java.util.*;


@Slf4j
public class BidJichengStrategy {


    public static void main(String[] args) {

    }


    /**
     * 批量接口
     *
     * @param controlResultMap 出价返回对象
     * @return
     */
    public static void jichengExplore(Map<String, AdBidResultDo> controlResultMap, Map<Long, AdExploreModel> adEEModelMap) {


        /**
         * 获取top广告排序
         */

        List<AdBidResultDo> adBidResultDoList = new ArrayList<>();

        for (Map.Entry<String, AdBidResultDo> entry : controlResultMap.entrySet()) {

            adBidResultDoList.add(entry.getValue());

            //排序分/ecpm更新
            scoreUpdate(entry.getValue());

            //继承状态更新
            jichengInfoUpdate(entry.getValue(), adEEModelMap);

        }

        Collections.sort(adBidResultDoList);


        /**
         * top1广告
         */
        AdBidResultDo top1 = adBidResultDoList.get(0);

        /**
         *  一键继承
         */

        jichengExplore(top1, controlResultMap, adEEModelMap);
    }

    /**
     * 批量接口
     *
     * @param controlResultMap 出价返回对象
     * @return
     */
    public static void jichengExplore(AdBidResultDo top1, Map<String, AdBidResultDo> controlResultMap, Map<Long, AdExploreModel> adEEModelMap) {


        /**
         * 判断 top1广告 是否可被继承：满足 优质广告 且 继承占比要求
         */
        boolean jichengStatus = false;
        if (top1.getIsHighQualityAd() != null && top1.getIsHighQualityAd()) {

            if (top1.getJcRatio() != null) {
                if (Math.random() < top1.getJcRatio()) {
                    jichengStatus = true;
                }
            }
        }

        if (!jichengStatus) {
            return;
        }


        Long top1AdvertId = top1.getAdvertId();
        Long topAccount = top1.getAccountId();
        Double topEcpm = top1.getEcpm();

        /**
         * 挑选继承候选计划，满足：开启继承、广告主相同、计划不相同、ocpc配置
         */

        List<AdBidResultDo> jichengList = new ArrayList<>();

        for (Map.Entry<String, AdBidResultDo> entry : controlResultMap.entrySet()) {

            AdBidResultDo adBidResultDo = entry.getValue();

            //条件：
            if (jichengValid(top1AdvertId, topAccount, adBidResultDo)) {
                jichengList.add(adBidResultDo);
            }

        }

        /**
         * 继承
         */
        jichengControl(topEcpm, jichengList);

    }


    /**
     * 判断是否开启继承，且与top广告相同广告主，不同计划ID
     *
     * @param jichengList
     * @return
     */

    public static void jichengControl(Double topEcpm, List<AdBidResultDo> jichengList) {

        if (AssertUtil.isEmpty(jichengList)) {
            return;
        }

        /**
         * 随机挑选
         */
        Random random = new Random();
        int rand = random.nextInt(jichengList.size());
        AdBidResultDo adBidResultDo = jichengList.get(rand);


        /**
         * 出价调节
         */
        Double ecpm = adBidResultDo.getEcpm();
        Long fee = adBidResultDo.getFee();

        long feeNew = Math.round(topEcpm / ecpm * fee) + 1;

        /**
         * 信息更新
         */
        adBidResultDo.setFee(feeNew);
        adBidResultDo.setJichengSuc(true);


        adBidResultDo.getAdBidParamsDo().setFee(feeNew);
        adBidResultDo.getAdBidParamsDo().setJcFee(feeNew);
        adBidResultDo.getAdBidParamsDo().setJichengSuc(true);


    }


    /**
     * 判断是否开启继承，且与top广告相同广告主，不同计划ID
     * <p>
     * 条件：开启继承、广告主相同、计划不相同、ocpc配置
     *
     * @param adBidResultDo
     * @return
     */

    public static boolean jichengValid(Long topAd, Long topAccount, AdBidResultDo adBidResultDo) {

        boolean ret = false;

        // 开启继承
        if (adBidResultDo.getIsJiCheng() != null && adBidResultDo.getIsJiCheng()) {

            // 广告主相同
            if (topAccount.equals(adBidResultDo.getAccountId())) {

                //计划不相同
                if (!topAd.equals(adBidResultDo.getAdvertId())) {

                    // ocpc配置
                    if (adBidResultDo.getChargeType() == 2) {
                        ret = true;
                    }
                }
            }

        }


        return ret;
    }


    /**
     * 一键继承
     *
     * @param adBidResultDo
     */
    public static void jichengInfoUpdate(AdBidResultDo adBidResultDo, Map<Long, AdExploreModel> adEEModelMap) {


        Long advertId = adBidResultDo.getAdvertId();
        AdExploreModel adExploreModel = adEEModelMap.get(advertId);

        if (adExploreModel == null) {
            return;
        }

        Boolean isJiCheng = adExploreModel.getIsJiCheng();

        Boolean isHighQualityAd = adExploreModel.getIsHighQualityAd();

        Double jcRatio = adExploreModel.getJcRatio();

        adBidResultDo.setIsJiCheng(isJiCheng);
        adBidResultDo.setIsHighQualityAd(isHighQualityAd);
        adBidResultDo.setJcRatio(jcRatio);


    }

    /**
     * 一键继承
     *
     * @param adBidResultDo
     */
    public static void scoreUpdate(AdBidResultDo adBidResultDo) {
        Double score = adBidResultDo.getCtr() * adBidResultDo.getFee();
        adBidResultDo.setScore(score);
        adBidResultDo.setEcpm(score);


    }

}
