package cn.com.duiba.nezha.alg.alg.advertexploitbak;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ResultDto {

    /**
     * 广告ID
     */
    private Long advertId ;

    /**
     * 配置ID
     */
    private Long orientationId;

    /**
     * 各个通道得分
     */
    private Map<MatcherEnum, Double> scoreMap;

    /**
     * 新广告标识 0-非新广告 1-新广告
     */
    private Integer newAdvert;

    /**
     * 探索结束标识
     */
    private Integer exploreFlag;

    /**
     * 预估偏差
     */
    private Double predictBias;


    public String getKey() {
        return this.advertId + "_" + this.orientationId;
    }

}
