package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.*;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorReqDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.parse.RtaFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author duiba
 */
public class AdxRcmd {

    public static final double COLD_RATE = 0.25;
    public static final double[] weightList = {100, 40, 20, 10, 5, 4, 3, 2, 1, 1};
    private static final Logger logger = LoggerFactory.getLogger(AdxRcmd.class);

    /**
     * 1.构建特征
     * 描述：构建可投计划的特征(无创意素材特征)
     *
     * @param adxIdeaAdFeatureDos 计划动态特征
     * @param adxFeatureDo        静态特征
     * @param ideaAppStatsList    计划统计信息
     * @param resoAppStats        资源位统计信息
     * @return <计划ID, 特征集合>
     */
    public static Map<Long, FeatureMapDo> getFeatureMap(List<AdxIdeaAdFeatureDo> adxIdeaAdFeatureDos, AdxFeatureDo adxFeatureDo,
                                                        Map<Long, AdxStatsDo> ideaAppStatsList, AdxStatsDo resoAppStats) {

        Map<Long, FeatureMapDo> featureMap = new HashMap<>();
        ideaAppStatsList = Optional.ofNullable(ideaAppStatsList).orElse(new HashMap<>());

        //1 非计划特征：静态特征解析
        AdxIndexStatsDo resoApp1HourInfo = AdxStatData.getAdxTimeIndex(resoAppStats, "1hour");
        adxFeatureDo.setResoAppExpCntDay(resoApp1HourInfo.getExpCnt());
        adxFeatureDo.setResoAppClickCntDay(resoApp1HourInfo.getClickCnt());
        adxFeatureDo.setResoAppAdCostDay(resoApp1HourInfo.getAdvertConsume());
        Map<String, String> staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic(adxFeatureDo);

        // 1.1 用户打分特征（rta打分模型）：静态特征解析
        if (adxFeatureDo.getRtaFeatureDo() != null) {
            Map<String, String> userStaticFeatureMap = RtaFeatureParse.generateFeatureMapStatic(adxFeatureDo.getRtaFeatureDo(), null);
            staticFeatureMap.putAll(userStaticFeatureMap);
        }


        //2 计划特征：动态特征解析
        if (AssertUtil.isEmpty(adxIdeaAdFeatureDos)) {
            logger.warn("AdxRcmd.getFeatureMap adxIdeaAdFeatureDos is null");
            return featureMap;
        }
        for (AdxIdeaAdFeatureDo ideaAdDo : adxIdeaAdFeatureDos) {

            //计划
            Long ideaId = ideaAdDo.getIdeaId();
            AdxFeatureDo dynamicDo = new AdxFeatureDo();
            BeanUtils.copy(ideaAdDo, dynamicDo);

            //计划+分媒体行为特征
            AdxStatsDo ideaAppStats = ideaAppStatsList.get(ideaId);
            AdxIndexStatsDo ideaApp1DayInfo = AdxStatData.getAdxTimeIndex(ideaAppStats, "1day");
            dynamicDo.setIdeaAppExpCntDay(ideaApp1DayInfo.getExpCnt()); //计划+百度appId 当天曝光次数
            dynamicDo.setIdeaAppClickCntDay(ideaApp1DayInfo.getClickCnt()); //计划+百度appId 当天点击次数
            dynamicDo.setIdeaAppAdCostDay(ideaApp1DayInfo.getAdvertConsume()); //计划+百度appId 当天广告消耗
            dynamicDo.setIdeaAppLaunchCntDay(ideaApp1DayInfo.getAdvertLaunch()); //计划+百度appId 当天发券
            dynamicDo.setIdeaAppAdClickCntDay(ideaApp1DayInfo.getAdvertClick()); //计划+百度appId 当天点券

            Map<String, String> dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic2(dynamicDo, adxFeatureDo);

            //3 封装计划特征集合
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMap.put(ideaId, featureMapDo);

        }

        return featureMap;
    }


    /**
     * 2.模型预估
     * 描述：计划维度的指标预估
     *
     * @param featureMap  可投计划特征集合
     * @param model       模型
     * @param predictType 模型类型
     * @return <计划ID, 预估值>
     */
    public static Map<Long, Double> predict(Map<Long, FeatureMapDo> featureMap, Model model, PredictType predictType)
            throws Exception {

        Map<Long, Double> ret = new HashMap<>();

        if (AssertUtil.isAnyEmpty(featureMap, model, predictType)) {
            logger.warn("AdxRcmd.predict params is not valid featureMap:{},predictType:{}", JSON.toJSONString(featureMap), JSON.toJSONString(predictType));
            return ret;
        }

        if (predictType == PredictType.CTR) {
            ret = model.predictCtr(featureMap);
        } else if (predictType == PredictType.PVLAUNCH) {
            ret = model.predictLaunchPv(featureMap);
        } else if (predictType == PredictType.ARPU) {
            ret = model.predictARPU(featureMap);
        } else if (predictType == PredictType.PVLAUNCHV2) {
            ret = model.predictLaunchPvV2(featureMap);
        } else if (predictType == PredictType.ARPUV2) {
            ret = model.predictARPUV2(featureMap);
        } else if (predictType == PredictType.CLICKPV) {
            ret = model.predictClickPv(featureMap);
        } else if (predictType == PredictType.ADCPC) {
            ret = model.predictAdCpc(featureMap);
        } else if (predictType == PredictType.SCORE) {
            ret = model.predictUserScore(featureMap);
        } else if (predictType == PredictType.SCOREV2) {
            ret = model.predictUserScoreV2(featureMap);
        } else if (predictType == PredictType.ADCPCV2) {
            ret = model.predictAdCpcV2(featureMap);
        } else if (predictType == PredictType.CTR_V2) {
            ret = model.predictCtr_V2(featureMap);
        } else if (predictType == PredictType.CLICKPV_V2) {
            ret = model.predictClickPv_V2(featureMap);
        }

        return ret;
    }


    /**
     * 3.算法出价
     * 描述：计划维度的算法出价和rankscore
     *
     * @param adIdeaDos   可投计划信息
     * @param adxAppReqDo 流量信息
     * @return 可投计划的出价和rankscore
     */
    public static List<AdxBidRet> bidding(List<AdIdeaDo> adIdeaDos, AdxAppReqDo adxAppReqDo) {

        List<AdxBidRet> adxBidRets = new ArrayList<>();

        try {
            adxBidRets = adIdeaDos.stream().map(adIdeaDo -> {
                Long ideaId = adIdeaDo.getIdeaId();
                Long resId = adIdeaDo.getResId();
                AdxFactorDo adxfactorDo = Optional.ofNullable(adIdeaDo.getAdxFactorDo()).orElse(new AdxFactorDo());
                AdxBidReq adxBidReq = AdxBid.buildAdxBidReq(adIdeaDo, adxfactorDo, adxAppReqDo);
                return AdxBid.getBid(adxBidReq);
            }).collect(Collectors.toList());

        } catch (Exception e) {
            logger.error("AdxRcmd.bidding error", e);
        }

        return adxBidRets;
    }


    /**
     * 4.挑选素材
     * 描述：top1计划下挑选素材（EE算法）
     *
     * @param adIdeaDo    top1计划
     * @param ideaUnitDos top1计划可投素材
     * @param recallList  创意素材召回池（根据资源位ID+计划id从redis取）
     * @return top1计划下的top1素材
     */
    public static AdxBidRet getIdeaUnit(AdxBidRet adIdeaDo, List<IdeaUnitDo> ideaUnitDos, List<IdeaUnitDo> recallList) {

        if (AssertUtil.isEmpty(adIdeaDo) || adIdeaDo.getIdeaId() == null) {
            logger.warn("AdxRcmd.getIdeaUnit adIdeaDo is null");
            return adIdeaDo;
        }

        Long ideaId = adIdeaDo.getIdeaId();
        if (AssertUtil.isEmpty(ideaUnitDos) || ideaUnitDos.size() < 1) {
            logger.warn("AdxRcmd.getIdeaUnit ideaUnitDos is null, adxIdeaId = {}", JSON.toJSONString(ideaId));
            return adIdeaDo;
        }

        //如果该计划，只有单一可选素材
        if (ideaUnitDos.size() == 1 && AssertUtil.isNotEmpty(ideaUnitDos.get(0))
                && AssertUtil.isNotEmpty(ideaUnitDos.get(0).getIdeaUnitId())) {
            adIdeaDo.setIdeaUnitId(ideaUnitDos.get(0).getIdeaUnitId());
            return adIdeaDo;
        }

//        List<IdeaUnitDo> recallList = AdxRcmdBase.getIdeaUnitList(ideaId, recallDos);

        //创意召回池
        if (AssertUtil.isEmpty(recallList) || recallList.size() < 1) {
            logger.info("AdxRcmd.getIdeaUnit recallList is null, adxIdeaId = {} ", JSON.toJSONString(ideaId));
            Collections.shuffle(ideaUnitDos);
            adIdeaDo.setIdeaUnitId(ideaUnitDos.get(0).getIdeaUnitId());
            return adIdeaDo;
        }

        //如与创意素材无交集，随机挑选素材
        List<IdeaUnitDo> interList = AdxRcmdBase.getInterList(ideaUnitDos, recallList);
        if (AssertUtil.isEmpty(interList) || interList.size() < 1) {
            logger.info("AdxRcmd.getIdeaUnit interList is null, adxIdeaId = {} ", JSON.toJSONString(ideaId));
            Collections.shuffle(ideaUnitDos);
            adIdeaDo.setIdeaUnitId(ideaUnitDos.get(0).getIdeaUnitId());
            return adIdeaDo;

        } else {

            long coldSize = 10L, bestSize = 10L;
            //冷启动池(定时任务每个ratioType最多10个)
            List<IdeaUnitDo> coldList = interList.stream().filter(interDo -> interDo.getIsNew())
                    .sorted(Comparator.comparing(IdeaUnitDo::getLt7DExp)).limit(coldSize).collect(Collectors.toList());
            //优选池(定时任务每个ratioType最多10个)
            List<IdeaUnitDo> bestList = interList.stream().filter(interDo -> !interDo.getIsNew())
                    .sorted(Comparator.comparing(IdeaUnitDo::getAdEcpm).reversed()).limit(bestSize).collect(Collectors.toList());

            //20%概率来自于冷启动池，80%概率来自于优选池
            List<IdeaUnitDo> candidates;
            if (bestList.size() == 0 || (coldList.size() > 0 && Math.random() < 0.2)) {
                candidates = coldList;
            } else {
                candidates = bestList;
            }

            Map<IdeaUnitDo, Double> weightMap = AdxRcmdBase.getWeightMap(candidates, weightList);
            IdeaUnitDo retIdeaUnitDo = Roulette.doubleMap(weightMap);
            adIdeaDo.setIdeaUnitId(retIdeaUnitDo.getIdeaUnitId());
            return adIdeaDo;
        }

    }


    /**
     * 6 计划创意召回任务
     * 描述：获取每个可投计划下的冷启动池和优选池
     * 部署：5min执行1次，不同资源位调用一次算法接口，输出按资源位id存redis，打印log
     *
     * @param recallReqDo <计划，创意>入参
     * @return <计划，创意>召回池
     */
    public static AdxRecallRetDo recallAdIdea(AdxRecallReqDo recallReqDo) {

        AdxRecallRetDo ret = new AdxRecallRetDo();
        try {
            ret = AdxRcmdAlg.recallAdIdeaRun(recallReqDo);

        } catch (Exception e) {
            logger.error("AdxRcmd.recallAdIdea", e);
        }
        return ret;
    }


    /**
     * 7.计划控制参数任务
     * 描述：ROI控制策略，PID算法，三种维度（计划，计划+联盟媒体，计划+联盟媒体行业），生成roi调节因子；
     * 计划冷启动探价控制，监控近12h的探价竞价成功率和预算消耗程度 ，生成探价因子；
     * 部署：10min执行1次，按 计划+联盟媒体 维度调用算法接口，输出按三种维度控制参数，存redis，打印log
     *
     * @param adxFactorReqDo 入参
     * @return 控制参数
     */
    public static AdxFactorDo adIdeaFactorRun(AdxFactorReqDo adxFactorReqDo) {

        AdxFactorDo ret = adxFactorReqDo.getAdxFactorDo();
        try {
            ret = AdxRcmdAlg.adIdeaFactorRun(adxFactorReqDo);

        } catch (Exception e) {
            logger.error("AdxRcmd.ideaFactorRun", e);
        }
        return ret;
    }


    /**
     * 8.广告位控制参数任务
     * 描述：广告位探量控制，生成广告位探量因子[1,3]（初始值=1.5），探价流量比例[0%,10%]（初始值=5%）
     * 部署：10min执行1次，不同联盟广告位id调用一次算法接口，输出按联盟广告位id存redis，打印log（广告位id较多）
     *
     * @param slotFactorReqDo 入参
     * @return 控制参数
     */
    public static SlotFactorDo slotFactorRun(SlotFactorReqDo slotFactorReqDo) {

        SlotFactorDo ret = slotFactorReqDo.getSlotFactorDo();
        try {
            ret = AdxRcmdAlg.slotFactorRun(slotFactorReqDo);

        } catch (Exception e) {
            logger.error("AdxRcmd.slotFactorRun", e);
        }
        return ret;
    }


    //    /**
//     * 1.粗排
//     * 描述：可投<计划，创意> 列表与召回池取交集，按ecpm排序，个数限制 limitSize=20；
//     *
//     * @param adIdeaDos 参竞列表(not null)
//     * @param recallDos 召回池
//     * @param limitSize 粗排结果长度(not null)
//     * @return 粗排结果
//     */
//    public static List<AdIdeaDo> rawRank(List<AdIdeaDo> adIdeaDos, List<AdIdeaDo> recallDos, Integer limitSize) {
//
//        try {
//
//            if (AssertUtil.isEmpty(adIdeaDos) || adIdeaDos.size() < 1) {
//                logger.warn("AdxRcmd.rawRank adIdeaDos is null");
//                return null;
//            }
//
//            //参竞列表展平
//            List<IdeaUnitDo> ideaUnitList = adIdeaDos.stream().flatMap(ideaUnit ->
//                    ideaUnit.getIdeaUnitDos().stream()).collect(Collectors.toList());
//            //冷启动状态
////            logger.info("AdxRcmd.rawRank adIdeaDos is {}", JSON.toJSONString(adIdeaDos));
//            Map<Long, Boolean> coldStartMap = adIdeaDos.stream().collect(Collectors.toMap(AdIdeaDo::getIdeaId, AdIdeaDo::getIsColdStart));
//
//            //召回池为空时，随机选取
//            if (AssertUtil.isEmpty(recallDos) || recallDos.size() < 1) {
//                logger.warn("AdxRcmd.rawRank recallDos is null，resId is {}, ideaUnitList size is {}", adIdeaDos.get(0).getResId(), ideaUnitList.size());
//                return AdxRcmdBase.getRandomList(ideaUnitList, limitSize, coldStartMap);
//            }
//
//            //参竞列表&召回池 获取交集
//            List<AdIdeaDo> interDos = AdxRcmdBase.getIntersection(adIdeaDos, recallDos);
//
//            //交集个数为空, 随机选取
//            if (interDos == null || interDos.size() < 1) {
//                logger.warn("AdxRcmd.rawRank getIntersection is null，resId is {}, ideaUnitList size is {}", adIdeaDos.get(0).getResId(), ideaUnitList.size());
//                logger.info("AdxRcmd.rawRank getIntersection is null，resId is {}, ideaUnitList size is {}, adIdeaDos is {}, recallDos is {}",
//                        adIdeaDos.get(0).getResId(), ideaUnitList.size(), JSON.toJSONString(adIdeaDos), JSON.toJSONString(recallDos));
//                return AdxRcmdBase.getRandomList(ideaUnitList, limitSize, coldStartMap);
//            }
//
//            List<IdeaUnitDo> interList = interDos.stream().flatMap(ideaUnit -> ideaUnit.getIdeaUnitDos().stream()).collect(Collectors.toList());
//            logger.info("AdxRcmd.rawRank getIntersection size is {}, resId is {},", interList.size(), adIdeaDos.get(0).getResId());
//
//
//            //交集个数>limitSize, 按新创意25%和统计ecpm排序75%进行截断
//            if (interList.size() > limitSize) {
//
//                //粗排池分配
//                List<IdeaUnitDo> newList = interList.stream().filter(ideaUnitDo -> ideaUnitDo.getIsNew()).collect(Collectors.toList());
//                List<IdeaUnitDo> oldList = interList.stream().filter(ideaUnitDo -> !ideaUnitDo.getIsNew()).collect(Collectors.toList());
//                long coldSize = AdxRcmdBase.getRecallSize(newList, oldList, limitSize, COLD_RATE, "COLD");
//                long bestSize = AdxRcmdBase.getRecallSize(newList, oldList, limitSize, COLD_RATE, "BEST");
//                List<IdeaUnitDo> coldList = newList.stream().sorted(Comparator.comparing(IdeaUnitDo::getLast1DayExpCnt)).limit(coldSize).collect(Collectors.toList());
//                List<IdeaUnitDo> bestList = oldList.stream().sorted(Comparator.comparing(IdeaUnitDo::getStatAdEcpm).reversed()).limit(bestSize).collect(Collectors.toList());
//
//                List<IdeaUnitDo> interList2 = new ArrayList<>();
//                interList2.addAll(coldList);
//                interList2.addAll(bestList);
//                List<AdIdeaDo> interCandidates = AdxRcmdBase.getCovertList(interList2);
//                interCandidates.forEach(s -> s.setIsColdStart(coldStartMap.get(s.getIdeaId())));
//                return interCandidates;
//
////                List<IdeaUnitDo> interList2 = interList.stream().sorted(Comparator.comparing(IdeaUnitDo::getStatAdEcpm, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).
////                        limit(limitSize).collect(Collectors.toList());
//            } else {
//                return interDos;
//            }
//
//
//        } catch (Exception e) {
//            logger.error("AdxRcmd.rawRank error", e);
//            return null;
//        }
//
//    }
//
//
//
//    /**
//     * 5.精排
//     */
//    public static List<AdxBidRet> fineRank(List<AdxBidRet> adxBidRets) {
//
//        List<AdxBidRet> fineRankRets = adxBidRets.stream().sorted(Comparator.comparing(AdxBidRet :: getRankScore).reversed()).collect(Collectors.toList());
//        AdxBidRet ret = fineRankRets.get(0);
//        if (Math.random() < 0.2) {
//            Map<AdxBidRet, Double> scoreMap = adxBidRets.stream().collect(Collectors.toMap(s -> s, AdxBidRet::getRankScore));
//            ret = Roulette.doubleMap(scoreMap);
//        }
//
//        //新创意试投（调整出价大于底价以上）
//        if (ret != null && ret.getBasePrice() != null
//                && (ret.getIsNew() != null && ret.getIsNew())
//                && Math.random() < 0.1) {
//            Long basePrice = DataUtil.double2Long(ret.getBasePrice());
//            ret.setAdxAlgoPrice(Math.max(ret.getAdxAlgoPrice(), (basePrice + 1L)));
//        }
//        return Arrays.asList(ret);
//    }


}
