package cn.com.duiba.nezha.alg.alg.coldstartandexplore.util;

import cn.com.duiba.nezha.alg.alg.vo.strongtargetexplore.STEParams;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;

/**
 * 加权函数
 */
public class WeightingFunction {
    private static final Logger logger= LoggerFactory.getLogger(WeightingFunction.class);

    /**
     * CVR调整系数
     */
    public static HashMap<String, Object> getAdjustWeight(STEParams steParams, List<Long> clickList, List<Double> cvrList, String paramType, Long hisClick, Double staCvr) {
        HashMap<String, Object> res = new HashMap<String, Object>();

        double adjustWeight = 1.0;
        double minDimsStatCvr = GetCvr.getMinDimsStatCvr(steParams, clickList, cvrList, paramType);
        Integer sepStageThreshold;
        Integer coldStartThreshold1;
        Integer coldStartThreshold2;
        Integer coldStartThreshold3;

        // 根据paramType变量查看取哪套参数
        if (paramType.equals("firstSet")) {
            sepStageThreshold = steParams.getSepStageThreshold();
            coldStartThreshold1 = steParams.getColdStartThreshold1();
            coldStartThreshold2 = steParams.getColdStartThreshold2();
            coldStartThreshold3 = steParams.getColdStartThreshold3();
        }else {
            sepStageThreshold = steParams.getSepStageThresholdSet2();
            coldStartThreshold1 = steParams.getColdStartThresholdSet4();
            coldStartThreshold2 = steParams.getColdStartThresholdSet5();
            coldStartThreshold3 = steParams.getColdStartThresholdSet6();
        }

        if (hisClick < sepStageThreshold) {             // 冷启阶段
            boolean b = staCvr <= Math.pow(10, -8) || staCvr < 0.4 * minDimsStatCvr;
            if (coldStartThreshold1 <= hisClick && hisClick < coldStartThreshold2) {
                adjustWeight = b ? 0.9 : 1.0;
            }else if (coldStartThreshold2 <= hisClick && hisClick < coldStartThreshold3) {
                if (b) {adjustWeight = 0.8;}else if (staCvr < 0.7 * minDimsStatCvr) {adjustWeight = 0.9;}else {adjustWeight = 1.0;}
            }else if (hisClick >= coldStartThreshold3) {
                if (b) {adjustWeight = 0.7;}else if (staCvr < 0.7 * minDimsStatCvr) {adjustWeight = 0.8;}else {adjustWeight = 1.0;}
            }else { adjustWeight = 1.0; }
        }else{              // 起量阶段
            if (staCvr <= Math.pow(10, -8)) { adjustWeight = 0.1; } else { adjustWeight = 0.3 + 0.6 * Math.min(1, MathUtil.division(hisClick, 2000, 6));}
        }
        res.put("adjustWeight", adjustWeight);
        res.put("minDimsStatCvr", minDimsStatCvr);

        return res;
    }

    /**
     * 曝光次数加权函数
     */
    public static double functionOfExpose(Long exposeCnt, STEParams steParams, String paramType) {
        double res = 1.0;
        double k = 1.0;
        double b = 1.0;
        Integer exposeConfidenceThreshold = 600;

        if (paramType.equals("firstSet")) {
            k = steParams.getExposureK1();
            b = steParams.getExposureUpperBound1();
            exposeConfidenceThreshold = steParams.getExposeConfidenceThreshold2();
        }else {
            k = steParams.getExposureK2();
            b = steParams.getExposureUpperBound2();
            exposeConfidenceThreshold = steParams.getExposeConfidenceThresholdSet5();
        }

        if (exposeCnt <= exposeConfidenceThreshold) {
            res = k * exposeCnt + b;
        }

        return res;
    }

    /**
     * 随序的衰减函数
     * 目前版本中三个系数设计：private double alpha = 0.6;private double beta = 1.1;private double bias = 0.0; 遵循零和博弈原则
     */
    public static double decreaseFunc(int index, STEParams steParams) {
        double alpha = steParams.getAlpha();
        double beta = steParams.getBeta();
        double bias = steParams.getBias();

        return beta * Math.exp(-1*alpha*(index-bias));
    }

}
