package cn.com.duiba.nezha.alg.alg.vo.ee;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data

/**
 * 计划粒度
 */
public class AdExploreModel {


    private Long advertId;//计划ID


    /**
     * 一键继承 参数
     */
    private Boolean isJiCheng;//是否开启一键继承(历史曝光<10000 且开启继承)

    private Boolean isHighQualityAd;//优质计划，可被继承计划标记

    private Double jcRatio;//优质计划，可被继承计划，继承发券占比  0~50%

    private String updateTime;//更新时间


    /**
     * 探价参数
     * 维度：广告、广告+媒体包、广告+广告位
     * 功能：起量/复苏/冷启动
     */
    // 计划
    private AdControlParams adEEParams;

    //Map<媒体包，参数>>
    private Map<String, AdControlParams> appGroupEEParamsMap = new HashMap<>();

    //计划下：Map<广告位，参数>>
    private Map<Long, AdControlParams> slotEEParamsMap = new HashMap<>();


    /**
     * 一键起量
     * 维度：广告_配置
     * 功能：指定计划/配置，提价至指定比例，并按Max(新出价,原价，二价)出价
     * <p>
     * 状态：暂缓，类似扶持功能
     * <p>
     * 功能：
     * 1、设置指定最高成本，原成本
     * 2、出价调节：若原成本可以拿量，按原成本出价；若原成本拿不到量，按新成本出价
     * <p>
     * 约束：生效门槛，原出价不得低于行业均价、新出价/原出价>10%
     * <p>
     * 风险：竞价系统被攻击，原出价偏低风险
     */

    //Map<配置ID,参数>
    private Map<Long, AdControlParams> qiliangParamsMap = new HashMap<>();


    public static Double getExploreFactor(AdControlParams adControlParams) {

        if (adControlParams != null) {

            return adControlParams.getExploreFactor();
        } else {
            return null;
        }
    }
}
