package cn.com.duiba.nezha.alg.alg.vo.kaihu;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class RoiControlModel {

    /**
     * 广告位 数据
     * Map<广告位ID，参数>
     */
    Map<Long, RoiControlParams> roiControlParamsMap = new HashMap<>();


    /**
     * 参数更新时间
     */
    String updateTime;


    /**
     * 广告位参数
     *
     * @param slotId
     * @return
     */
    public RoiControlParams getRoiControlParams(Long slotId) {

        if (roiControlParamsMap.get(slotId) == null) {
            roiControlParamsMap.put(slotId, new RoiControlParams());
        }
        return roiControlParamsMap.get(slotId);
    }

    /**
     * 广告位参数
     *
     * @param slotId
     * @return
     */
    public void putRoiControlParams(Long slotId, RoiControlParams roiControlParams) {

        roiControlParamsMap.put(slotId, roiControlParams);
    }

}
