package cn.com.duiba.nezha.alg.alg.adsupport;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.vo.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;

import java.util.HashMap;
import java.util.Map;

public class KaAdvertSupport {
    /**
     * 计费金额置信权重计算
     */
    static double[] costWeightBucket = {50, 200, 500, 1000, 2000};
    static double[] costWeight = {0, 0.3, 0.8, 1, 1};


    /**
     * 计费金额对应转化个数置信权重计算
     */
    static double[] costEffectWeightBucket = {10, 20, 50, 100, 200};
    static double[] costEffectWeight = {0, 0.3, 0.8, 1, 1};


    /**
     * 计费偏差-熔断因子计算
     */
    static double[] slotBiasBucket = {0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 1.0, 2.0, 3.0, 5.0};
    static double[] slotBiasWeight = {0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 16};


    static double[] globalBiasBucket = {0, 0.1, 0.2, 0.3, 0.5, 1.0, 2.0};
    static double[] globalBiasWeight = {0.1, 0.12, 0.18, 0.5, 1, 1, 2};


    static double[] supportRatioBucket = {0, 0.1, 0.2, 0.3, 0.5, 0.8, 1.0};
    static double[] supportRatioWeight = {1.0, 0.8, 0.6, 0.3, 0.1, 0.1,0.0};


    public static Double circuitBreakerNew(KaAdvertSupportInfo supportAdvert) {

        Double ret = 0.5;
        if (AssertUtil.isEmpty(supportAdvert)) {
            return ret;
        }

        Double circuitBreakerFactor = circuitBreaker(supportAdvert);

        if (circuitBreakerFactor != null) {

            /**
             * 熔断因子
             */
            ret = circuitBreakerFactor;

        }

        return ret;

    }




    /**
     * 广告位熔断接口
     *
     * @param supportAdvert
     * @return
     */
    public static Double circuitBreaker(KaAdvertSupportInfo supportAdvert) {

        Double ret = null;
        if (AssertUtil.isEmpty(supportAdvert)) {
            return ret;
        }
        KaAdvertSupportInfo adDo = supportAdvert;

        if (adDo != null && adDo.getSupportCost()!= null && adDo.getSupportCost() > 0) {

            /**
             * 广告全局
             */
            BiasAndConfidenceDo adBias = costBias(adDo.getConsume(), adDo.getConvertPV(), adDo.getSupportCost(), 1);
            /**
             * 广告位
             */
            BiasAndConfidenceDo adSlotBias = costBias(adDo.getAppConsume(), adDo.getAppConvertPV(), adDo.getSupportCost(), 2);
            /**
             * 融合
             *
             */
            Double breakerScore = circuitBreaker(adBias, adSlotBias);

            ret = breakerScore;

            }

        return ret;
    }


    /**
     * 广告位熔断
     */
    public static Double circuitBreaker(BiasAndConfidenceDo adBias, BiasAndConfidenceDo adSlotBias) {

        Double breakerScore = 0.0;
//        if (AssertUtil.isAllEmpty(adBias, adSlotBias)) {
////            return ret;
//        }

        Double biasFactor = adBias.getBiasFactor() * adSlotBias.getBiasFactor();
        Double confidenceCostWeight = adBias.getConfidenceCostWeight() * adSlotBias.getConfidenceCostWeight();
        Double confidenceEffectWeight = adBias.getConfidenceCostEffectWeight() * adSlotBias.getConfidenceCostEffectWeight();

        breakerScore = biasFactor * confidenceCostWeight * confidenceEffectWeight;

        return DataUtil.formatDouble(breakerScore, 3);
    }



    /**
     * 计算成本偏差
     *
     * @param consume
     * @param landingPageClickPV
     * @param aFee
     * @return
     */
    public static BiasAndConfidenceDo costBias(Long consume, Long landingPageClickPV, long aFee, int type) {
        BiasAndConfidenceDo ret = new BiasAndConfidenceDo();
        Double bias = 0D;
        Double confidence = 0D;


        Double costConfidenceWeight = 1.1;
        Double costEffectConfidenceWeight = 1.1;

        Double globalBiasFactor = 2.0;
        Double slotBiasFactor = 20.0;

        if (aFee > 0) {

            if (consume == null) {
                consume = 0L;
            }

            if (landingPageClickPV == null) {
                landingPageClickPV = 0L;
            }

            if (consume <= 1) {
                bias = 0D;
                confidence = 0D;
            } else if (landingPageClickPV == null || landingPageClickPV < 1) {

                bias = DataUtil.division(consume, aFee, 3);
                confidence = DataUtil.division(consume, aFee, 2);

            } else {
                bias = DataUtil.division(consume, aFee * landingPageClickPV, 3) - 1.0;
                confidence = DataUtil.division(consume, aFee, 2);

            }

            /**
             * 偏差-因子
             */
            if (type == 1) {
                globalBiasFactor = getConfidenceWeight(bias, globalBiasBucket, globalBiasWeight, globalBiasFactor);
                ret.setBiasFactor(globalBiasFactor);
            } else {
                slotBiasFactor = getConfidenceWeight(bias, slotBiasBucket, slotBiasWeight, slotBiasFactor);
                ret.setBiasFactor(slotBiasFactor);
            }

            /**
             * 消耗金额 置信因子
             */
            costConfidenceWeight = getConfidenceWeight(consume / 100, costWeightBucket, costWeight, costConfidenceWeight);

            /**
             * 消耗对应转换个数 置信因子
             */
            costEffectConfidenceWeight = getConfidenceWeight(confidence, costEffectWeightBucket, costEffectWeight, costEffectConfidenceWeight);


            ret.setConfidenceCostWeight(costConfidenceWeight);
            ret.setConfidenceCostEffectWeight(costEffectConfidenceWeight);


        }


        /**
         * 消耗金额
         */
        ret.setConsume(consume);
        /**
         * 偏差比例
         */
        ret.setBias(bias);
        /**
         * 消耗对应转化个数
         */
        ret.setConfidence(confidence);


        return ret;
    }

    /**
     *  NEW扶持权重因子
     *
     * @param budgetSmoothDo
     * @param advertSupportInfoDo
     * @return
     */

    public static Double biddingFactor(BudgetSmoothDo budgetSmoothDo,
                                       KaAdvertSupportInfo advertSupportInfoDo,
                                       String expNum) {
        Double ret = 1.0;

        if (AssertUtil.isAnyEmpty(advertSupportInfoDo, budgetSmoothDo)) {
            return ret;
        }

        Double circuitBreakerFactor = circuitBreakerNew(advertSupportInfoDo);

        Double ratio = (budgetSmoothDo.getRatio() == null) ? 0.9 : budgetSmoothDo.getRatio();


        if (AssertUtil.isAnyEmpty(ratio, circuitBreakerFactor)) {
            return advertSupportInfoDo.getLowerLimit();
        }

        if (circuitBreakerFactor < 0.99) {
            /**
             * 1、预算消耗速度：核心指标，越小，扶持力度越大,平滑函数[1～2]
             *
             */
            ratio = ratio < 0.99 ? ratio : 0.99;

            double supportRatio = supportRatio(advertSupportInfoDo);

            double factor = 0.5 * supportRatio + 0.5 * (1 - ratio);

            double smoothFactor = advertSupportInfoDo.getLowerLimit() + (advertSupportInfoDo.getUpperLimit() - advertSupportInfoDo.getLowerLimit()) * factor;

            smoothFactor =  MathBase.noiseSmoother(smoothFactor,advertSupportInfoDo.getLowerLimit(),advertSupportInfoDo.getUpperLimit());


            if("exp".equals(expNum) && advertSupportInfoDo.getIsWhite()){
                double factor1 = division(advertSupportInfoDo.getPreCvr(),advertSupportInfoDo.getCvrLimit());
                factor1 = Math.max(Math.min(factor1,1.5),0.7);
                smoothFactor = smoothFactor * factor1;
                smoothFactor =  MathBase.noiseSmoother(smoothFactor,1.0,advertSupportInfoDo.getUpperLimit());

            }

            ret = DataUtil.formatDouble(smoothFactor, 4);
        }

        return ret;
    }

    public static Double division(Double v1, Double v2) {
        return (v1 != null && v2 != null && v2 != 0)  ? v1 / v2 : 0.0;
    }



    public static Double supportRatio(KaAdvertSupportInfo advertSupportInfoDo){
        double ret = 1.0;
        if (AssertUtil.isAnyEmpty(advertSupportInfoDo)) {
            return ret;
        }
        if(advertSupportInfoDo.getSupportLaunch()== null|| advertSupportInfoDo.getAppSupportLaunch()== null) {
            return ret;
        }
        double advertRatio = advertSupportInfoDo.getSupportLaunch()/(advertSupportInfoDo.getAdvertLaunchLimit()+1.0);
        double appRatio = advertSupportInfoDo.getSupportLaunch()/(advertSupportInfoDo.getAdvertLaunchLimit()+1.0);

        //分桶
        double advertRatioWeight = getConfidenceWeight(advertRatio, supportRatioBucket, supportRatioWeight,0.1);
        double appRatioWeight = getConfidenceWeight(appRatio, supportRatioBucket, supportRatioWeight,0.1);


        double ratioWeight =  0.7 * appRatioWeight + 0.3 * advertRatioWeight;
        return ratioWeight;


    }


    /**
     * 平滑分桶函数
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Double getConfidenceWeight(double value, double[] bucketList, double[] weightList, double defaultValue) {
        double ret = defaultValue;

        if (bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {
            double lastWeight = weightList[0];
            double lastBound = bucketList[0];
            for (int i = 0; i < bucketList.length; i++) {
                double bound = bucketList[i];
                if (value <= bound) {
                    double curWeight = weightList[i];
                    double curBound = bucketList[i];
                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                    } else {
                        ret = curWeight;
                    }

                    break;
                }
                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }
        }

        return DataUtil.formatDouble(ret, 3);
    }



    public static void main (String[] args){
        double i = getConfidenceWeight(0.4, globalBiasBucket, globalBiasWeight, 2.0);
        System.out.println(i);
        double slotBiasFactor = getConfidenceWeight(0.4, slotBiasBucket, slotBiasWeight, 2.0);
        System.out.println(slotBiasFactor);


        double costConfidenceWeight = getConfidenceWeight(50000 / 100, costWeightBucket, costWeight, 1.1);
        double costEffectConfidenceWeight = getConfidenceWeight(50000/1000, costEffectWeightBucket, costEffectWeight, 1.1);
        System.out.println(costConfidenceWeight);
        System.out.println(costEffectConfidenceWeight);


    }

}
