package cn.com.duiba.nezha.alg.alg.advert;

public class ChargeControl {


    /**
     * 计费环节，成本控制
     * <p>
     * 解决成本偏高情况下，计费问题
     *
     * 策略:超成本金额大于阈值时，熔断，使用底价计费
     *
     * @param fee      本次点击计费，单位：分
     * @param floorFee 点击底价计费，单位：分
     * @param cost     当日实际消耗，单位：分
     * @param cpaCost  当日理论消耗，单位：分
     * @param deepCost 当日深度消耗，单位：分
     * @return
     */
    public static int getNewFee(int fee, int floorFee, int cost, int cpaCost, int deepCost) {
        int ret = fee;

        if (cost == 0) {
            cost = 100;
        }

        /**
         * 1、冗余超成本金额计算（最大多收费）
         * 默认不大于5% 且 不小于50元 且不大于250元
         */
        int diffCost = (int) Math.round(deepCost * 0.05);//多收费
        deepCost = Math.max(50 * 100, deepCost);
        deepCost = Math.min(250 * 100, deepCost);


        /**
         * 2、计费熔断
         * 判断：实际消耗大于50元，且大于 深度消耗+冗余超成本
         */
        if (cost > 50 * 100 && cost > (deepCost + diffCost)) {
            ret = floorFee;
        }
        return ret;
    }
}
