/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.advertexploitbak.matcher;

import cn.com.duiba.nezha.alg.alg.advertexploitbak.CandidateDto;
import cn.com.duiba.nezha.alg.alg.advertexploitbak.matcher.MatcherParams;
import cn.com.duiba.nezha.alg.alg.advertexploitbak.model.DSSMLocalTFModel;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VectorMatcher {
    public static List<CandidateDto> dssmMatch(DSSMLocalTFModel model, Map<String, String> featureMap, List<String> orientList, MatcherParams matcherParams) throws UnsupportedEncodingException {
        Map<String, List> predResult = model.predict(featureMap);
        List adpkUnionList = new ArrayList();
        List scoreList = new ArrayList();
        for (String resultKey : predResult.keySet()) {
            if (predResult.get(resultKey).get(0).getClass() == String.class) {
                adpkUnionList = predResult.get(resultKey);
                continue;
            }
            scoreList = predResult.get(resultKey);
        }
        HashMap scoreMap = new HashMap();
        for (int i = 0; i < adpkUnionList.size(); ++i) {
            scoreMap.put(adpkUnionList.get(i), scoreList.get(i));
        }
        ArrayList<CandidateDto> candidateDtos = new ArrayList<CandidateDto>();
        for (String adpk : orientList) {
            CandidateDto candidateDto = new CandidateDto();
            candidateDto.setAdPkOnce(adpk);
            candidateDto.setScore(Double.valueOf(scoreMap.getOrDefault(adpk, Float.valueOf(0.0f)).floatValue()));
            candidateDtos.add(candidateDto);
        }
        candidateDtos.sort(Comparator.comparing(CandidateDto::getScore).reversed());
        List<CandidateDto> candidateDtosTopk = candidateDtos.subList(0, Math.min(matcherParams.getMaxMatchNum(), candidateDtos.size()));
        return candidateDtosTopk;
    }

    public static void main(String[] args) throws Exception {
        String path = "C:\\Users\\wangyaole\\Desktop\\nezha\\model\\dssm01";
        DSSMLocalTFModel model = new DSSMLocalTFModel();
        MatcherParams matcherParams = new MatcherParams();
        model.loadModel(path);
        HashMap<String, String> featureMap = new HashMap<String, String>();
        String colStr = "f501001,f504001,f508005,f108001,f201001,f507001,f503001,f406001,f502001,f502002,afee,ad_pk";
        String valStr = "Android,HLK-AL00,\u8363\u8000,325913,70125,3,3609,1,16,2,7.2,72093_177812";
        String[] colList = colStr.split(",");
        String[] valList = valStr.split(",");
        for (int i = 0; i < colList.length - 2; ++i) {
            featureMap.put(colList[i], valList[i]);
        }
        String pkStr = "73672_178993,71121_173168,65521_176061,68810_178437,49829_178811,73041_177565,67320_177930,67320_178039,68837_178357,62556_177938,67320_179069,72917_177183,73524_0,72764_177427,68810_177405,68810_178808,67320_178976,72260_178946,73639_0,73526_0,73363_0,72917_177492,68810_173191,68810_175292,72093_177812";
        List<String> orientList = Arrays.asList(pkStr.split(","));
        List<CandidateDto> candidateDtos = VectorMatcher.dssmMatch(model, featureMap, orientList, matcherParams);
        System.out.println(candidateDtos);
    }
}

