/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.IdeaUnitDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxRcmdBase {
    private static final Logger logger = LoggerFactory.getLogger(AdxRcmdBase.class);

    public static List<AdIdeaDo> getIntersection(List<AdIdeaDo> list1, List<AdIdeaDo> list2) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{list1, list2})) {
            return null;
        }
        return list1.stream().filter(a -> list2.stream().anyMatch(b -> {
            if (!Objects.equals(a.getIdeaId(), b.getIdeaId())) {
                return false;
            }
            List<IdeaUnitDo> collect = a.getIdeaUnitDos().stream().filter(c -> b.getIdeaUnitDos().stream().anyMatch(d -> {
                if (!Objects.equals(c.getIdeaUnitId(), d.getIdeaUnitId())) {
                    return false;
                }
                c.setAdEcpm(d.getAdEcpm());
                c.setIsNew(d.getIsNew());
                c.setLt1DAdCost(d.getLt1DAdCost());
                c.setLt1DExp(d.getLt1DExp());
                c.setRatioType(d.getRatioType());
                return true;
            })).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                return false;
            }
            a.setIdeaUnitDos(collect);
            return true;
        })).collect(Collectors.toList());
    }

    public static List<AdIdeaDo> getRandomList(List<IdeaUnitDo> ideaUnitList, Integer limitSize, Map<Long, Boolean> coldStartMap) {
        List<IdeaUnitDo> candidateList;
        if (ideaUnitList.size() <= limitSize) {
            candidateList = ideaUnitList;
        } else {
            Collections.shuffle(ideaUnitList);
            candidateList = ideaUnitList.subList(0, limitSize);
        }
        List<AdIdeaDo> candidates = AdxRcmdBase.getCovertList(candidateList);
        candidates.forEach(s -> s.setIsColdStart((Boolean)coldStartMap.get(s.getIdeaId())));
        return candidates;
    }

    public static List<AdIdeaDo> getCovertList(List<IdeaUnitDo> ideaUnitList) {
        ArrayList adIdeaDoList = new ArrayList();
        ideaUnitList.stream().forEach(ido -> {
            AdIdeaDo tmpAdIdeaDo = new AdIdeaDo();
            tmpAdIdeaDo.setIdeaId(ido.getAdIdeaId());
            ArrayList<IdeaUnitDo> tmpIdeaUnitDos = new ArrayList<IdeaUnitDo>();
            tmpIdeaUnitDos.add((IdeaUnitDo)ido);
            tmpAdIdeaDo.setIdeaUnitDos(tmpIdeaUnitDos);
            adIdeaDoList.add(tmpAdIdeaDo);
        });
        HashMap adIdeaMap = new HashMap();
        adIdeaDoList.stream().forEach(ado -> {
            AdIdeaDo tmp = (AdIdeaDo)adIdeaMap.get(ado.getIdeaId());
            if (tmp == null) {
                adIdeaMap.put(ado.getIdeaId(), ado);
            } else {
                tmp.getIdeaUnitDos().addAll(ado.getIdeaUnitDos());
            }
        });
        ArrayList<AdIdeaDo> ret = new ArrayList<AdIdeaDo>(adIdeaMap.values());
        return ret;
    }

    public static Map<Integer, List<IdeaUnitDo>> aggregateByRatioType(List<IdeaUnitDo> ideaUnitDos) {
        HashMap<Integer, List<IdeaUnitDo>> ideaUnitMap = new HashMap<Integer, List<IdeaUnitDo>>();
        ideaUnitDos.stream().forEach(ado -> {
            Integer ratioType = ado.getRatioType();
            if (ratioType == null) {
                logger.warn("ratioType is null, adIdeaId is {}, ideaUnitId is {}", (Object)ado.getAdIdeaId(), (Object)ado.getIdeaUnitId());
                return;
            }
            List subList = (List)ideaUnitMap.get(ratioType);
            if (subList == null) {
                ArrayList<IdeaUnitDo> tmp = new ArrayList<IdeaUnitDo>();
                tmp.add((IdeaUnitDo)ado);
                ideaUnitMap.put(ratioType, tmp);
            } else {
                subList.add(ado);
            }
        });
        return ideaUnitMap;
    }

    public static Map<Long, Map<Integer, List<IdeaUnitDo>>> aggregateByAdRatioType(List<IdeaUnitDo> ideaUnitDos) {
        HashMap<Long, Map<Integer, List<IdeaUnitDo>>> retMap = new HashMap<Long, Map<Integer, List<IdeaUnitDo>>>();
        ideaUnitDos.stream().forEach(ado -> {
            Long adIdeaId = ado.getAdIdeaId();
            if (adIdeaId == null) {
                logger.warn("adIdeaId is null, ideaUnitId is {}", (Object)ado.getIdeaUnitId());
                return;
            }
            Integer ratioType = ado.getRatioType();
            if (ratioType == null) {
                logger.warn("ratioType is null, adIdeaId is {}, ideaUnitId is {}", (Object)ado.getAdIdeaId(), (Object)ado.getIdeaUnitId());
                return;
            }
            Map ratioTypeMap = (Map)retMap.get(adIdeaId);
            if (ratioTypeMap == null) {
                HashMap tmpRatioTypeMap = new HashMap();
                ArrayList<IdeaUnitDo> tmp = new ArrayList<IdeaUnitDo>();
                tmp.add((IdeaUnitDo)ado);
                tmpRatioTypeMap.put(ratioType, tmp);
                retMap.put(adIdeaId, tmpRatioTypeMap);
            } else {
                List subList = (List)ratioTypeMap.get(ratioType);
                if (subList == null) {
                    ArrayList<IdeaUnitDo> tmp = new ArrayList<IdeaUnitDo>();
                    tmp.add((IdeaUnitDo)ado);
                    ratioTypeMap.put(ratioType, tmp);
                } else {
                    subList.add(ado);
                }
                retMap.put(adIdeaId, ratioTypeMap);
            }
        });
        return retMap;
    }

    public static List<IdeaUnitDo> getIdeaUnitList(Long ideaId, List<AdIdeaDo> adIdeaDos) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{ideaId, adIdeaDos}) || adIdeaDos.size() < 1) {
            return null;
        }
        List<IdeaUnitDo> ret = null;
        for (int i = 0; i < adIdeaDos.size(); ++i) {
            AdIdeaDo adIdeaDo = adIdeaDos.get(i);
            Long tmp = adIdeaDo.getIdeaId();
            if (tmp == null || !tmp.equals(ideaId)) continue;
            ret = adIdeaDo.getIdeaUnitDos();
            break;
        }
        return ret;
    }

    public static List<IdeaUnitDo> getInterList(List<IdeaUnitDo> list1, List<IdeaUnitDo> list2) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{list1, list2}) || list1.size() < 1 || list2.size() < 1) {
            return null;
        }
        return list1.stream().filter(a -> list2.stream().anyMatch(b -> {
            if (!Objects.equals(a.getIdeaUnitId(), b.getIdeaUnitId())) {
                return false;
            }
            a.setIsNew(b.getIsNew());
            a.setAdEcpm(b.getAdEcpm());
            a.setLt7DExp(b.getLt7DExp());
            return true;
        })).collect(Collectors.toList());
    }

    public static Map<IdeaUnitDo, Double> getWeightMap(List<IdeaUnitDo> ideaUnitList, double[] weightList) {
        HashMap<IdeaUnitDo, Double> ret = new HashMap<IdeaUnitDo, Double>();
        for (int i = 0; i < ideaUnitList.size(); ++i) {
            double weight = weightList[i];
            ret.put(ideaUnitList.get(i), weight);
        }
        return ret;
    }

    public static long getRecallSize(List<IdeaUnitDo> newList, List<IdeaUnitDo> oldList, int limitSize, double coldRate, String type) {
        long coldSize = DataUtil.double2Long((Double)((double)limitSize * coldRate));
        long bestSize = (long)limitSize - coldSize;
        if ((long)newList.size() <= coldSize && (long)oldList.size() <= bestSize) {
            coldSize = newList.size();
            bestSize = oldList.size();
        } else if ((long)newList.size() <= coldSize) {
            coldSize = newList.size();
            bestSize = (long)limitSize - coldSize;
        } else if ((long)oldList.size() <= bestSize) {
            bestSize = oldList.size();
            coldSize = (long)limitSize - bestSize;
        }
        long ret = 0L;
        if ("COLD".equals(type)) {
            return coldSize;
        }
        if ("BEST".equals(type)) {
            return bestSize;
        }
        return ret;
    }

    public static AdxIndexStatDo getStatusVo(AdxIndexStatDo adxStatBaseDo, Integer bidMode, Double target) {
        AdxIndexStatDo ret = Optional.ofNullable(adxStatBaseDo).orElse(new AdxIndexStatDo());
        Boolean isConfident = AdxRcmdBase.isConfident(adxStatBaseDo);
        Long bidCnt = AdxIndexStatDo.getBidCnt(adxStatBaseDo);
        Long sucCnt = AdxIndexStatDo.getBidSucCnt(adxStatBaseDo);
        Long expCnt = AdxIndexStatDo.getExpCnt(adxStatBaseDo);
        Long clickCnt = AdxIndexStatDo.getClickCnt(adxStatBaseDo);
        Long launchCnt = AdxIndexStatDo.getLaunchCnt(adxStatBaseDo);
        Long adClickCnt = AdxIndexStatDo.getAdClickCnt(adxStatBaseDo);
        Long adxCost = AdxIndexStatDo.getAdxCost(adxStatBaseDo);
        Long adCost = AdxIndexStatDo.getAdCost(adxStatBaseDo);
        Long adTargetFee = AdxIndexStatDo.getTargetFee(adxStatBaseDo);
        Long adCost2 = AdxIndexStatDo.getAdCost2(adxStatBaseDo);
        ret.setIsConfident(isConfident);
        ret.setBid(bidCnt);
        ret.setBidSuc(sucCnt);
        ret.setExp(expCnt);
        ret.setClick(clickCnt);
        ret.setAdvertLaunch(launchCnt);
        ret.setAdvertClick(adClickCnt);
        ret.setAdxCost(adxCost);
        ret.setAdCost(adCost);
        ret.setAdTargetFee(adTargetFee);
        ret.setAdCost2(adCost2);
        double avgFactor = AdxRcmdBase.getAvgFactor(adxStatBaseDo);
        double actRoi = DataUtil.division((Long)(adCost2 + 100L), (Long)(adxCost + 100L), (int)4);
        double actCpc = DataUtil.division((Long)(adxCost + 100L), (Long)(clickCnt + 1L), (int)4);
        double actValue = bidMode == 2 ? DataUtil.division((Double)((double)adxCost.longValue() + 10.0 * target), (Long)(clickCnt + 10L), (int)4) : DataUtil.division((Double)((double)adxCost.longValue() + 1000.0 * target), (Long)(adCost + 1000L), (int)4);
        double bias = AdxRcmdBase.getBias(ret, target, bidMode, actValue, 0.0);
        double sucRate = DataUtil.division((Long)sucCnt, (Long)(bidCnt + 100L), (int)4);
        double sucExpRate = DataUtil.division((Long)expCnt, (Long)(bidCnt + 100L), (int)4);
        double adEcpm = DataUtil.division((Long)(adCost * 1000L), (Long)(expCnt + 10L), (int)4);
        ret.setAvgfactor(avgFactor);
        ret.setBias(bias);
        ret.setActRoi(actRoi);
        ret.setActCpc(actCpc);
        ret.setActValue(actValue);
        ret.setSucRate(sucRate);
        ret.setSucExpRate(sucExpRate);
        ret.setAdEcpm(adEcpm);
        return ret;
    }

    public static double getBias(AdxIndexStatDo statDo, Double target, Integer bidMode, double actValue, Double defaultValue) {
        double ret = defaultValue;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{statDo, target, bidMode, actValue})) {
            ret = DataUtil.division((Double)(actValue - target), (Double)target, (int)4);
            ret = statDo.getIsConfident() != false ? MathUtil.stdwithBoundary((double)ret, (double)-0.5, (double)0.5) : (AdxRcmdBase.isCostConfident(statDo) ? MathUtil.stdwithBoundary((double)ret, (double)-0.2, (double)0.2) : MathUtil.stdwithBoundary((double)ret, (double)-0.1, (double)0.1));
        }
        return ret;
    }

    public static boolean isCostConfident(AdxIndexStatDo adxIndexStatDo) {
        boolean ret = false;
        if (adxIndexStatDo != null && AdxIndexStatDo.getAdxCost(adxIndexStatDo) > 1000L) {
            ret = true;
        }
        return ret;
    }

    public static boolean isExpConfident(AdxIndexStatDo adxIndexStatDo) {
        boolean ret = false;
        if (adxIndexStatDo != null && AdxIndexStatDo.getExpCnt(adxIndexStatDo) > 500L) {
            ret = true;
        }
        return ret;
    }

    public static boolean isClickConfident(AdxIndexStatDo adxIndexStatDo) {
        boolean ret = false;
        if (adxIndexStatDo != null && AdxIndexStatDo.getClickCnt(adxIndexStatDo) > 100L) {
            ret = true;
        }
        return ret;
    }

    public static boolean isConfident(AdxIndexStatDo adxIndexStatDo) {
        boolean ret = false;
        if (AdxRcmdBase.isCostConfident(adxIndexStatDo) || AdxRcmdBase.isClickConfident(adxIndexStatDo)) {
            ret = true;
        }
        return ret;
    }

    public static Double getStatCtr(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && AdxIndexStatDo.getExpCnt(adxIndexStatDo) > 200L) {
            ret = DataUtil.division((Long)AdxIndexStatDo.getClickCnt(adxIndexStatDo), (Long)AdxIndexStatDo.getExpCnt(adxIndexStatDo), (int)5);
        }
        return ret;
    }

    public static Double getStatCtr(AdxIndexStatDo adxIndexStatDo, Double baseValue) {
        Double ret = AdxRcmdBase.getStatCtr(adxIndexStatDo);
        ret = MathUtil.mean((Double)ret, (Double)baseValue, (Double)0.5);
        return ret;
    }

    public static Double getStatCtr(Double base, AdxIndexStatDo minStat, AdxIndexStatDo hourStat, AdxIndexStatDo dayStat) {
        double r1 = 0.5;
        double r2 = 0.3;
        double r3 = 0.2;
        double mergeExpCnt = r1 * (double)AdxIndexStatDo.getExpCnt(minStat).longValue() + r2 * (double)AdxIndexStatDo.getExpCnt(hourStat).longValue() + r3 * (double)AdxIndexStatDo.getExpCnt(dayStat).longValue();
        double mergeClickCnt = r1 * (double)AdxIndexStatDo.getClickCnt(minStat).longValue() + r2 * (double)AdxIndexStatDo.getClickCnt(hourStat).longValue() + r3 * (double)AdxIndexStatDo.getClickCnt(dayStat).longValue();
        Double stat = DataUtil.division((Double)mergeClickCnt, (Double)(mergeExpCnt + 1.0), (int)5);
        Double ret = MathUtil.mean((Double)base, (Double)stat, (Double)0.7);
        return DataUtil.formatDouble((Double)ret, (int)5);
    }

    public static Double getStatPvLaunch(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && AdxIndexStatDo.getClickCnt(adxIndexStatDo) > 100L) {
            ret = DataUtil.division((Long)AdxIndexStatDo.getLaunchCnt(adxIndexStatDo), (Long)AdxIndexStatDo.getClickCnt(adxIndexStatDo), (int)5);
        }
        return ret;
    }

    public static Double getStatPvLaunch(AdxIndexStatDo adxIndexStatDo, Double baseValue) {
        Double ret = AdxRcmdBase.getStatPvLaunch(adxIndexStatDo);
        ret = MathUtil.mean((Double)ret, (Double)baseValue, (Double)0.5);
        return ret;
    }

    public static Double getStatPvLaunch(Double base, AdxIndexStatDo minStat, AdxIndexStatDo hourStat, AdxIndexStatDo dayStat) {
        double r1 = 0.5;
        double r2 = 0.3;
        double r3 = 0.2;
        double mergeClickCnt = r1 * (double)AdxIndexStatDo.getClickCnt(minStat).longValue() + r2 * (double)AdxIndexStatDo.getClickCnt(hourStat).longValue() + r3 * (double)AdxIndexStatDo.getClickCnt(dayStat).longValue();
        double mergeLaunchCnt = r1 * (double)AdxIndexStatDo.getLaunchCnt(minStat).longValue() + r2 * (double)AdxIndexStatDo.getLaunchCnt(hourStat).longValue() + r3 * (double)AdxIndexStatDo.getLaunchCnt(dayStat).longValue();
        Double stat = DataUtil.division((Double)mergeLaunchCnt, (Double)(mergeClickCnt + 1.0), (int)5);
        Double ret = MathUtil.mean((Double)base, (Double)stat, (Double)0.7);
        return DataUtil.formatDouble((Double)ret, (int)5);
    }

    public static Double getStatArpu(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && AdxIndexStatDo.getLaunchCnt(adxIndexStatDo) > 50L) {
            ret = DataUtil.division((Long)AdxIndexStatDo.getAdCost(adxIndexStatDo), (Long)AdxIndexStatDo.getLaunchCnt(adxIndexStatDo), (int)5);
        }
        return ret;
    }

    public static Double getStatArpu(AdxIndexStatDo adxIndexStatDo, Double baseValue) {
        Double ret = AdxRcmdBase.getStatArpu(adxIndexStatDo);
        ret = MathUtil.mean((Double)ret, (Double)baseValue, (Double)0.5);
        return ret;
    }

    public static Double getStatArpu(Double base, AdxIndexStatDo minStat, AdxIndexStatDo hourStat, AdxIndexStatDo dayStat) {
        double r1 = 0.5;
        double r2 = 0.3;
        double r3 = 0.2;
        double mergeLaunchCnt = r1 * (double)AdxIndexStatDo.getLaunchCnt(minStat).longValue() + r2 * (double)AdxIndexStatDo.getLaunchCnt(hourStat).longValue() + r3 * (double)AdxIndexStatDo.getLaunchCnt(dayStat).longValue();
        double mergeAdCost = r1 * (double)AdxIndexStatDo.getAdCost(minStat).longValue() + r2 * (double)AdxIndexStatDo.getAdCost(hourStat).longValue() + r3 * (double)AdxIndexStatDo.getAdCost(dayStat).longValue();
        Double stat = DataUtil.division((Double)mergeAdCost, (Double)(mergeLaunchCnt + 1.0), (int)5);
        Double ret = MathUtil.mean((Double)base, (Double)stat, (Double)0.7);
        return DataUtil.formatDouble((Double)ret, (int)5);
    }

    public static Double getStatEcpm(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && AdxIndexStatDo.getExpCnt(adxIndexStatDo) > 500L) {
            ret = DataUtil.division((Long)(AdxIndexStatDo.getAdCost(adxIndexStatDo) * 1000L), (Long)AdxIndexStatDo.getExpCnt(adxIndexStatDo), (int)5);
        }
        return ret;
    }

    public static Double getStatEcpm(AdxIndexStatDo adxIndexStatDo, Double baseValue) {
        Double ret = AdxRcmdBase.getStatEcpm(adxIndexStatDo);
        ret = MathUtil.mean((Double)ret, (Double)baseValue, (Double)0.5);
        return ret;
    }

    public static Double getStatEcpm(Double base, AdxIndexStatDo minStat, AdxIndexStatDo hourStat, AdxIndexStatDo dayStat) {
        double r1 = 0.5;
        double r2 = 0.3;
        double r3 = 0.2;
        double mergeExpCnt = r1 * (double)AdxIndexStatDo.getExpCnt(minStat).longValue() + r2 * (double)AdxIndexStatDo.getExpCnt(hourStat).longValue() + r3 * (double)AdxIndexStatDo.getExpCnt(dayStat).longValue();
        double mergeAdCost = r1 * (double)AdxIndexStatDo.getAdCost(minStat).longValue() + r2 * (double)AdxIndexStatDo.getAdCost(hourStat).longValue() + r3 * (double)AdxIndexStatDo.getAdCost(dayStat).longValue();
        Double stat = DataUtil.division((Double)(mergeAdCost * 1000.0), (Double)(mergeExpCnt + 1.0), (int)5);
        Double ret = MathUtil.mean((Double)base, (Double)stat, (Double)0.7);
        return DataUtil.formatDouble((Double)ret, (int)5);
    }

    public static Double getStatCpm(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && AdxIndexStatDo.getExpCnt(adxIndexStatDo) > 500L) {
            ret = DataUtil.division((Long)(AdxIndexStatDo.getAdxCost(adxIndexStatDo) * 1000L), (Long)AdxIndexStatDo.getExpCnt(adxIndexStatDo), (int)5);
        }
        return ret;
    }

    public static Double getStatCpm(AdxIndexStatDo adxIndexStatDo, Double baseValue) {
        Double ret = AdxRcmdBase.getStatCpm(adxIndexStatDo);
        ret = MathUtil.mean((Double)ret, (Double)baseValue, (Double)0.5);
        return ret;
    }

    public static Double getStatCpm(Double base, AdxIndexStatDo minStat, AdxIndexStatDo hourStat, AdxIndexStatDo dayStat) {
        double r1 = 0.5;
        double r2 = 0.3;
        double r3 = 0.2;
        double mergeExpCnt = r1 * (double)AdxIndexStatDo.getExpCnt(minStat).longValue() + r2 * (double)AdxIndexStatDo.getExpCnt(hourStat).longValue() + r3 * (double)AdxIndexStatDo.getExpCnt(dayStat).longValue();
        double mergeAdxCost = r1 * (double)AdxIndexStatDo.getAdxCost(minStat).longValue() + r2 * (double)AdxIndexStatDo.getAdxCost(hourStat).longValue() + r3 * (double)AdxIndexStatDo.getAdxCost(dayStat).longValue();
        Double stat = DataUtil.division((Double)(mergeAdxCost * 1000.0), (Double)(mergeExpCnt + 1.0), (int)5);
        Double ret = MathUtil.mean((Double)base, (Double)stat, (Double)0.7);
        return DataUtil.formatDouble((Double)ret, (int)5);
    }

    public static Double getStatClickPv(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && AdxIndexStatDo.getClickCnt(adxIndexStatDo) > 100L) {
            ret = DataUtil.division((Long)AdxIndexStatDo.getAdClickCnt(adxIndexStatDo), (Long)AdxIndexStatDo.getClickCnt(adxIndexStatDo), (int)5);
        }
        return ret;
    }

    public static Double getStatClickPv(AdxIndexStatDo adxIndexStatDo, Double baseValue) {
        Double ret = AdxRcmdBase.getStatClickPv(adxIndexStatDo);
        ret = MathUtil.mean((Double)ret, (Double)baseValue, (Double)0.5);
        return ret;
    }

    public static Double getStatClickPv(Double base, AdxIndexStatDo minStat, AdxIndexStatDo hourStat, AdxIndexStatDo dayStat) {
        double r1 = 0.5;
        double r2 = 0.3;
        double r3 = 0.2;
        double mergeClickCnt = r1 * (double)AdxIndexStatDo.getClickCnt(minStat).longValue() + r2 * (double)AdxIndexStatDo.getClickCnt(hourStat).longValue() + r3 * (double)AdxIndexStatDo.getClickCnt(dayStat).longValue();
        double mergeAdClickCnt = r1 * (double)AdxIndexStatDo.getAdClickCnt(minStat).longValue() + r2 * (double)AdxIndexStatDo.getAdClickCnt(hourStat).longValue() + r3 * (double)AdxIndexStatDo.getAdClickCnt(dayStat).longValue();
        Double stat = DataUtil.division((Double)mergeAdClickCnt, (Double)(mergeClickCnt + 1.0), (int)5);
        Double ret = MathUtil.mean((Double)base, (Double)stat, (Double)0.7);
        return DataUtil.formatDouble((Double)ret, (int)5);
    }

    public static Double getStatAdCpc(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && AdxIndexStatDo.getAdClickCnt(adxIndexStatDo) > 20L) {
            ret = DataUtil.division((Long)AdxIndexStatDo.getAdCost(adxIndexStatDo), (Long)AdxIndexStatDo.getAdClickCnt(adxIndexStatDo), (int)5);
        }
        return ret;
    }

    public static Double getStatAdCpc(AdxIndexStatDo adxIndexStatDo, Double baseValue) {
        Double ret = AdxRcmdBase.getStatAdCpc(adxIndexStatDo);
        ret = MathUtil.mean((Double)ret, (Double)baseValue, (Double)0.5);
        return ret;
    }

    public static Double getStatAdCpc(Double base, AdxIndexStatDo minStat, AdxIndexStatDo hourStat, AdxIndexStatDo dayStat) {
        double r1 = 0.5;
        double r2 = 0.3;
        double r3 = 0.2;
        double mergeAdClickCnt = r1 * (double)AdxIndexStatDo.getAdClickCnt(minStat).longValue() + r2 * (double)AdxIndexStatDo.getAdClickCnt(hourStat).longValue() + r3 * (double)AdxIndexStatDo.getAdClickCnt(dayStat).longValue();
        double mergeAdCost = r1 * (double)AdxIndexStatDo.getAdCost(minStat).longValue() + r2 * (double)AdxIndexStatDo.getAdCost(hourStat).longValue() + r3 * (double)AdxIndexStatDo.getAdCost(dayStat).longValue();
        Double stat = DataUtil.division((Double)mergeAdCost, (Double)(mergeAdClickCnt + 1.0), (int)5);
        Double ret = MathUtil.mean((Double)base, (Double)stat, (Double)0.7);
        return DataUtil.formatDouble((Double)ret, (int)5);
    }

    public static double getAvgFactor(AdxIndexStatDo adxIndexStatDo) {
        Double ret = 1.0;
        if (adxIndexStatDo != null && adxIndexStatDo.getBid() != null && adxIndexStatDo.getFactor() != null) {
            ret = DataUtil.division((Double)(adxIndexStatDo.getFactor() + 10.0), (Long)(AdxIndexStatDo.getBidCnt(adxIndexStatDo) + 10L), (int)5);
        }
        if (ret == 0.0) {
            ret = 1.0;
        }
        return ret;
    }
}

