package cn.com.duiba.nezha.alg.alg.activity;

import cn.com.duiba.nezha.alg.common.model.activityrecommend.BetaDistribution;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.v2.ActivityFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.v2.ActFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;


public class ActivityRcmder {
    private static final Logger logger = LoggerFactory.getLogger(ActivityRcmder.class);

    private static String LOG_PRIFIX = "ActivityRcmder";

    private static HashMap<Long, String> sActMap = new HashMap<>();//定制

    private static HashMap<Long, Long> dActMap = new HashMap<>();//默认


    private static Random random = new Random();


    private static HashMap<Long, ActivityInfo> actWhiteList = new HashMap<>();//活动白名单配置信息
    private static HashMap<Long, SlotInfo> slotWhiteList = new HashMap<>();//广告位白名单配置信息

    private static List testList = Arrays.asList(30942L, 30828L, 26497L, 30222L, 30784L, 31234L, 31352L, 31185L, 31475L, 31557L, 31545L, 30192L);//随机测试活动-配置信息

    static {
        actWhiteList.put(30942L, new ActivityInfo(30942L, 1L, null));
        actWhiteList.put(31143L, new ActivityInfo(31143L, 1L, "1"));
        actWhiteList.put(31346L, new ActivityInfo(31346L, 1L, "1"));
        actWhiteList.put(31144L, new ActivityInfo(31144L, 1L, "2"));
        actWhiteList.put(31145L, new ActivityInfo(31145L, 1L, "3"));
        actWhiteList.put(31146L, new ActivityInfo(31146L, 1L, "4"));
        actWhiteList.put(30828L, new ActivityInfo(30828L, 2L, null));
        actWhiteList.put(31184L, new ActivityInfo(31184L, 2L, "1"));
        actWhiteList.put(30998L, new ActivityInfo(30998L, 2L, "2"));
        actWhiteList.put(31101L, new ActivityInfo(31101L, 2L, "3"));
        actWhiteList.put(31307L, new ActivityInfo(31307L, 2L, "8"));
        actWhiteList.put(31308L, new ActivityInfo(31308L, 2L, "11"));
        actWhiteList.put(31183L, new ActivityInfo(31183L, 2L, "4"));
        actWhiteList.put(30222L, new ActivityInfo(30222L, 1L, null));

    }

    static {

        slotWhiteList.put(417764L, new SlotInfo(417764L, 30942L, 1L));
        slotWhiteList.put(422622L, new SlotInfo(422622L, 30942L, 1L));
        slotWhiteList.put(404873L, new SlotInfo(404873L, 30828L, 2L));
        slotWhiteList.put(417855L, new SlotInfo(417855L, 30828L, 2L));
        slotWhiteList.put(423985L, new SlotInfo(423985L, 30222L, 1L));
        slotWhiteList.put(420877L, new SlotInfo(420877L, 30828L, 2L));
        slotWhiteList.put(404106L, new SlotInfo(404106L, 30828L, 2L));

    }


    //主链路--策略：1-模型30%，2-表单转化EE30%，3-表单转化&理论消耗EE20%，4-简化模型20%


    //流量、媒体类型： 0-非程序化媒体
    public static Long getAlgRcmdType0() {
        double rd = Math.random();

        if (rd <= 0.2) {
            return 3L;
        } else {
            return 4L;
        }

    }

    //流量、媒体类型：1-程序化媒体
    public static Long getAlgRcmdType1() {
        double rd = Math.random();
        if (rd <= 0.95) {
            return 3L;
        } else {
            return 5L;
        }

    }


    //流量、媒体类型：返回拦截
    // 策略：1-模型30%，2-表单转化EE30%，3-表单转化&理论消耗EE20%，4-简化模型20%
    public static Long getAlgRcmdType2() {
        double rd = Math.random();
        if (rd <= 0.2) {
            return 3L;
        } else {
            return 4L;
        }

    }

    public static Long getActType(Long activityId) {
        Long ret = null;
        ActivityInfo activityInfo = actWhiteList.get(activityId);
        if (activityInfo != null && activityInfo.getActType() != null) {
            ret = activityInfo.getActType();
        }
        return ret;
    }

    public static String getActTrade2(Long activityId) {
        String ret = null;
        ActivityInfo activityInfo = actWhiteList.get(activityId);
        if (activityInfo != null && activityInfo.getActTrade2() != null) {
            ret = activityInfo.getActTrade2();
        }
        return ret;
    }


    public static Long getDefActId(Long slotId) {
        Long ret = null;
        SlotInfo slotInfo = slotWhiteList.get(slotId);
        if (slotInfo != null && slotInfo.getDefActId() != null) {
            ret = slotInfo.getDefActId();
        }
        return ret;
    }

    public static Long getDefActType(Long slotId) {
        Long ret = null;
        SlotInfo slotInfo = slotWhiteList.get(slotId);
        if (slotInfo != null && slotInfo.getDefActType() != null) {
            ret = slotInfo.getDefActType();
        }
        return ret;
    }


//    public static String getActTrade2(Long activityId) {
//
//        if (sActMap.isEmpty()) {
//            sActMap.put(30915L, "1");
//            sActMap.put(31059L, "1");
//            sActMap.put(30916L, "4");
//            sActMap.put(27870L, "19");
//            sActMap.put(30998L, "2");
//            sActMap.put(31058L, "2");
//            sActMap.put(29084L, "2");
//            sActMap.put(31101L, "3");
//            sActMap.put(29917L, "3");
//            sActMap.put(30553L, "12");
//        }
//        return sActMap.get(activityId);
//    }
//
//    public static Long getActDef(Long slotId) {
//
//        if (dActMap.isEmpty()) {
//            dActMap.put(422622L, 30942L);
//            dActMap.put(417764L, 30942L);
//            dActMap.put(423985L, 30222L);
//            dActMap.put(417855L, 30828L);
//            dActMap.put(404873L, 30828L);
//            dActMap.put(396214L, 26497L);
//        }
//        return dActMap.get(slotId);
//    }

    /**
     * 活动特征解析
     *
     * @return
     */
    public static Map<Long, FeatureMapDo> getFeatureMap(List<ActivityRcmdReq> activityRcmdReqList,
                                                        ContextFeatureDoV2 contextFeatureDoV2,
                                                        UserFeatureDoV2 userFeatureDoV2) throws Exception {

        Map<Long, FeatureMapDo> featureMap = new HashMap<>();

        //1 非计划特征：静态特征解析
        Map<String, String> staticFeatureMap = ActivityFeatureParse.generateFeatureMapStatic(contextFeatureDoV2, userFeatureDoV2);

        Long activityPage = Optional.ofNullable(contextFeatureDoV2.getActivityPage()).orElse(null);


        //2 计划特征：动态特征解析
        if (AssertUtil.isEmpty(activityRcmdReqList)) {
            logger.warn(LOG_PRIFIX + ".getFeatureMap activityRcmdReqList is null");
            return featureMap;
        }

        for (ActivityRcmdReq activityRcmdReq : activityRcmdReqList) {

            Long activityId = activityRcmdReq.getActivityId();
            if (activityPage == null) {
                activityPage = activityId;
            }
            activityRcmdReq.setActivityPage(activityPage);

            String str = JSON.toJSONString(activityRcmdReq);
            ActFeatureDoV2 actFeatureDoV2 = JSON.parseObject(str, ActFeatureDoV2.class);

            Map<String, String> dynamicFeatureMap = ActivityFeatureParse.generateFeatureMapDynamic(actFeatureDoV2, userFeatureDoV2, contextFeatureDoV2);

            //3 封装计划特征集合
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMap.put(activityId, featureMapDo);

        }

        return featureMap;


    }

    /**
     * 模型预估
     */
    public static Map<Long, Double> predict(Map<Long, FeatureMapDo> featureMapDoMap,
                                            DeepModelV2 deepModelV2,
                                            LocalTFModelV2 localTFModelV2) throws Exception {

        if (AssertUtil.isAllNotEmpty(deepModelV2, localTFModelV2)) {
            return deepModelV2.predictWithLocalTFV2(featureMapDoMap, localTFModelV2);
        } else {
            return new HashMap<>();
        }
    }


    /**
     * 推荐接口
     *
     * @param activityRcmdReqList
     * @param activityParams
     * @param preEcpmMap
     * @return
     * @throws Exception
     */
    public static ActivityRcmdRet rcmd(List<ActivityRcmdReq> activityRcmdReqList,
                                       ActivityParams activityParams,
                                       Map<Long, Double> preEcpmMap, Long slotId, String appPkgTrade2, Long algRcmdType, Long dsm2A) throws Exception {


        /**
         * 计算排序分
         */
        List<ActivityRcmdRet> activityRcmdRetList = getScore(activityRcmdReqList, activityParams, preEcpmMap, slotId, dsm2A, appPkgTrade2, algRcmdType);


        /**
         * 推荐
         */
        ActivityRcmdRet ret = select(appPkgTrade2, activityRcmdRetList, algRcmdType);

        return ret;
    }

    /**
     * @param activityRcmdReqList 活动列表
     * @param appPkgTrade2        媒体包
     * @param slotId
     * @param algRcmdType         算法策略类型
     * @param filterActSet        已投放活动，过滤
     * @return
     * @throws Exception
     */
    public static List<ActivityRcmdReq> recall(List<ActivityRcmdReq> activityRcmdReqList, String appPkgTrade2, Long slotId, Long algRcmdType, Set<Long> filterActSet) throws Exception {
        if (algRcmdType.equals(3L)) {
            return recall2(activityRcmdReqList, filterActSet, appPkgTrade2);
        }
        if (algRcmdType.equals(2L)) {
            return recallMade(activityRcmdReqList, appPkgTrade2, slotId, filterActSet);
        }
        return recall1(activityRcmdReqList, appPkgTrade2, slotId, filterActSet);

    }

    /**
     * 召回随机测试活动
     */
    public static List<ActivityRcmdReq> recall2(List<ActivityRcmdReq> activityRcmdReqList, Set<Long> filterActSet, String appPkgTrade2) throws Exception {
        List<ActivityRcmdReq> ret = new ArrayList<>();

        List<ActivityRcmdReq> retDef = new ArrayList<>();//默认活动
        List<ActivityRcmdReq> retSpe = new ArrayList<>();//媒体包+定制活动
        List<ActivityRcmdReq> retOther = new ArrayList<>();//普通活动

        for (int i = 0; i < activityRcmdReqList.size(); i++) {
            ActivityRcmdReq activityRcmdReq = activityRcmdReqList.get(i);
            Long activityId = activityRcmdReq.getActivityId();
            String actTrade2 = getActTrade2(activityId);//当前活动行业标签

            // 媒体包和活动标签一致，召回
            if (appPkgTrade2 != null && appPkgTrade2.equals(actTrade2)) {
                continue;
            }

            // 去重
            if (!filterActSet.contains(activityId)) {
                ret.add(activityRcmdReq);
            }

        }


        if (ret.isEmpty()) {
            ret.add(activityRcmdReqList.get(0));
        }

        return ret;
    }

    /**
     * 策略1-召回
     * 计算排序分
     */
    public static List<ActivityRcmdReq> recall1(List<ActivityRcmdReq> activityRcmdReqList, String appPkgTrade2, Long slotId, Set<Long> filterActSet) throws Exception {
        List<ActivityRcmdReq> ret = new ArrayList<>();
        Long dAct = getDefActId(slotId); //默认活动id
        Long dActType = getDefActType(slotId); //默认活动玩法

        // 是否媒体包流量+媒体包活动
        boolean hasSpecAct = false;

        for (int i = 0; i < activityRcmdReqList.size(); i++) {
            ActivityRcmdReq activityRcmdReq = activityRcmdReqList.get(i);
            Long activityId = activityRcmdReq.getActivityId();
            String actTrade2 = getActTrade2(activityId);//当前活动行业标签
            Long actType = getActType(activityId);//当前活动玩法


            /**
             * 活动过滤
             * 1、默认活动
             * 2、媒体包定制活动 且 玩法一致
             */

            boolean recall = false;
            // 默认活动 召回
            if (dAct != null && activityId.equals(dAct)) {
                recall = true;

            }

            // 媒体包和活动标签一致，召回
            if (appPkgTrade2 != null && appPkgTrade2.equals(actTrade2)) {
                if (dActType != null && dActType.equals(actType)) {
                    recall = true;
                    hasSpecAct = true;
                }
            }

            if (recall) {
                if (!filterActSet.contains(activityId)) {
                    ret.add(activityRcmdReq);
                }
            }

        }


        if (!hasSpecAct) {
            ret = activityRcmdReqList;
        }

        if (ret.isEmpty()) {
            ret.add(activityRcmdReqList.get(0));
        }


        return ret;
    }


    /**
     * 策略2
     * 召回活动
     * 1、非媒体包：默认活动 召回
     * 2、媒体包：定制活动 且 玩法一致 召回
     */
    public static List<ActivityRcmdReq> recallMade(List<ActivityRcmdReq> activityRcmdReqList, String appPkgTrade2, Long slotId, Set<Long> filterActSet) throws Exception {
        List<ActivityRcmdReq> ret = new ArrayList<>();
        Long dAct = getDefActId(slotId); //默认活动id
        Long dActType = getDefActType(slotId); //默认活动玩法
        // 是否媒体包流量+媒体包活动
        boolean hasSpecAct = false;

        for (int i = 0; i < activityRcmdReqList.size(); i++) {
            ActivityRcmdReq activityRcmdReq = activityRcmdReqList.get(i);
            Long activityId = activityRcmdReq.getActivityId();
            String actTrade2 = getActTrade2(activityId);//当前活动行业标签
            Long actType = getActType(activityId);//当前活动玩法


            boolean recall = false;

            // 非媒体包：默认活动 召回
            if (appPkgTrade2 == null) {
                if (dAct != null && activityId.equals(dAct)) {
                    recall = true;
                }
            }

            // 媒体包：定制活动 且 玩法一致 召回
            if (appPkgTrade2 != null && appPkgTrade2.equals(actTrade2)) {
                if (dActType != null && dActType.equals(actType)) {
                    recall = true;
                    hasSpecAct = true;
                }
            }

            if (recall) {
                if (!filterActSet.contains(activityId)) {
                    ret.add(activityRcmdReq);
                }
            }
        }


        if (!hasSpecAct) {
            ret = activityRcmdReqList;
        }

        if (ret.isEmpty()) {
            ret.add(activityRcmdReqList.get(0));
        }

        return ret;
    }


    /**
     * 计算排序分
     */
    private static ActivityRcmdRet select(String appPkgTrade2, List<ActivityRcmdRet> activityRcmdRetList, Long algRcmdType) throws Exception {
        ActivityRcmdRet ret = null;

        if (AssertUtil.isEmpty(activityRcmdRetList)) {
            logger.warn(LOG_PRIFIX + ".rank select is Empty,invaild");
            return ret;
        }

        activityRcmdRetList = activityRcmdRetList.stream()
                .sorted(Comparator.comparing(ActivityRcmdRet::getScore).reversed())
                .collect(Collectors.toList());

        // 不置信列表
        List<ActivityRcmdRet> activityRcmdRetList2 = activityRcmdRetList.stream()
                .filter(rcmdRet -> !rcmdRet.isConf())
                .collect(Collectors.toList());


        /**
         * 1 推荐
         */
        ret = activityRcmdRetList.get(0);

//        if (algRcmdType.equals(1L) || algRcmdType.equals(3L)) {
//            // 推荐类型1：score最大胜出
//            ret = activityRcmdRetList.get(0);
//
//        } else if (algRcmdType.equals(2L)) {

        //推荐类型2：不置信列表 2%概率 随机胜出; 其他，score最大胜出；
//            double rd = Math.random();
//            if (activityRcmdRetList2.size()>0 && rd <= 0.02) {
//                int n = random.nextInt(activityRcmdRetList2.size());
//                ret = activityRcmdRetList2.get(n);
//            } else {
//                ret = activityRcmdRetList.get(0);
//            }
//            ret = activityRcmdRetList.get(0);
//
//
//        } else {
//            //随机胜出
//            int n = random.nextInt(activityRcmdRetList.size());
//            ret = activityRcmdRetList.get(n);
//        }

        ret.setAlgRcmdType(algRcmdType);


        /**
         * 2 记录top5活动数据
         */
        List<ScoreDo> scoreDoList = new ArrayList<>();


        int size = 5;

        if (appPkgTrade2 != null && (appPkgTrade2.equals("16") || appPkgTrade2.equals("4"))) {
            size = 100;
        }

        for (int i = 0; i < activityRcmdRetList.size(); i++) {
            if (i < size) {
                ActivityRcmdRet activityRcmdRet = activityRcmdRetList.get(i);
                if (activityRcmdRet != null) {
                    ScoreDo scoreDo = new ScoreDo();
                    scoreDo.setActivityId(activityRcmdRet.getActivityId());
                    scoreDo.setPreEcpm(activityRcmdRet.getPreEcpm());
                    scoreDo.setScore(activityRcmdRet.getScore());
                    if (activityRcmdRet.getActivitySubParams() != null) {
                        scoreDo.setStatEcpm(activityRcmdRet.getActivitySubParams().getEcpm());
                    }

                    scoreDoList.add(scoreDo);
                }
            }
        }

        ret.setTopScoreDoList(scoreDoList);
        return ret;

    }

    /**
     * 计算排序分
     */
    private static List<ActivityRcmdRet> getScore(List<ActivityRcmdReq> activityRcmdReqList,
                                                  ActivityParams activityParams,
                                                  Map<Long, Double> preEcpmMap, Long slotId, Long dsm2A, String appPkgTrade2, Long algRcmdType) throws Exception {
        List<ActivityRcmdRet> ret = new ArrayList<>();

        if (AssertUtil.isEmpty(activityRcmdReqList)) {
            logger.warn(LOG_PRIFIX + ".getScore  activityRcmdReqList is Empty,invaild");

            return ret;
        }


        double rd = Math.random();//随机数：90%走wilson下限，10%走Thompson采样

        for (ActivityRcmdReq activityRcmdReq : activityRcmdReqList) {

            Long activityId = activityRcmdReq.getActivityId();

//            Long slotId = activityRcmdReq.getSlotId();

            // 1、数据准备

            Double preEcpm = 0.0011;
            if (preEcpmMap != null && preEcpmMap.get(activityId) != null) {
                preEcpm = preEcpmMap.get(activityId);
            }

            // 2、计算排序分

            ActivitySubParams activitySubParams = null, slotSubParams = null, slotParams = null;
            Double weight = 0.0;
            if (activityParams != null) {
                activitySubParams = activityParams.getFactor(activityId, dsm2A, slotId, appPkgTrade2);
                slotSubParams = activityParams.getFactor(-1L, dsm2A, slotId, appPkgTrade2);
                slotParams = activityParams.getFactor(-1L, dsm2A, slotId, "-1");
                weight = activityParams.getWeight();
            }
            boolean conf = activitySubParams != null && activitySubParams.getActReqCntPv() > 0;

            Double score = getScore(preEcpm, activitySubParams);
            Long alpha = null, beta = null, alpha2 = null, beta2 = null;
            //2-表单转化EE，3-表单转化&理论消耗EE
            if (algRcmdType.equals(2L)) {
                ScoreDo scoreDto = getMixScore(activitySubParams, slotSubParams, rd);
                score = scoreDto.getScore();
                alpha = scoreDto.getAlpha();
                beta = scoreDto.getBeta();
            } else if (algRcmdType.equals(3L) || algRcmdType.equals(5L)) {
                ScoreDo scoreDto = getMixScore(activitySubParams, slotSubParams, slotParams, weight, rd);
                score = scoreDto.getScore();
                alpha = scoreDto.getAlpha();
                beta = scoreDto.getBeta();
                alpha2 = scoreDto.getAlpha2();
                beta2 = scoreDto.getBeta2();
            }


            // 3、结果封装
            ActivityRcmdRet activityRcmdRet = new ActivityRcmdRet();
            activityRcmdRet.setActivityId(activityId);
            activityRcmdRet.setActivitySubParams(activitySubParams);
            activityRcmdRet.setScore(score);
            activityRcmdRet.setPreEcpm(preEcpm);
            activityRcmdRet.setConf(conf);
            activityRcmdRet.setAlpha(alpha);
            activityRcmdRet.setBeta(beta);
            activityRcmdRet.setAlpha2(alpha2);
            activityRcmdRet.setBeta2(beta2);

            ret.add(activityRcmdRet);
        }

        return ret;
    }


    /**
     * 计算排序分
     *
     * @param preEcpm
     * @param activitySubParams
     * @return
     */
    private static Double getScore(double preEcpm, ActivitySubParams activitySubParams) {
        double ret = preEcpm;

        /**
         * 1、概率1-p，score=（1-w）* preEcpm + w * statEcpm
         * 2、概率p，score= statEcpm
         */

        if (activitySubParams != null) {
            Double statEcpm = activitySubParams.getEcpm();
            Double statRatio = activitySubParams.getStatRatio();

            Double factor = activitySubParams.getFactor();

            if (statEcpm != null) {

                if (Math.random() > statRatio) {
                    // 概率1-p，score=（1-w）* preEcpm + w * statEcpm

                    ret = preEcpm * 1.0 + statEcpm * 0.0;

                } else {
                    // 概率p，score= statEcpm
                    ret = statEcpm;
                }
            }


            /**
             * 扶持因子
             * 1、新活动、冷启动控制
             * 2、扶持活动【统计表现好、拿量衰减、等】
             */
            ret = ret * factor;
        }

        return ret;
    }


    /**
     * 计算排序分
     *
     * @param actSubParams
     * @param slotSubParams
     * @return
     */
    private static ScoreDo getScore(ActivitySubParams actSubParams, ActivitySubParams slotSubParams) {
        ScoreDo retDo = new ScoreDo();

        long alpha = 10L;
        long beta = 1000L - alpha;
        if (slotSubParams != null) {
            long slotReqPv = slotSubParams.getActReqCntPv();
            long slotLandClickPv = slotSubParams.getLandpageClickPv();
            double slotRatio = DataUtil.division((slotLandClickPv + alpha), (slotReqPv + alpha + beta), 5);

            if (slotLandClickPv > 100L && slotReqPv >= slotLandClickPv) {
                slotRatio = DataUtil.division(slotLandClickPv, slotReqPv, 5);
                alpha = DataUtil.double2Long(DataUtil.division(slotLandClickPv, 10L));
            }
            beta = DataUtil.double2Long(DataUtil.division(alpha, slotRatio) - alpha);

        }

        if (actSubParams != null) {
            long actReqPv = actSubParams.getActReqCntPv();
            long actLandClickPv = actSubParams.getLandpageClickPv();
            alpha = actLandClickPv + alpha;
            beta = actReqPv + beta - actLandClickPv;
        }

        double ret = Thompson.betaSampler(alpha, beta);
        retDo.setScore(DataUtil.formatDouble(ret, 6));
        retDo.setAlpha(alpha);
        retDo.setBeta(beta);
        return retDo;
    }

    /**
     * 计算排序分
     *
     * @param actSubParams
     * @param slotSubParams
     * @param rd
     * @return
     */
    private static ScoreDo getMixScore(ActivitySubParams actSubParams, ActivitySubParams slotSubParams, double rd) {
        ScoreDo retDo = new ScoreDo();

        long alpha = 10L;
        long beta = 1000L - alpha;
        if (slotSubParams != null) {
            long slotReqPv = slotSubParams.getActReqCntPv();
            long slotLandClickPv = slotSubParams.getLandpageClickPv();
            double slotRatio = DataUtil.division((slotLandClickPv + alpha), (slotReqPv + alpha + beta), 5);

            if (slotLandClickPv > 100L && slotReqPv >= slotLandClickPv) {
                slotRatio = DataUtil.division(slotLandClickPv, slotReqPv, 5);
                alpha = DataUtil.double2Long(DataUtil.division(slotLandClickPv, 10L));
            }
            alpha = Math.min(alpha, 50L);
            beta = DataUtil.double2Long(DataUtil.division(alpha, slotRatio) - alpha);
        }

        if (actSubParams != null) {
            long actReqPv = actSubParams.getActReqCntPv();
            long actLandClickPv = actSubParams.getLandpageClickPv();
            alpha = actLandClickPv + alpha;
            beta = actReqPv + beta - actLandClickPv;
        }

        double ret = Thompson.betaSampler(alpha, beta);

        //根据流量当前随机数，90%走wilson下限，10%走Thompson采样
        if (rd <= 0.95) {
            ret = getWilsonScore(alpha, alpha + beta);
        }

        retDo.setScore(DataUtil.formatDouble(ret, 6));
        retDo.setAlpha(alpha);
        retDo.setBeta(beta);
        return retDo;
    }


    /**
     * 计算排序分
     *
     * @param actSubParams
     * @param slotSubParams
     * @param slotParams
     * @param weight        //理论表单转化pv融合权重
     * @param rd
     * @return
     */
    private static ScoreDo getMixScore(ActivitySubParams actSubParams, ActivitySubParams slotSubParams, ActivitySubParams slotParams, Double weight, double rd) {

        ScoreDo scoreDo = getMixScore(actSubParams, slotSubParams, rd);
        if (weight == null || weight <= 0.0) {
            return scoreDo;
        }


        double value = 1000.0; // 表单转化单价
        if (slotParams != null && slotParams.getLandpageClickPv() > 0L && slotParams.getTheoryFee() > 0L) {
            long landClickPv = slotParams.getLandpageClickPv();
            long theoryFee = slotParams.getTheoryFee();
            value = DataUtil.division(theoryFee, landClickPv);
        }

        long actSubLandClickPv = 0L, slotSubLandClickPv = 0L;
        if (actSubParams != null) {
            actSubLandClickPv = actSubParams.getLandpageClickPv();
            long theoryFee = actSubParams.getTheoryFee();
            long theoryLandClickPv = DataUtil.double2Long(DataUtil.division(theoryFee, value));
            actSubParams.setLandpageClickPv(theoryLandClickPv);
        }
        if (slotSubParams != null) {
            slotSubLandClickPv = slotSubParams.getLandpageClickPv();
            long theoryFee = slotSubParams.getTheoryFee();
            long theoryLandClickPv = DataUtil.double2Long(DataUtil.division(theoryFee, value));
            slotSubParams.setLandpageClickPv(theoryLandClickPv);
        }


        ScoreDo theoryScoreDo = getMixScore(actSubParams, slotSubParams, rd);
        double ret = weight * theoryScoreDo.getScore() + (1 - weight) * scoreDo.getScore();

        scoreDo.setScore(DataUtil.formatDouble(ret, 6));
        scoreDo.setAlpha2(theoryScoreDo.getAlpha());
        scoreDo.setBeta2(theoryScoreDo.getBeta());

        if (actSubParams != null) {
            actSubParams.setLandpageClickPv(actSubLandClickPv);
        }
        if (slotSubParams != null) {
            slotSubParams.setLandpageClickPv(slotSubLandClickPv);
        }

        return scoreDo;
    }

    /**
     * 计算威尔逊得分
     * <p>
     * 95%的置信水平，z统计量为1.96
     *
     * @param pos   not null
     * @param total not null
     * @return
     */
    public static Double getWilsonScore(Long pos, Long total) {

        if (total == 0) {
            total = 1L;
        }
        if (pos > total) {
            pos = total;
        }

        double p = pos * 1.0 / total * 1.0;
        double z = 1.96;
        double zSquare = z * z;
        Double score = (p + (zSquare / (2 * total)) - z * Math.sqrt(4 * total * p * (1 - p) + zSquare) / (2 * total))
                / (1 + zSquare / total);

        return DataUtil.formatDouble(score, 6);
    }


    public static void main(String[] args) throws Exception {

        //"31587_1_423986_16"
        String actStr = "{\"actReqCntPv\":11676,\"adClickPv\":1889,\"alpha\":0,\"beta\":0,\"ecpm\":34.92593,\"expCntPv\":3476,\"factor\":1.0,\"fee\":407830,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":395,\"statEcpm\":34.92593,\"statEcpm2\":24.35018,\"statRatio\":0.0,\"targetConvertPv\":53,\"theoryFee\":284337}";
        //"-1_1_423986_16"
        String slotStr = "{\"actReqCntPv\":12753,\"adClickPv\":2024,\"alpha\":0,\"beta\":0,\"ecpm\":34.77623,\"expCntPv\":3692,\"factor\":1.0,\"fee\":443536,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":424,\"statEcpm\":34.77623,\"statEcpm2\":23.5723,\"statRatio\":0.0,\"targetConvertPv\":56,\"theoryFee\":300641}";

        String slotAllStr = "{\"actReqCntPv\":168722,\"adClickPv\":39402,\"alpha\":0,\"beta\":0,\"ecpm\":92.96489,\"expCntPv\":54751,\"factor\":1.0,\"fee\":13902157,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":14587,\"statEcpm\":82.39634,\"statEcpm2\":92.96489,\"statRatio\":0.0,\"targetConvertPv\":2946,\"theoryFee\":15685315}";

        ActivitySubParams actSubParams = JSON.parseObject(actStr, ActivitySubParams.class);
        ActivitySubParams slotSubParams = JSON.parseObject(slotStr, ActivitySubParams.class);
        ActivitySubParams slotAllParams = JSON.parseObject(slotAllStr, ActivitySubParams.class);
        ScoreDo score = getScore(actSubParams, slotSubParams);
        System.out.println("score:" + JSON.toJSONString(score));

        for (int i = 0; i < 100; i++) {
            double rd = Math.random();
            System.out.println(getMixScore(actSubParams, slotSubParams, rd));
            ScoreDo ret = getMixScore(actSubParams, slotSubParams, slotAllParams, 0.5, rd);
            System.out.println(ret);

        }


        /**
         * 模拟
         */
        List<ActivityRcmdReq> activityRcmdReqList = new ArrayList<>();
        ActivityRcmdReq a1 = new ActivityRcmdReq();
        a1.setActivityId(32161L);
        activityRcmdReqList.add(a1);
        ActivityRcmdReq a2 = new ActivityRcmdReq();
        a2.setActivityId(31934L);
        activityRcmdReqList.add(a2);
        ActivityRcmdReq a3 = new ActivityRcmdReq();
        a3.setActivityId(32051L);
        activityRcmdReqList.add(a3);

        ActivityParams activityParams = new ActivityParams();
        activityParams.setSlotId(420615L);
        Map<String, ActivitySubParams> fatorMap = new HashMap<>();
        String slotStrs = "{\"actReqCntPv\":14588,\"adClickPv\":2229,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":7.57242,\"expCntPv\":3377,\"factor\":1.0,\"fee\":110474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":179,\"statEcpm\":7.57242,\"statEcpm2\":7.55213,\"statRatio\":0.0,\"targetConvertPv\":53,\"theoryFee\":110178}";
        ActivitySubParams slotParam = JSON.parseObject(slotStrs, ActivitySubParams.class);
        fatorMap.put("-1_1_420615_-1", slotParam);

        String slotSubStrs = "{\"actReqCntPv\":39836,\"adClickPv\":5846,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":8.41236,\"expCntPv\":8908,\"factor\":1.0,\"fee\":306700,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":480,\"statEcpm\":7.69888,\"statEcpm2\":8.41236,\"statRatio\":0.0,\"targetConvertPv\":147,\"theoryFee\":335123}";
        ActivitySubParams slotSubParam = JSON.parseObject(slotSubStrs, ActivitySubParams.class);
        fatorMap.put("-1_1_420615_null", slotSubParam);

        String a1Strs = "{\"actReqCntPv\":20566,\"adClickPv\":3499,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":257,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.0,\"targetConvertPv\":82,\"theoryFee\":188489}";
        ActivitySubParams a1Params = JSON.parseObject(a1Strs, ActivitySubParams.class);
        fatorMap.put("32161_1_420615_null", a1Params);

        String a2Strs = "{\"actReqCntPv\":3408,\"adClickPv\":589,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":7.60399,\"expCntPv\":841,\"factor\":1.0,\"fee\":19814,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":31,\"statEcpm\":5.81227,\"statEcpm2\":7.60399,\"statRatio\":0.0,\"targetConvertPv\":15,\"theoryFee\":25922}";
        ActivitySubParams a2Params = JSON.parseObject(a2Strs, ActivitySubParams.class);
        fatorMap.put("31934_1_420615_null", a2Params);

        String a3Strs = "{\"actReqCntPv\":470,\"adClickPv\":92,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":11.96816,\"expCntPv\":154,\"factor\":1.0,\"fee\":5637,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":6,\"statEcpm\":11.96816,\"statEcpm2\":0.0,\"statRatio\":0.0,\"targetConvertPv\":0,\"theoryFee\":0}";
        ActivitySubParams a3Params = JSON.parseObject(a3Strs, ActivitySubParams.class);
        fatorMap.put("32051_1_420615_null", a3Params);
        activityParams.setFatorMap(fatorMap);
        activityParams.setWeight(0.5);

        Map<Long, Integer> retMap = new HashMap<>();
        for (int i = 0; i < 1000; i++) {
            ActivityRcmdRet activityRcmdRet = ActivityRcmder.rcmd(activityRcmdReqList, activityParams, null, 420615L, null, 2L, 1L);
            Long act = activityRcmdRet.getActivityId();
            System.out.println("activityRcmdRet:" + JSON.toJSONString(activityRcmdRet));
            retMap.put(act, retMap.getOrDefault(act, 0) + 1);
        }
        System.out.println("retMap:" + JSON.toJSONString(retMap));


    }
}
