package cn.com.duiba.nezha.alg.alg.advert.v2;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.ee.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ee.AdExploreModel;
import cn.com.duiba.nezha.alg.alg.vo.ee.AppGroupDo;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;


@Slf4j
public class BidExploreStrategy {


    /**
     * 批量接口
     *
     * @param controlResultMap 出价返回对象
     * @param appGroupDo       媒体包映射对象
     * @return
     */
    public static void updateInfo(Map<String, AdBidResultDo> controlResultMap, AppGroupDo appGroupDo, Integer putIndex, Long slotId) {


        String appGroup = null;
        if (appGroupDo != null) {

            appGroup = appGroupDo.getAppGroupMap().get(slotId);
        }
        if (controlResultMap == null) {
            return;
        }

        for (Map.Entry<String, AdBidResultDo> entry : controlResultMap.entrySet()) {

            AdBidResultDo adBidResultDo = entry.getValue();
            AdBidParamsDo adBidParamsDo = adBidResultDo.getAdBidParamsDo();

            if (adBidParamsDo != null) {
                adBidParamsDo.setPutIndex(putIndex);
                adBidParamsDo.setAppGroup(appGroup);
            }

        }
    }


    /**
     * 出价控制
     * 描述：
     * 包含所有算法出价调节策略
     * 1、一键起量
     * 2、一键继承
     *
     * 3、探价
     *
     * 4、预算平滑（暂无）
     * 5、纠偏出价调节（暂无）
     */


    /**
     * 批量接口
     *
     * @param controlResultMap 出价返回对象
     * @param adEEModelMap     探价对象
     * @param appGroupDo       媒体包映射对象
     * @return
     */
    public static void bidExplore(Map<String, AdBidResultDo> controlResultMap, Map<Long, AdExploreModel> adEEModelMap, AppGroupDo appGroupDo, Integer putIndex, Long slotId) {

        if (adEEModelMap == null) {
            return;
        }

        if (putIndex != null && putIndex > 1) {
            return;
        }

        String appGroup = null;
        if (appGroupDo != null) {

            appGroup = appGroupDo.getAppGroupMap().get(slotId);
        }

        for (Map.Entry<String, AdBidResultDo> entry : controlResultMap.entrySet()) {

            AdBidResultDo adBidResultDo = entry.getValue();

            adBidResultDo.setAppGroup(appGroup);

            Long advertId = adBidResultDo.getAdvertId();

            /**
             * 1 探价 、一键起量、继承
             */
            bidExplore(adBidResultDo, adEEModelMap.get(advertId));


            //System.out.println("bidExplore="+JSON.toJSONString(adBidResultDo));
        }

    }


    /**
     * 单计划接口
     *
     * @param adBidResultDo  出价返回对象
     * @param adExploreModel 探价参数
     */
    public static void bidExplore(AdBidResultDo adBidResultDo, AdExploreModel adExploreModel) {


        if (adExploreModel == null) {
            return;
        }

        /**
         * ocpc广告
         */

        if (adBidResultDo.getChargeType() == 2) {

            Double eeFactor = null;
            Double qlFactor = null;

            /**
             * 1 出价试探-出价增长
             *
             */
            eeFactor = exploreControl(adBidResultDo, adExploreModel);

            //System.out.println("ee"+eeFactor);
            /**
             * 2 一键起量
             */
            qlFactor = qiliangControl(adBidResultDo, adExploreModel);


            Double exploreFactor = MathUtil.max(eeFactor, qlFactor);


            if (exploreFactor != null) {

                Long fee = adBidResultDo.getFee();
                Double feeNewTmp = fee * exploreFactor;

                Long feeNew = feeNewTmp.longValue();

                adBidResultDo.setExploreFactor(exploreFactor);
                adBidResultDo.setFee(feeNew);

                adBidResultDo.getAdBidParamsDo().setExplore(true);
                adBidResultDo.getAdBidParamsDo().setExploreFeeDiff(feeNew - fee);
                adBidResultDo.getAdBidParamsDo().setExploreFactor(exploreFactor);

                adBidResultDo.getAdBidParamsDo().setFee(feeNew);
                adBidResultDo.getAdBidParamsDo().setEeFee(feeNew);

            }


        }


    }


    /**
     * 出价探索
     *
     * @param adBidResultDo
     */
    public static Double exploreControl(AdBidResultDo adBidResultDo, AdExploreModel adExploreModel) {


        if (adBidResultDo.getIsSupport() != null && adBidResultDo.getIsSupport()) {
            return null;
        }

        Long slotId = adBidResultDo.getSlotId();
        String appGroup = adBidResultDo.getAppGroup();

        Double eeFactor = null;

        /**
         * 获取探索因子
         */


        // 媒体包
        if (appGroup != null) {
            AdControlParams appGroupEEParams = adExploreModel.getAppGroupEEParamsMap().get(appGroup);
            eeFactor = AdExploreModel.getExploreFactor(appGroupEEParams);
        }


        // 广告位
        if (eeFactor == null) {
            AdControlParams slotEEParams = adExploreModel.getSlotEEParamsMap().get(slotId);

            eeFactor = AdExploreModel.getExploreFactor(slotEEParams);

        }

        //计划
        if (eeFactor == null) {
            // 计划
            AdControlParams adEEParams = adExploreModel.getAdEEParams();

            eeFactor = AdExploreModel.getExploreFactor(adEEParams);
        }


        return eeFactor;
    }


    /**
     * 一键起量
     *
     * @param adBidResultDo
     */
    public static Double qiliangControl(AdBidResultDo adBidResultDo, AdExploreModel adExploreModel) {

        Long packageId = adBidResultDo.getPackageId();

        AdControlParams params = adExploreModel.getQiliangParamsMap().get(packageId);


        if (params != null && params.getIsQiliang() != null && params.getIsQiliang()) {
            return params.getQlFactor();
        } else {
            return null;
        }

    }


}
