package cn.com.duiba.nezha.alg.alg.recallcompare.filter;

import cn.com.duiba.nezha.alg.alg.recallcompare.data.AdFilterDto;
import cn.com.duiba.nezha.alg.alg.recallcompare.param.FilterParam;

import java.util.ArrayList;
import java.util.List;

public class ExpandFilter {
    public static List<AdFilterDto> filter(List<AdFilterDto> inputAdFilterDtos, FilterParam param) {
        List<AdFilterDto> filteredDtos=new ArrayList<AdFilterDto>();
        for (AdFilterDto adFilterDto : inputAdFilterDtos) {
            if (param.getActiveReleaseTarget().contains(adFilterDto.getReleaseTarget()) && param.getExpandActiveTrade().contains(adFilterDto.getNewTradeTagId()) && param.getExpandActiveSubType().contains(adFilterDto.getCvrType())){
                adFilterDto.setIsPersist(Boolean.TRUE);
                filteredDtos.add(adFilterDto);
            }
            else {
                adFilterDto.setIsPersist(Boolean.FALSE);
            }
        }
        return filteredDtos;
    }

    public static void main(String[] args) {
        FilterParam param=new FilterParam();
        List<AdFilterDto> adFilterDtos=new ArrayList<AdFilterDto>();
        AdFilterDto ad1=new AdFilterDto(1L,1L,1,"15",3,null);
        AdFilterDto ad2=new AdFilterDto(2L,2L,2,"15",3,null);
        AdFilterDto ad3=new AdFilterDto(3L,3L,3,"15",3,null);
        AdFilterDto ad4=new AdFilterDto(4L,4L,3,"10",3,null);
        AdFilterDto ad5=new AdFilterDto(5L,5L,3,"21",3,null);
        adFilterDtos.add(ad1);
        adFilterDtos.add(ad2);
        adFilterDtos.add(ad3);
        adFilterDtos.add(ad4);
        adFilterDtos.add(ad5);
        List<AdFilterDto> output=filter(adFilterDtos,param);
        System.out.println(output);
    }
}
