package cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan;

import cn.com.duiba.nezha.alg.alg.vo.adx.AdxPriceExploreDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import lombok.Data;

@Data
public class ExplorePriceDo {

    /**
     * 探价分桶标记："1"，"2"，"3"，"4"，"5"
     */
    private String level;

    /**
     * 请求次数
     */
    private long reqCnt;

    /**
     * 返回次数
     */
    private long backCnt;

    /**
     * 曝光次数
     */
    private long impCnt;

    /**
     * 点击次数
     */
    private long clickCnt;

    /**
     * 媒体消耗
     */
    private long adxFee;

    /**
     * 广告消耗
     */
    private long adFee;

    public static Double getEffect(ExplorePriceDo levelDo, Double liftFactor) {
        int clkLimit = 5;  // 点击次数需大于5次
        int advConsumeLimit = 200;  // 广告消耗需大于200分

        return getConsumeEffect(levelDo, clkLimit, advConsumeLimit, liftFactor);
    }


    public static Double getConsumeEffect(ExplorePriceDo levelDo, int clkLimit, int advConsumeLimit, Double liftFactor) {
        Double ret = null;
        if(levelDo != null && (levelDo.getAdFee() > advConsumeLimit)) {
            Long adxConsume = levelDo.getAdxFee();
            Long advertConsume = levelDo.getAdFee();
            Double shareRate = DataUtil.division(adxConsume, advertConsume);
            if(AssertUtil.isAllNotEmpty(adxConsume, advertConsume, shareRate)) {
                double profit = advertConsume - adxConsume;
                // 当分成比例<0.80（roi>1.25）时，为纯消耗模式
                if (shareRate < 0.8) {
                    ret = advertConsume * 1.0;
                }
                else {
                    // 当roi小于1.25时，为利润优先模式，会综合考虑消耗规模
                    ret = profit * Math.pow(shareRate, liftFactor);
                }

            }
        }
        return ret;

    }
}
