package cn.com.duiba.nezha.alg.alg.vo.adx.pd;

import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.Data;

import java.util.Optional;

import static cn.com.duiba.nezha.alg.alg.adx.AdxStatData.getAdxTimeIndex;
import static cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxRcmdAlg.*;


/**
 * adx统计数据（时间维度）
 */
@Data
public class AdxStatsDo {

    /**
     * 近20分钟统计数据
     */
    private AdxIndexStatDo last20MinStat;

    /**
     * 近1小时统计数据
     */
    private AdxIndexStatDo last1HourStat;

    /**
     * 近2小时统计数据
     */
    private AdxIndexStatDo last2HourStat;

    /**
     * 近1天统计数据
     */
    private AdxIndexStatDo last1DayStat;

    /**
     * 近2天统计数据
     */
    private AdxIndexStatDo last2DayStat;

    /**
     * 近3天统计数据
     */
    private AdxIndexStatDo last3DayStat;

    /**
     * 历史7天统计数据
     */
    private AdxIndexStatDo last7DayStat;


    private AdxIndexStatDo ResoDayStat;
    private  AdxIndexStatDo Reso1DayStat;
    private AdxIndexStatDo Reso7DayStat;
    private AdxIndexStatDo Reso14DayStat;
    // 资源位 统计原始值
//    private Long resoExpDay; // 资源位 当天 入口素材曝光次数 f3016010
//    private Long resoActAccDay; // 资源位 当天 活动访问次数 f3016011
//    private Long resoActJoinDay; // 资源位 当天 活动参与次数 f3016012
//    private Long resoCoupClkpvDay; // 资源位 当天 券计费点击次数 f3016013
//    private Long resoExp1Day; // 资源位 历史1天 入口素材曝光次数 f3016014
//    private Long resoActAcc1Day; // 资源位 历史1天 活动访问次数 f3016015
//    private Long resoActJoin1Day; // 资源位 历史1天 活动参与次数 f3016016
//    private Long resoCoupClkpv1Day; // 资源位 历史1天 券计费点击次数 f3016017
//    private Long resoExp7Day; // 资源位 历史7天 入口素材曝光次数 f3016018
//    private Long resoActAcc7Day; // 资源位 历史7天 活动访问次数 f3016019
//    private Long resoActJoin7Day; // 资源位 历史7天 活动参与次数 f3016020
//    private Long resoCoupClkpv7Day; // 资源位 历史7天 券计费点击次数 f3016021
//    private Long resoExp14Day; // 资源位 历史14天 入口素材曝光次数 f3016022
//    private Long resoActAcc14Day; // 资源位 历史14天 活动访问次数 f3016023
//    private Long resoActJoin14Day; // 资源位 历史14天 活动参与次数 f3016024
//    private Long resoCoupClkpv14Day; // 资源位 历史14天 券计费点击次数 f3016025

    /**
     * 计算创意维度历史平均CPM--融合实时和全天累计值
     * @param ideaStats
     * @return
     */
    public static Long getMergeAvgPrice(AdxStatsDo ideaStats) {
        Long ret = 200L;

        if(ideaStats != null) {

            //创意维度CPM均值
            AdxIndexStatsDo adxIndexStatsDoDay = getAdxTimeIndex(ideaStats, "1day");
            AdxIndexStatsDo adxIndexStatsDoDayMin = getAdxTimeIndex(ideaStats, "20min");

            Long price1 = getAvgPrice(adxIndexStatsDoDay);
            Long price2 = getAvgPrice(adxIndexStatsDoDayMin);

            if(price1 == null) {
                ret = price2;
            }else if(price2 == null) {
                ret = price1;
            }else{
                ret = (long) (0.2 * price1 + 0.8 * price2);
            }
        }
        if(ret == null) {ret = 400L;}

        ret = (long)MathUtil.stdwithBoundary(ret, 400, 800);

        return ret;
    }

    public static Long getAvgPrice(AdxIndexStatsDo adxIndexStatsDo) {
        Long ret = null;
        if(adxIndexStatsDo != null && adxIndexStatsDo.getExpCnt() != null && adxIndexStatsDo.getExpCnt() > 100) {
            ret = MathUtil.division(adxIndexStatsDo.getAdxConsume() * 1000, adxIndexStatsDo.getExpCnt());
        }
        return ret;
    }

    /**
     * 计算融合统计广告ecpm(广告消耗/adx曝光*1000)
     */
    public static Double mergeStatAdEcpm(AdxStatsDo adxStatsDo, long limit, int mergeType) {

        adxStatsDo = Optional.ofNullable(adxStatsDo).orElse(new AdxStatsDo());
        AdxIndexStatDo last1HourStat = adxStatsDo.getLast1HourStat();
        AdxIndexStatDo last1DayStat = adxStatsDo.getLast1DayStat();
        AdxIndexStatDo last3DayStat = adxStatsDo.getLast3DayStat();
        AdxIndexStatDo last7DayStat = adxStatsDo.getLast7DayStat();

        double mergeExpCnt = 0, mergeAdCost = 0;
        if (mergeType == 1) {

            //创意召回任务：近1d/近3d/近7d
            double r1 = 0.5, r2 = 0.3, r3 = 0.2;
            mergeExpCnt = r1 * AdxIndexStatDo.getExpCnt(last1DayStat)
                    + r2 * AdxIndexStatDo.getExpCnt(last3DayStat)
                    + r3 * AdxIndexStatDo.getExpCnt(last7DayStat);
            mergeAdCost = r1 * AdxIndexStatDo.getAdCost(last1DayStat)
                    + r2 * AdxIndexStatDo.getAdCost(last3DayStat)
                    + r3 * AdxIndexStatDo.getAdCost(last7DayStat);

        } else if (mergeType == 2) {

            //<计划，创意>召回任务：近1h/近1d/近3d
            double r1 = 0.2, r2 = 0.5, r3 = 0.3;
            mergeExpCnt = r1 * AdxIndexStatDo.getExpCnt(last1HourStat)
                    + r2 * AdxIndexStatDo.getExpCnt(last1DayStat)
                    + r3 * AdxIndexStatDo.getExpCnt(last3DayStat);
            mergeAdCost = r1 * AdxIndexStatDo.getAdCost(last1HourStat)
                    + r2 * AdxIndexStatDo.getAdCost(last1DayStat)
                    + r3 * AdxIndexStatDo.getAdCost(last3DayStat);

        } else if (mergeType == 3) {

            //每个计划下的创意召回任务：近1d/近3d
            double r1 = 0.7, r2 = 0.3;
            mergeExpCnt = r1 * AdxIndexStatDo.getExpCnt(last1DayStat)
                    + r2 * AdxIndexStatDo.getExpCnt(last3DayStat);
            mergeAdCost =  r1 * AdxIndexStatDo.getAdCost(last1DayStat)
                    + r2 * AdxIndexStatDo.getAdCost(last3DayStat);

        }

        //置信阈值：曝光量级limit，广告ecpm = 10分/次 * 1000次，倾向低曝光的创意
        Double ret = DataUtil.division((mergeAdCost + limit * 10) * 1000, mergeExpCnt + limit, 3);
        return ret;
    }


    /**
     * 计算创意的统计广告ecpm(广告消耗/adx曝光*1000)
     *
     * @param resoStats 资源位+创意 当天/近3天 统计数据
     * @param adStatsDo 计划+创意 当天/近3天 统计数据
     *
     */
    public static Double mergeStatAdEcpm(AdxStatsDo resoStats, AdxStatsDo adStatsDo) {

        resoStats = Optional.ofNullable(resoStats).orElse(new AdxStatsDo());
        adStatsDo = Optional.ofNullable(adStatsDo).orElse(new AdxStatsDo());

        Double resoStatAdEcpm = mergeStatAdEcpm(resoStats,10L, 3);
        Double adStatAdEcpm = mergeStatAdEcpm(adStatsDo,10L, 3);

        Double ret = DataUtil.formatDouble(MathUtil.mean(resoStatAdEcpm, adStatAdEcpm, 0.7),3);
        return ret;
    }


    /**
     * 计算融合统计价值(广告消耗/adx点击pv)
     */
    public static Double mergeStatClickValue(AdxStatsDo adxStatsDo, double dWeight, double hWeight, double mWeight) {

        adxStatsDo = Optional.ofNullable(adxStatsDo).orElse(new AdxStatsDo());
        AdxIndexStatDo last20MinStat = adxStatsDo.getLast20MinStat();
        AdxIndexStatDo last1HourStat = adxStatsDo.getLast1HourStat();
        AdxIndexStatDo last1DayStat = adxStatsDo.getLast1DayStat();

        //近20min/近1h/近1d
        double mergeClickCnt = dWeight * AdxIndexStatDo.getClickCnt(last1DayStat)
                + hWeight * AdxIndexStatDo.getClickCnt(last1HourStat)
                + mWeight * AdxIndexStatDo.getClickCnt(last20MinStat);
        double mergeAdCost = dWeight * AdxIndexStatDo.getAdCost(last1DayStat)
                + hWeight * AdxIndexStatDo.getAdCost(last1HourStat)
                + mWeight * AdxIndexStatDo.getAdCost(last20MinStat);

        Double ret = null;
        if (mergeClickCnt > 50 || mergeAdCost > 2000) {
            ret =  DataUtil.division(mergeAdCost, mergeClickCnt, 5);
        }

        return ret;
    }


    /**
     * 计算融合统计ctr(adx点击pv/adx曝光pv)
     */
    public static Double mergeStatCtr(AdxStatsDo adxStatsDo, double dWeight, double hWeight, double mWeight) {

        adxStatsDo = Optional.ofNullable(adxStatsDo).orElse(new AdxStatsDo());
        AdxIndexStatDo last20MinStat = adxStatsDo.getLast20MinStat();
        AdxIndexStatDo last1HourStat = adxStatsDo.getLast1HourStat();
        AdxIndexStatDo last1DayStat = adxStatsDo.getLast1DayStat();

        //近20min/近1h/近1d
        double mergeExpCnt = dWeight * AdxIndexStatDo.getExpCnt(last1DayStat)
                + hWeight * AdxIndexStatDo.getExpCnt(last1HourStat)
                + mWeight * AdxIndexStatDo.getExpCnt(last20MinStat);
        double mergeClickCnt = dWeight * AdxIndexStatDo.getClickCnt(last1DayStat)
                + hWeight * AdxIndexStatDo.getClickCnt(last1HourStat)
                + mWeight * AdxIndexStatDo.getClickCnt(last20MinStat);

        Double ret = null;
        if (mergeExpCnt > 100 || mergeClickCnt > 50) {
            ret = MathUtil.stdwithBoundary(DataUtil.division(mergeClickCnt, mergeExpCnt, 5), 0, 1.0);
        }

        return ret;
    }


    /**
     * 计算竞价次数
     * @return
     */
    public static Long getBidCnt(AdxStatsDo adxStatsDo, int timeType) {
        Long ret = 0L;

        if(adxStatsDo != null ) {

            AdxIndexStatDo statDo = new AdxIndexStatDo();

            if (timeType == LAST_20_MIN) {
                statDo = adxStatsDo.getLast20MinStat();
            } else if (timeType == LAST_1_HOUR) {
                statDo = adxStatsDo.getLast1HourStat();
            } else if (timeType == LAST_1_DAY) {
                statDo = adxStatsDo.getLast1DayStat();
            } else if (timeType == LAST_3_DAY) {
                statDo = adxStatsDo.getLast3DayStat();
            } else if (timeType == LAST_7_DAY) {
                statDo = adxStatsDo.getLast7DayStat();
            }

            ret = AdxIndexStatDo.getBidCnt(statDo);
        }
        return ret;
    }


    /**
     * 计算竞价成功次数
     * @return
     */
    public static Long getBidSucCnt(AdxStatsDo adxStatsDo, int timeType) {
        Long ret = 0L;

        if(adxStatsDo != null ) {

            AdxIndexStatDo statDo = new AdxIndexStatDo();

            if (timeType == LAST_20_MIN) {
                statDo = adxStatsDo.getLast20MinStat();
            } else if (timeType == LAST_1_HOUR) {
                statDo = adxStatsDo.getLast1HourStat();
            } else if (timeType == LAST_1_DAY) {
                statDo = adxStatsDo.getLast1DayStat();
            } else if (timeType == LAST_3_DAY) {
                statDo = adxStatsDo.getLast3DayStat();
            } else if (timeType == LAST_7_DAY) {
                statDo = adxStatsDo.getLast7DayStat();
            }

            ret = AdxIndexStatDo.getBidSucCnt(statDo);
        }
        return ret;
    }


    /**
     * 计算曝光次数
     * @return
     */
    public static Long getExpCnt(AdxStatsDo adxStatsDo, int timeType) {
        Long ret = 0L;

        if(adxStatsDo != null ) {

            AdxIndexStatDo statDo = new AdxIndexStatDo();

            if (timeType == LAST_20_MIN) {
                statDo = adxStatsDo.getLast20MinStat();
            } else if (timeType == LAST_1_HOUR) {
                statDo = adxStatsDo.getLast1HourStat();
            } else if (timeType == LAST_1_DAY) {
                statDo = adxStatsDo.getLast1DayStat();
            } else if (timeType == LAST_3_DAY) {
                statDo = adxStatsDo.getLast3DayStat();
            } else if (timeType == LAST_7_DAY) {
                statDo = adxStatsDo.getLast7DayStat();
            }

            ret = AdxIndexStatDo.getExpCnt(statDo);
        }

        return ret;
    }

    /**
     * 计算广告消耗/分
     * @return
     */
    public static Long getAdCost(AdxStatsDo adxStatsDo, int timeType) {
        Long ret = 0L;

        if(adxStatsDo != null ) {

            AdxIndexStatDo statDo = new AdxIndexStatDo();

            if (timeType == LAST_20_MIN) {
                statDo = adxStatsDo.getLast20MinStat();
            } else if (timeType == LAST_1_HOUR) {
                statDo = adxStatsDo.getLast1HourStat();
            } else if (timeType == LAST_1_DAY) {
                statDo = adxStatsDo.getLast1DayStat();
            } else if (timeType == LAST_3_DAY) {
                statDo = adxStatsDo.getLast3DayStat();
            } else if (timeType == LAST_7_DAY) {
                statDo = adxStatsDo.getLast7DayStat();
            }

            ret = AdxIndexStatDo.getAdCost(statDo);
        }
        return ret;
    }


    /**
     * 计算adx消耗/分
     * @return
     */
    public static Long getAdxCost(AdxStatsDo adxStatsDo, int timeType) {
        Long ret = 0L;

        if(adxStatsDo != null ) {

            AdxIndexStatDo statDo = new AdxIndexStatDo();

            if (timeType == LAST_20_MIN) {
                statDo = adxStatsDo.getLast20MinStat();
            } else if (timeType == LAST_1_HOUR) {
                statDo = adxStatsDo.getLast1HourStat();
            } else if (timeType == LAST_1_DAY) {
                statDo = adxStatsDo.getLast1DayStat();
            } else if (timeType == LAST_3_DAY) {
                statDo = adxStatsDo.getLast3DayStat();
            } else if (timeType == LAST_7_DAY) {
                statDo = adxStatsDo.getLast7DayStat();
            }

            ret = AdxIndexStatDo.getAdxCost(statDo);
        }
        return ret;
    }


    public AdxIndexStatDo getLast20MinStat() {
        return last20MinStat;
    }

    public void setLast20MinStat(AdxIndexStatDo last20MinStat) {
        this.last20MinStat = last20MinStat;
    }

    public AdxIndexStatDo getLast1HourStat() {
        return last1HourStat;
    }

    public void setLast1HourStat(AdxIndexStatDo last1HourStat) {
        this.last1HourStat = last1HourStat;
    }

    public AdxIndexStatDo getLast1DayStat() {
        return last1DayStat;
    }

    public void setLast1DayStat(AdxIndexStatDo last1DayStat) {
        this.last1DayStat = last1DayStat;
    }
}
