package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import lombok.Data;

import java.io.Serializable;

/**
 * adx首发券特征对象
 * flc:first launch coupon
 *
 * @author caiyida@duiba.com.cn
 * @date 2022/3/22
 */
@Data
public class AdxFlcFeatureDo implements Serializable {

    /**
     * 首发券目标转化价格
     */
    private Long cpa;

    /**
     * 首发券广告ID f101001
     */
    private Long flcAdvertId;

    /**
     * 广告主账号 f106001
     */
    private String advertAccount;

    /**
     * 广告行业ID f660001
     */
    private String operatingNewTrade;

    /**
     * 广告行业标签 f102001
     */
    private String advertIndustryLabel;

    /**
     * 首发券统计特征（只含2h,2d,7d）
     */
    private AdxStatsDo adxStatsDo;
}
