/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;

public class AdxBaseStatDo {
    private long reqCnt;
    private long bidCnt;
    private long impCnt;
    private long clickCnt;
    private long adxFee;
    private long adFee;

    public static Double getShareRate(AdxBaseStatDo adxBaseStatDo) {
        Double ret = 1.0;
        if (adxBaseStatDo != null && adxBaseStatDo.adFee > 1000L) {
            ret = DataUtil.division((Long)adxBaseStatDo.adxFee, (Long)adxBaseStatDo.adFee, (int)3);
        }
        return ret;
    }

    public static Double getSucRate(AdxBaseStatDo adxBaseStatDo) {
        Double ret = null;
        if (adxBaseStatDo != null && adxBaseStatDo.bidCnt > 1000L) {
            ret = DataUtil.division((Long)adxBaseStatDo.impCnt, (Long)adxBaseStatDo.bidCnt, (int)3);
        }
        return ret;
    }

    public static Double getAvgPrice(AdxBaseStatDo adxBaseStatDo) {
        Double ret = null;
        if (adxBaseStatDo != null && adxBaseStatDo.clickCnt > 50L) {
            ret = DataUtil.division((Long)adxBaseStatDo.adxFee, (Long)adxBaseStatDo.clickCnt, (int)3);
        }
        return ret;
    }

    public static Double getMergePrice(AdxBaseStatDo adxBaseStatDo1, AdxBaseStatDo adxBaseStatDo2) {
        Double ret = null;
        Double avgPriceMins = AdxBaseStatDo.getAvgPrice(adxBaseStatDo1);
        Double avgPriceDay = AdxBaseStatDo.getAvgPrice(adxBaseStatDo2);
        if (adxBaseStatDo1 == null) {
            return avgPriceDay;
        }
        if (adxBaseStatDo2 == null) {
            return avgPriceMins;
        }
        Double weigh = DataUtil.division((Long)adxBaseStatDo2.clickCnt, (Long)(adxBaseStatDo2.clickCnt + adxBaseStatDo1.clickCnt), (int)3);
        if (avgPriceMins == null || weigh == null || avgPriceDay == null) {
            return avgPriceDay;
        }
        weigh = MathUtil.stdwithBoundary((double)weigh, (double)0.2, (double)0.8);
        ret = weigh * avgPriceDay + (1.0 - weigh) * avgPriceMins;
        return ret;
    }

    public long getReqCnt() {
        return this.reqCnt;
    }

    public long getBidCnt() {
        return this.bidCnt;
    }

    public long getImpCnt() {
        return this.impCnt;
    }

    public long getClickCnt() {
        return this.clickCnt;
    }

    public long getAdxFee() {
        return this.adxFee;
    }

    public long getAdFee() {
        return this.adFee;
    }

    public void setReqCnt(long reqCnt) {
        this.reqCnt = reqCnt;
    }

    public void setBidCnt(long bidCnt) {
        this.bidCnt = bidCnt;
    }

    public void setImpCnt(long impCnt) {
        this.impCnt = impCnt;
    }

    public void setClickCnt(long clickCnt) {
        this.clickCnt = clickCnt;
    }

    public void setAdxFee(long adxFee) {
        this.adxFee = adxFee;
    }

    public void setAdFee(long adFee) {
        this.adFee = adFee;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdxBaseStatDo)) {
            return false;
        }
        AdxBaseStatDo other = (AdxBaseStatDo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReqCnt() != other.getReqCnt()) {
            return false;
        }
        if (this.getBidCnt() != other.getBidCnt()) {
            return false;
        }
        if (this.getImpCnt() != other.getImpCnt()) {
            return false;
        }
        if (this.getClickCnt() != other.getClickCnt()) {
            return false;
        }
        if (this.getAdxFee() != other.getAdxFee()) {
            return false;
        }
        return this.getAdFee() == other.getAdFee();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdxBaseStatDo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $reqCnt = this.getReqCnt();
        result = result * 59 + (int)($reqCnt >>> 32 ^ $reqCnt);
        long $bidCnt = this.getBidCnt();
        result = result * 59 + (int)($bidCnt >>> 32 ^ $bidCnt);
        long $impCnt = this.getImpCnt();
        result = result * 59 + (int)($impCnt >>> 32 ^ $impCnt);
        long $clickCnt = this.getClickCnt();
        result = result * 59 + (int)($clickCnt >>> 32 ^ $clickCnt);
        long $adxFee = this.getAdxFee();
        result = result * 59 + (int)($adxFee >>> 32 ^ $adxFee);
        long $adFee = this.getAdFee();
        result = result * 59 + (int)($adFee >>> 32 ^ $adFee);
        return result;
    }

    public String toString() {
        return "AdxBaseStatDo(reqCnt=" + this.getReqCnt() + ", bidCnt=" + this.getBidCnt() + ", impCnt=" + this.getImpCnt() + ", clickCnt=" + this.getClickCnt() + ", adxFee=" + this.getAdxFee() + ", adFee=" + this.getAdFee() + ")";
    }
}

