package cn.com.duiba.nezha.alg.alg.landpage;

import cn.com.duiba.nezha.alg.alg.landpage.ScoreDo;
import cn.com.duiba.nezha.alg.alg.activity.*;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdFeeDo;
import cn.com.duiba.nezha.alg.api.model.E2ELocalTFModel;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.LandpageFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.v2.ActFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;


public class LandpageRcmder {
    private static final Logger logger = LoggerFactory.getLogger(LandpageRcmder.class);

    private static String LOG_PRIFIX = "LandpageRcmder";

    private static HashMap<Long, String> sActMap = new HashMap<>();//定制

    private static HashMap<Long, Long> dActMap = new HashMap<>();//默认


    private static Random random = new Random();


    private static HashMap<Long, ActivityInfo> actWhiteList = new HashMap<>();//活动白名单配置信息
    private static HashMap<Long, SlotInfo> slotWhiteList = new HashMap<>();//广告位白名单配置信息

    private static List testList = Arrays.asList(30942L, 30828L, 26497L, 30222L, 30784L, 31234L, 31352L, 31185L, 31475L, 31557L, 31545L, 30192L);//随机测试活动-配置信息

    static {
        actWhiteList.put(30942L, new ActivityInfo(30942L, 1L, null));
        actWhiteList.put(31143L, new ActivityInfo(31143L, 1L, "1"));
        actWhiteList.put(31346L, new ActivityInfo(31346L, 1L, "1"));
        actWhiteList.put(31144L, new ActivityInfo(31144L, 1L, "2"));
        actWhiteList.put(31145L, new ActivityInfo(31145L, 1L, "3"));
        actWhiteList.put(31146L, new ActivityInfo(31146L, 1L, "4"));
        actWhiteList.put(30828L, new ActivityInfo(30828L, 2L, null));
        actWhiteList.put(31184L, new ActivityInfo(31184L, 2L, "1"));
        actWhiteList.put(30998L, new ActivityInfo(30998L, 2L, "2"));
        actWhiteList.put(31101L, new ActivityInfo(31101L, 2L, "3"));
        actWhiteList.put(31307L, new ActivityInfo(31307L, 2L, "8"));
        actWhiteList.put(31308L, new ActivityInfo(31308L, 2L, "11"));
        actWhiteList.put(31183L, new ActivityInfo(31183L, 2L, "4"));
        actWhiteList.put(30222L, new ActivityInfo(30222L, 1L, null));

    }

    static {

        slotWhiteList.put(417764L, new SlotInfo(417764L, 30942L, 1L));
        slotWhiteList.put(422622L, new SlotInfo(422622L, 30942L, 1L));
        slotWhiteList.put(404873L, new SlotInfo(404873L, 30828L, 2L));
        slotWhiteList.put(417855L, new SlotInfo(417855L, 30828L, 2L));
        slotWhiteList.put(423985L, new SlotInfo(423985L, 30222L, 1L));
        slotWhiteList.put(420877L, new SlotInfo(420877L, 30828L, 2L));
        slotWhiteList.put(404106L, new SlotInfo(404106L, 30828L, 2L));

    }


    //主链路--策略：1-模型30%，2-表单转化EE30%，3-表单转化&理论消耗EE20%，4-简化模型20%


    //流量、媒体类型： 0-非程序化媒体
    public static Long getAlgRcmdType0() {
        double rd = Math.random();

        if (rd <= 0.2) {
            return 3L;
        } else {
            return 4L;
        }

    }

    //流量、媒体类型：1-程序化媒体
    public static Long getAlgRcmdType1() {
        double rd = Math.random();
        if (rd <= 0.95) {
            return 3L;
        } else {
            return 5L;
        }

    }


    //流量、媒体类型：返回拦截
    // 策略：1-模型30%，2-表单转化EE30%，3-表单转化&理论消耗EE20%，4-简化模型20%
    public static Long getAlgRcmdType2() {
        double rd = Math.random();
        if (rd <= 0.2) {
            return 3L;
        } else {
            return 4L;
        }

    }

    public static Long getActType(Long activityId) {
        Long ret = null;
        ActivityInfo activityInfo = actWhiteList.get(activityId);
        if (activityInfo != null && activityInfo.getActType() != null) {
            ret = activityInfo.getActType();
        }
        return ret;
    }

    public static String getActTrade2(Long activityId) {
        String ret = null;
        ActivityInfo activityInfo = actWhiteList.get(activityId);
        if (activityInfo != null && activityInfo.getActTrade2() != null) {
            ret = activityInfo.getActTrade2();
        }
        return ret;
    }


    public static Long getDefActId(Long slotId) {
        Long ret = null;
        SlotInfo slotInfo = slotWhiteList.get(slotId);
        if (slotInfo != null && slotInfo.getDefActId() != null) {
            ret = slotInfo.getDefActId();
        }
        return ret;
    }

    public static Long getDefActType(Long slotId) {
        Long ret = null;
        SlotInfo slotInfo = slotWhiteList.get(slotId);
        if (slotInfo != null && slotInfo.getDefActType() != null) {
            ret = slotInfo.getDefActType();
        }
        return ret;
    }

    /**
     * 落地页特征解析
     *
     * @return
     */
    public static Map<Long, FeatureMapDo> getFeatureMap(List<LandpageRcmdReq> landpageRcmdReqList,
                                                        FeatureDo cf,
                                                        FeatureDo staticCf) throws Exception {

        Map<Long, FeatureMapDo> featureMap = new HashMap<>();

        //1 非计划特征：静态特征解析
        Map<String, String> staticFeatureMap = LandpageFeatureParse.generateFeatureMapStatic(cf);


        //2 计划特征：动态特征解析
        if (AssertUtil.isEmpty(landpageRcmdReqList)) {
            logger.warn(LOG_PRIFIX + ".getFeatureMap landpageRcmdReqList is null");
            return featureMap;
        }

        for (LandpageRcmdReq landpageRcmdReq : landpageRcmdReqList) {

            Long landpageId = landpageRcmdReq.getLandpageId();

            Map<String, String> dynamicFeatureMap = LandpageFeatureParse.generateFeatureMapDynamic(cf, staticCf);

            //3 封装计划特征集合
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMap.put(landpageId, featureMapDo);

        }

        return featureMap;
    }

    /**
     * 模型预估
     */
    public static Map<Long, Double> predict(Map<Long, FeatureMapDo> featureMapDoMap,
                                            E2ELocalTFModel deepModel) throws Exception {

        if (AssertUtil.isAllNotEmpty(deepModel)) {
            try {
                Map<Long, Double> ret;
                Map<Long, Map<String, String>> modelInput = new HashMap<>();
                for (Map.Entry<Long, FeatureMapDo> entry : featureMapDoMap.entrySet()) {
                    modelInput.put(entry.getKey(), entry.getValue().getFeatureMap());
                }
                ret = deepModel.predict(modelInput);
                return ret;

            } catch (Exception e) {
                logger.error("LandpageRecommend.predictScore error{}, Model{}", e, deepModel);
            }
            return Collections.emptyMap();
//            return deepModel.predict(featureMapDoMap);
        } else {
            return new HashMap<>();
        }
    }

    public static Map<Long, Double> predict(Map<Long, FeatureMapDo> featureMapDoMap,
                                            DeepModelV2 deepModelV2,
                                            LocalTFModelV2 localTFModelV2) throws Exception {

        if (AssertUtil.isAllNotEmpty(deepModelV2, localTFModelV2)) {
            return deepModelV2.predictWithLocalTFV2(featureMapDoMap, localTFModelV2);
        } else {
            return new HashMap<>();
        }
    }

    /**
     * 落地页优选推荐接口
     * @param landpageRcmdReqList 可投落地页列表
     * @param landpageParams  redis上存放的策略参数
     * @param preEcpmMap 每个落地页的预估结果
     * @param Top1Advert 胜出广告
     * @param appPkgTrade2 媒体包行业小类
     * @return
     */

    public static AdBidResultDo rcmd(List<LandpageRcmdReq> landpageRcmdReqList, LandpageParams landpageParams, LandpageParams allParams, Map<Long, Double> preEcpmMap,
                                                  AdBidResultDo Top1Advert, String appPkgTrade2, Map<Long, FeatureMapDo> featuremapdo) throws Exception {

        /**
         * 1.在每一个广告计划下，计算每个落地页得分，并取得分top1的落地页
         */
        Long advertId = Top1Advert.getAdvertId();
        Long slotId = Long.valueOf(Top1Advert.getSlotId());
        List<LandpageRcmdRet> landpageRcmdRetList = getScore(landpageRcmdReqList, landpageParams, allParams, preEcpmMap, slotId, advertId, appPkgTrade2);

        // 没有可返回的落地页结果列表，直接返回广告结果
        if (AssertUtil.isEmpty(landpageRcmdRetList)) {
            if (Top1Advert.getAdBidParamsDo() == null) {
                Top1Advert.setAdBidParamsDo(new AdBidParamsDo());
            }
            Top1Advert.getAdBidParamsDo().setLandpageTop(new LandpageRcmdRet());
            return Top1Advert;
        }
        //将landpage的score排序，取第一作为胜出的landpage
        landpageRcmdRetList = landpageRcmdRetList.stream()
                .sorted(Comparator.comparing(LandpageRcmdRet::getScore).reversed())
                .collect(Collectors.toList());

        // Top1 landpage的得分为0, 数据不充分, 需要冷启动, 从可投列表中随机挑选一个
        LandpageRcmdRet landpagetop = null;
        if (landpageRcmdRetList.get(0).getScore() == 0.0) {
            Random r = new Random();
            int idx = r.nextInt(landpageRcmdRetList.size());
            landpagetop = landpageRcmdRetList.get(idx);
        }
        else {
             landpagetop = landpageRcmdRetList.get(0);
        }

        landpagetop.setFeatureMap(featuremapdo.get(landpagetop.getLandpageId()).getFeatureMap());
        /**
         * 2.将胜出的top落地页和广告对象合并
         */
        if (Top1Advert.getAdBidParamsDo() == null) {
            Top1Advert.setAdBidParamsDo(new AdBidParamsDo());
        }
        AdBidParamsDo printdo = Top1Advert.getAdBidParamsDo();
        printdo.setLandpageTop(landpagetop);

        return Top1Advert;

    }


    public static List<LandpageRcmdRet> getScore(List<LandpageRcmdReq> landpageRcmdReqList, LandpageParams landpageParams, LandpageParams allParams,
                                                 Map<Long, Double> preEcpmMap, Long slotId, Long advertId, String appPkgTrade2) throws Exception {

        List<LandpageRcmdRet> ret = new ArrayList<>();

        if (AssertUtil.isEmpty(landpageRcmdReqList)) {
            logger.warn(LOG_PRIFIX + ".getScore  landpageRcmdReqList is Empty,invaild");

            return ret;
        }

        for (LandpageRcmdReq landpageReq : landpageRcmdReqList) {

//            Long slotId = activityRcmdReq.getSlotId();
            Long landpageId = landpageReq.getLandpageId();
            Long frontpageId = landpageReq.getFrontpageId();
            Long paypageId = landpageReq.getPaypageId();
            Long formpageId = landpageReq.getFormpageId();
            Long modelId = landpageReq.getModelId();

            // 1、模型预估数据准备

            Double preEcpm = 0.0011;

            // 2、计算排序分
            LandpageSubParams landpgParams = null, landpgSlotParams = null, landpgPkgParams = null,
                    advertParams = null, advertSlotParams = null, advertPkgParams = null,
                    frontpgParams = null, frontpgSlotParams = null, frontpgPkgParams = null,
                    frontpgSubParams = null, frontpgSlotSubParams = null, frontpgPkgSubParams = null;
            Double[] weight = {1.2, 2.0, 2.0, 1.0, 1.0, 1.0};
            if (landpageParams != null) {
                weight = landpageParams.getWeight();
                // 分别得到每个统计维度下的统计信息
                landpgParams = landpageParams.getFactor(advertId, landpageId, -1L, "-1", -1L);
                landpgSlotParams = landpageParams.getFactor(advertId, landpageId, slotId, "-1", -1L);
                landpgPkgParams = landpageParams.getFactor(advertId, landpageId, -1L, appPkgTrade2, -1L);

                advertParams = landpageParams.getFactor(advertId, -1L, -1L, "-1", -1L);
                advertSlotParams = landpageParams.getFactor(advertId, -1L, slotId, "-1", -1L);
                advertPkgParams = landpageParams.getFactor(advertId, -1L, -1L, appPkgTrade2, -1L);
            }
            if (allParams != null) {
                frontpgSubParams = allParams.getFactor(-1L, -1L, -1L, "-1", frontpageId);
                frontpgSlotSubParams = allParams.getFactor(-1L, -1L, slotId, "-1", frontpageId);
                frontpgPkgSubParams = allParams.getFactor(-1L, -1L, -1L, appPkgTrade2, frontpageId);

                frontpgParams = allParams.getFactor(-1L, -1L, -1L, "-1", -1L);
                frontpgSlotParams = allParams.getFactor(-1L, -1L, slotId, "-1", -1L);
                frontpgPkgParams = allParams.getFactor(-1L, -1L, -1L, appPkgTrade2, -1L);

            }
//            boolean conf = landpageSubParams != null && landpageSubParams.getAdClickPv() > 0;

//            Double score = getScore(preEcpm, landpageSubParams);
            Double score = 0.0, rd = Math.random();
            List<Long> alpha = new ArrayList<>();
            List<Long> beta = new ArrayList<>();
//            Long alpha2 = null, beta2 = null;
            List<ScoreDo> ScoreDoList = new ArrayList<>();


            if (landpgParams != null && advertParams != null)  {
                ScoreDoList.add(getStaticScore(landpgParams, advertParams, rd));
            }
            if (landpgSlotParams != null && advertSlotParams != null) {
                ScoreDoList.add(getStaticScore(landpgSlotParams, advertSlotParams, rd));
            }
            if (landpgPkgParams != null && advertPkgParams != null) {
                ScoreDoList.add(getStaticScore(landpgPkgParams, advertPkgParams, rd));
            }
            if (frontpgParams != null && frontpgParams != null) {
                ScoreDoList.add(getStaticScore(frontpgSubParams, frontpgParams, rd));
            }
            if (frontpgSlotParams != null && frontpgSlotParams != null) {
                ScoreDoList.add(getStaticScore(frontpgSlotSubParams, frontpgSlotParams, rd));
            }
            if (frontpgPkgParams != null && frontpgPkgParams != null) {
                ScoreDoList.add(getStaticScore(frontpgPkgSubParams, frontpgPkgParams, rd));
            }
            // 对6个统计维度进行加权打分，作为最终落地页的最终得分
            Integer i = 0;
            Double sum = 0.0;
            for (ScoreDo scoreDo: ScoreDoList) {
                score += weight[i] * scoreDo.getScore();
                sum += weight[i++];
                alpha.add(scoreDo.getAlpha());
                beta.add(scoreDo.getBeta());
            }
            // 为了防止某一维度为空,采用归一化的方式得到融合分数。
            if (sum > 0) {
                score /= sum;
            }

            // 表单转化
//            cn.com.duiba.nezha.alg.alg.landpage.ScoreDo scoreDto = getStaticScore(landpageSubParams, slotSubParams);
            // 结合整体上的表单付费单价，去计算<具体维度>上的目标转化pv，然后再去加权计算得分，alpha = 目标转化pv，beta = 券点击pv
//            cn.com.duiba.nezha.alg.alg.landpage.ScoreDo scoreDto = getStaticScore(landpageSubParams, slotSubParams, slotParams, weight);
//            score = scoreDto.getScore();
//            alpha = scoreDto.getAlpha();
//            beta = scoreDto.getBeta();
//            alpha2 = scoreDto.getAlpha2();
//            beta2 = scoreDto.getBeta2();

            // 3、结果封装
            LandpageRcmdRet landpageRcmdRet = new LandpageRcmdRet();
            landpageRcmdRet.setLandpageId(landpageId);
//            landpageRcmdRet.setLandpageSubParams(landpageSubParams);
            landpageRcmdRet.setScore(score);
            landpageRcmdRet.setPreEcpm(preEcpm);
//            landpageRcmdRet.setConf(conf);
            landpageRcmdRet.setAlpha(alpha);
            landpageRcmdRet.setBeta(beta);
//            landpageRcmdRet.setAlpha2(alpha2);
//            landpageRcmdRet.setBeta2(beta2);

            ret.add(landpageRcmdRet);
        }

        return ret;

    }

    /**
     * 粗、细两个维度下的统计信息作EE策略
     * @param landpgParams
     * @param advertParams
     * @return
     */

    public static ScoreDo getStaticScore(LandpageSubParams landpgParams, LandpageSubParams advertParams, double rd) {
        ScoreDo retDo = new ScoreDo();

        long alpha = 20L;
        long beta = 100L - alpha;
        if (advertParams != null) {
            long adClickPv = advertParams.getAdClickPv();
            long mergePosPv = advertParams.getMergePosPv();

            double ratio = DataUtil.division((mergePosPv + alpha), (adClickPv + alpha + beta), 5);

            if (mergePosPv > 100L && adClickPv >= mergePosPv) {
                ratio = DataUtil.division(mergePosPv, adClickPv, 5);
                alpha = DataUtil.double2Long(DataUtil.division(mergePosPv, 10L));
            }
            alpha = Math.min(alpha, 50L);
            beta = DataUtil.double2Long(DataUtil.division(alpha, ratio) - alpha);
        }
        double statRatio = 0.95;
        if (landpgParams != null) {
            long adClickPv = landpgParams.getAdClickPv();
            long mergePosPv = landpgParams.getMergePosPv();
            statRatio = landpgParams.getStatRatio();
            alpha = mergePosPv + alpha;
            beta = adClickPv + beta - mergePosPv;
        }


        double ret = Thompson.betaSampler(alpha, beta);
        //根据流量当前随机数，95%走wilson下限，5%走Thompson采样
        if (rd <= statRatio) {
            ret = getWilsonScore(alpha, alpha + beta);
        }

        retDo.setScore(DataUtil.formatDouble(ret, 6));
        retDo.setAlpha(alpha);
        retDo.setBeta(beta);
        return retDo;
    }


    /**
     * 粗、细维度的统计信息，粗维度统计信息进行数据兜底，用EE策略返回，95%走利用，5%走探索
     * @param landpageSubParams
     * @param slotSubParams
     * @return
     */
    public static ScoreDo getStaticScore(LandpageSubParams landpageSubParams, LandpageSubParams slotSubParams) {
        ScoreDo retDo = new ScoreDo();

        long alpha = 10L;
        long beta = 1000L - alpha;
        // 广告位+媒体包上的统计信息
        if (slotSubParams != null) {
            long slotAdClickPv = slotSubParams.getAdClickPv();
            long slotTargetConvertPv = slotSubParams.getTargetConvertPv();
            double slotRatio = DataUtil.division((slotTargetConvertPv + alpha), (slotAdClickPv + alpha + beta), 5);

            // 目标转化大于0，且券点击pv大于目标转化pv才置信
            if (slotTargetConvertPv > 0L && slotAdClickPv >= slotTargetConvertPv) {
                slotRatio = DataUtil.division(slotTargetConvertPv, slotAdClickPv, 5);
                alpha = DataUtil.double2Long(DataUtil.division(slotTargetConvertPv, 10L));
            }
            alpha = Math.min(alpha, 50L);
            beta = DataUtil.double2Long(DataUtil.division(alpha, slotRatio) - alpha);
        }
        // 落地页上的统计信息
        if (landpageSubParams != null) {
            long landpgAdClickPv = landpageSubParams.getAdClickPv();
            long landpgTargetConvertPv = landpageSubParams.getTargetConvertPv();
            alpha = landpgTargetConvertPv + alpha;
            beta = landpgAdClickPv + beta - landpgTargetConvertPv;
        }

        double ret = Thompson.betaSampler(alpha, beta);
        double statRatio = landpageSubParams.getStatRatio();
        //根据流量当前随机数，95%走wilson下限，5%走Thompson采样
        if (Math.random() <= statRatio) {
            ret = getWilsonScore(alpha, alpha + beta);
        }

        retDo.setScore(DataUtil.formatDouble(ret, 6));
        retDo.setAlpha(alpha);
        retDo.setBeta(beta);
        return retDo;
    }

    /**
     * 细、中、粗维度的统计信息
     * 粗维度统计信息的理论消耗计算转化单价，更新中、细维度的落地页点击pv
     * 根据原始细、中维度的信息，计算策略分数，并且和更新后的细、中维度的统计信息策略分数进行融合
     *
     * @param landpageSubParams
     * @param slotSubParams
     * @param slotParams
     * @param weight
     * @return
     */
    private static cn.com.duiba.nezha.alg.alg.landpage.ScoreDo getStaticScore(LandpageSubParams landpageSubParams, LandpageSubParams slotSubParams, LandpageSubParams slotParams, Double weight) {

        cn.com.duiba.nezha.alg.alg.landpage.ScoreDo scoreDo = getStaticScore(landpageSubParams, slotSubParams);
        if (weight == null || weight <= 0.0) {
            return scoreDo;
        }


        double value = 1000.0; // 表单转化单价
        if (slotParams != null && slotParams.getLandpageClickPv() > 0L && slotParams.getTheoryFee() > 0L) {
            long landClickPv = slotParams.getLandpageClickPv();
            long theoryFee = slotParams.getTheoryFee();
            value = DataUtil.division(theoryFee, landClickPv);
        }

        long landpageSubLandClickPv = 0L, slotSubLandClickPv = 0L;
        if (landpageSubParams != null) {
            landpageSubLandClickPv = landpageSubParams.getLandpageClickPv();
            long theoryFee = landpageSubParams.getTheoryFee();
            long theoryLandClickPv = DataUtil.double2Long(DataUtil.division(theoryFee, value));
            landpageSubParams.setLandpageClickPv(theoryLandClickPv);
        }
        if (slotSubParams != null) {
            slotSubLandClickPv = slotSubParams.getLandpageClickPv();
            long theoryFee = slotSubParams.getTheoryFee();
            long theoryLandClickPv = DataUtil.double2Long(DataUtil.division(theoryFee, value));
            slotSubParams.setLandpageClickPv(theoryLandClickPv);
        }


        cn.com.duiba.nezha.alg.alg.landpage.ScoreDo theoryScoreDo = getStaticScore(landpageSubParams, slotSubParams);
        double ret = weight * theoryScoreDo.getScore() + (1 - weight) * scoreDo.getScore();

        scoreDo.setScore(DataUtil.formatDouble(ret, 6));
        scoreDo.setAlpha2(theoryScoreDo.getAlpha());
        scoreDo.setBeta2(theoryScoreDo.getBeta());

        if (landpageSubParams != null) {
            landpageSubParams.setLandpageClickPv(landpageSubLandClickPv);
        }
        if (slotSubParams != null) {
            slotSubParams.setLandpageClickPv(slotSubLandClickPv);
        }

        return scoreDo;
    }




    /**
     * 根据模型的预估值，计算排序分
     *
     * @param preEcpm
     * @param activitySubParams
     * @return
     */
    private static Double getScore(double preEcpm, ActivitySubParams activitySubParams) {
        double ret = preEcpm;

        /**
         * 1、概率1-p，score=（1-w）* preEcpm + w * statEcpm
         * 2、概率p，score= statEcpm
         */

        if (activitySubParams != null) {
            Double statEcpm = activitySubParams.getEcpm();
            Double statRatio = activitySubParams.getStatRatio();

            Double factor = activitySubParams.getFactor();

            if (statEcpm != null) {

                if (Math.random() > statRatio) {
                    // 概率1-p，score=（1-w）* preEcpm + w * statEcpm

                    ret = preEcpm * 1.0 + statEcpm * 0.0;

                } else {
                    // 概率p，score= statEcpm
                    ret = statEcpm;
                }
            }


            /**
             * 扶持因子
             * 1、新活动、冷启动控制
             * 2、扶持活动【统计表现好、拿量衰减、等】
             */
            ret = ret * factor;
        }

        return ret;
    }



    /**
     * 计算威尔逊得分
     * <p>
     * 95%的置信水平，z统计量为1.96
     *
     * @param pos   not null
     * @param total not null
     * @return
     */
    public static Double getWilsonScore(Long pos, Long total) {

        if (total == 0) {
            total = 1L;
        }
        if (pos > total) {
            pos = total;
        }

        double p = pos * 1.0 / total * 1.0;
        double z = 1.96;
        double zSquare = z * z;
        Double score = (p + (zSquare / (2 * total)) - z * Math.sqrt(4 * total * p * (1 - p) + zSquare) / (2 * total))
                / (1 + zSquare / total);

        return DataUtil.formatDouble(score, 6);
    }


    public static void main(String[] args) throws Exception {

        //"31587_1_423986_16"
        String Str1 = "{\"adClickPv\":1889,\"alpha\":0,\"beta\":0,\"ecpm\":34.92593,\"expCntPv\":3476,\"factor\":1.0,\"fee\":407830,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":395,\"statEcpm\":34.92593,\"statEcpm2\":24.35018,\"statRatio\":0.0,\"targetConvertPv\":53,\"theoryFee\":284337}";
        //"-1_1_423986_16"
        String Str2 = "{\"adClickPv\":2024,\"alpha\":0,\"beta\":0,\"ecpm\":34.77623,\"expCntPv\":3692,\"factor\":1.0,\"fee\":443536,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":424,\"statEcpm\":34.77623,\"statEcpm2\":23.5723,\"statRatio\":0.0,\"targetConvertPv\":56,\"theoryFee\":300641}";
        String Str3 = "{\"adClickPv\":39402,\"alpha\":0,\"beta\":0,\"ecpm\":92.96489,\"expCntPv\":54751,\"factor\":1.0,\"fee\":13902157,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":14587,\"statEcpm\":82.39634,\"statEcpm2\":92.96489,\"statRatio\":0.0,\"targetConvertPv\":2946,\"theoryFee\":15685315}";

//        String Str4 = "{\"adClickPv\":1889,\"alpha\":0,\"beta\":0,\"ecpm\":34.92593,\"expCntPv\":3476,\"factor\":1.0,\"fee\":407830,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":395,\"statEcpm\":34.92593,\"statEcpm2\":24.35018,\"statRatio\":0.0,\"targetConvertPv\":53,\"theoryFee\":284337}";
//        //"-1_1_423986_16"
//        String Str5 = "{\"adClickPv\":2024,\"alpha\":0,\"beta\":0,\"ecpm\":34.77623,\"expCntPv\":3692,\"factor\":1.0,\"fee\":443536,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":424,\"statEcpm\":34.77623,\"statEcpm2\":23.5723,\"statRatio\":0.0,\"targetConvertPv\":56,\"theoryFee\":300641}";
//        String Str6 = "{\"adClickPv\":39402,\"alpha\":0,\"beta\":0,\"ecpm\":92.96489,\"expCntPv\":54751,\"factor\":1.0,\"fee\":13902157,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":14587,\"statEcpm\":82.39634,\"statEcpm2\":92.96489,\"statRatio\":0.0,\"targetConvertPv\":2946,\"theoryFee\":15685315}";


        LandpageSubParams Params1 = JSON.parseObject(Str1, LandpageSubParams.class);
        LandpageSubParams Params2 = JSON.parseObject(Str2, LandpageSubParams.class);
        LandpageSubParams Params3 = JSON.parseObject(Str3, LandpageSubParams.class);
//        LandpageSubParams Params4 = JSON.parseObject(Str4, LandpageSubParams.class);
//        LandpageSubParams Params5 = JSON.parseObject(Str5, LandpageSubParams.class);
//        LandpageSubParams Params6 = JSON.parseObject(Str6, LandpageSubParams.class);

//        ScoreDo score = getStaticScore(Params1);

//        System.out.println("score:" + JSON.toJSONString(score));



        /**
         * 模拟
         */
        Map<Long, FeatureMapDo> featuremapdo = new HashMap<>();
        List<LandpageRcmdReq> landpageRcmdReqList = new ArrayList<>();
        LandpageRcmdReq a1 = new LandpageRcmdReq();
        FeatureMapDo f1 = new FeatureMapDo();

        Map<String, String> dyn = new HashMap<>();
        Map<String, String> sta = new HashMap<>();
        sta.put("langpageid","11111L");
        dyn.put("frontpage_id", "44444L");
        f1.setDynamicFeatureMap(dyn);
        f1.setStaticFeatureMap(sta);
        featuremapdo.put(11111L, f1);
        a1.setLandpageId(11111L);
        a1.setFrontpageId(44444L);

        landpageRcmdReqList.add(a1);
        LandpageRcmdReq a2 = new LandpageRcmdReq();
        FeatureMapDo f2 = new FeatureMapDo();
        Map<String, String> dyn2 = new HashMap<>();
        Map<String, String> sta2 = new HashMap<>();
        sta2.put("langpageid","22222L");
        dyn2.put("frontpage_id", "44444L");
        f2.setDynamicFeatureMap(dyn2);
        f2.setStaticFeatureMap(sta2);

        featuremapdo.put(22222L, f2);
        a2.setLandpageId(22222L);
        a2.setFrontpageId(44444L);

        landpageRcmdReqList.add(a2);
        LandpageRcmdReq a3 = new LandpageRcmdReq();
        FeatureMapDo f3 = new FeatureMapDo();
        Map<String, String> dyn3 = new HashMap<>();
        Map<String, String> sta3 = new HashMap<>();
        sta3.put("langpageid","33333L");
        dyn3.put("frontpage_id", "44444L");
        f3.setDynamicFeatureMap(dyn3);
        f3.setStaticFeatureMap(sta3);

        featuremapdo.put(33333L, f3);
        a3.setLandpageId(33333L);
        a3.setFrontpageId(44444L);

        landpageRcmdReqList.add(a3);

        LandpageParams landpageParams = new LandpageParams();
        landpageParams.setAdvertId(420615L);
        LandpageParams allParams = new LandpageParams();
        allParams.setAdvertId(-1L);
        Map<String, LandpageSubParams> fatorMap = new HashMap<>();
        Map<String, LandpageSubParams> factorMap2 = new HashMap<>();
//        String slotStrs = "{\"adClickPv\":2229,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":7.57242,\"expCntPv\":3377,\"factor\":1.0,\"fee\":110474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":179,\"statEcpm\":7.57242,\"statEcpm2\":7.55213,\"statRatio\":0.0,\"targetConvertPv\":53,\"theoryFee\":110178}";
//        LandpageSubParams slotParam = JSON.parseObject(slotStrs, LandpageSubParams.class);
//        fatorMap.put("-1_1_420615_-1", slotParam);
//
//        String slotSubStrs = "{\"adClickPv\":5846,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":8.41236,\"expCntPv\":8908,\"factor\":1.0,\"fee\":306700,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":480,\"statEcpm\":7.69888,\"statEcpm2\":8.41236,\"statRatio\":0.0,\"targetConvertPv\":147,\"theoryFee\":335123}";
//        LandpageSubParams slotSubParam = JSON.parseObject(slotSubStrs, LandpageSubParams.class);
//        fatorMap.put("-1_1_420615_null", slotSubParam);


        //广告计划
        String a10Strs = "{\"adClickPv\":34990,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":2570,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.95,\"targetConvertPv\":820,\"theoryFee\":188489}";
        LandpageSubParams a10Params = JSON.parseObject(a10Strs, LandpageSubParams.class);
        fatorMap.put("420615_-1_-1_-1_-1", a10Params);
//        fatorMap.put("420615_-1_-1_-1_-1", null);

        // 广告计划+广告位
        String a11Strs = "{\"adClickPv\":4990,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":270,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.95,\"targetConvertPv\":220,\"theoryFee\":188489}";
        LandpageSubParams a11Params = JSON.parseObject(a11Strs, LandpageSubParams.class);
        fatorMap.put("420615_-1_99_-1_-1", a11Params);
//        fatorMap.put("420615_-1_99_-1_-1", null);

        // 广告计划+媒体包
        String a12Strs = "{\"adClickPv\":8990,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":570,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.95,\"targetConvertPv\":520,\"theoryFee\":188489}";
        LandpageSubParams a12Params = JSON.parseObject(a12Strs, LandpageSubParams.class);
        fatorMap.put("420615_-1_-1_88_-1", a12Params);
//        fatorMap.put("420615_-1_-1_88_-1", null);

        //广告计划+落地页id+广告位
        String a21Strs = "{\"adClickPv\":3499,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":257,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.95,\"targetConvertPv\":82,\"theoryFee\":188489}";
        LandpageSubParams a21Params = JSON.parseObject(a21Strs, LandpageSubParams.class);
        fatorMap.put("420615_11111_-1_-1_-1", a21Params);
//        fatorMap.put("420615_11111_-1_-1_-1", null);

        //广告计划+落地页id+广告位
        String a22Strs = "{\"adClickPv\":589,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":7.60399,\"expCntPv\":841,\"factor\":1.0,\"fee\":19814,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":31,\"statEcpm\":5.81227,\"statEcpm2\":7.60399,\"statRatio\":0.95,\"targetConvertPv\":15,\"theoryFee\":25922}";
        LandpageSubParams a22Params = JSON.parseObject(a22Strs, LandpageSubParams.class);
        fatorMap.put("420615_22222_-1_-1_-1", a22Params);
//        fatorMap.put("420615_22222_-1_-1_-1", null);

        //广告计划+落地页id+广告位
        String a23Strs = "{\"adClickPv\":92,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":11.96816,\"expCntPv\":154,\"factor\":1.0,\"fee\":5637,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":6,\"statEcpm\":11.96816,\"statEcpm2\":0.0,\"statRatio\":0.95,\"targetConvertPv\":0,\"theoryFee\":0}";
        LandpageSubParams a23Params = JSON.parseObject(a23Strs, LandpageSubParams.class);
        fatorMap.put("420615_33333_-1_-1_-1", a23Params);
//        fatorMap.put("420615_33333_-1_-1_-1", null);



        //广告计划+落地页id+广告位
        String a1Strs = "{\"adClickPv\":3499,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":257,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.95,\"targetConvertPv\":82,\"theoryFee\":188489}";
        LandpageSubParams a1Params = JSON.parseObject(a1Strs, LandpageSubParams.class);
        fatorMap.put("420615_11111_99_-1_-1", a1Params);
//        fatorMap.put("420615_11111_99_-1_-1", null);

        //广告计划+落地页id+广告位
        String a2Strs = "{\"adClickPv\":589,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":7.60399,\"expCntPv\":841,\"factor\":1.0,\"fee\":19814,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":31,\"statEcpm\":5.81227,\"statEcpm2\":7.60399,\"statRatio\":0.95,\"targetConvertPv\":15,\"theoryFee\":25922}";
        LandpageSubParams a2Params = JSON.parseObject(a2Strs, LandpageSubParams.class);
        fatorMap.put("420615_22222_99_-1_-1", a2Params);
//        fatorMap.put("420615_22222_99_-1_-1", null);

        //广告计划+落地页id+广告位
        String a3Strs = "{\"adClickPv\":92,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":11.96816,\"expCntPv\":154,\"factor\":1.0,\"fee\":5637,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":6,\"statEcpm\":11.96816,\"statEcpm2\":0.0,\"statRatio\":0.95,\"targetConvertPv\":0,\"theoryFee\":0}";
        LandpageSubParams a3Params = JSON.parseObject(a3Strs, LandpageSubParams.class);
        fatorMap.put("420615_33333_99_-1_-1", a3Params);
//        fatorMap.put("420615_33333_99_-1_-1", null);

        //广告计划+落地页id+媒体包
        String a7Strs = "{\"adClickPv\":5499,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":457,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.95,\"targetConvertPv\":102,\"theoryFee\":188489}";
        LandpageSubParams a7Params = JSON.parseObject(a7Strs, LandpageSubParams.class);
        fatorMap.put("420615_11111_-1_88_-1", a7Params);
//        fatorMap.put("420615_11111_-1_88_-1", null);

        //广告计划+落地页id+广告位
        String a8Strs = "{\"adClickPv\":789,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":7.60399,\"expCntPv\":841,\"factor\":1.0,\"fee\":19814,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":61,\"statEcpm\":5.81227,\"statEcpm2\":7.60399,\"statRatio\":0.95,\"targetConvertPv\":25,\"theoryFee\":25922}";
        LandpageSubParams a8Params = JSON.parseObject(a8Strs, LandpageSubParams.class);
        fatorMap.put("420615_22222_-1_88_-1", a8Params);
//        fatorMap.put("420615_22222_-1_88_-1", null);

        //广告计划+落地页id+广告位
        String a9Strs = "{\"adClickPv\":122,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":11.96816,\"expCntPv\":154,\"factor\":1.0,\"fee\":5637,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":12,\"statEcpm\":11.96816,\"statEcpm2\":0.0,\"statRatio\":0.95,\"targetConvertPv\":2,\"theoryFee\":0}";
        LandpageSubParams a9Params = JSON.parseObject(a9Strs, LandpageSubParams.class);
        fatorMap.put("420615_33333_-1_88_-1", a9Params);
//        fatorMap.put("420615_33333_-1_88_-1", null);
        landpageParams.setFatorMap(fatorMap);

        //前置页id+广告位
        String a4Strs = "{\"adClickPv\":6666,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":5555,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.95,\"targetConvertPv\":2222,\"theoryFee\":188489}";
        LandpageSubParams a4Params = JSON.parseObject(a4Strs, LandpageSubParams.class);
        factorMap2.put("-1_-1_99_-1_44444", a4Params);
        factorMap2.put("-1_-1_99_-1_44444", null);

        //前置页id + 媒体包
        String a5Strs = "{\"adClickPv\":8888,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":7.60399,\"expCntPv\":841,\"factor\":1.0,\"fee\":19814,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":7777,\"statEcpm\":5.81227,\"statEcpm2\":7.60399,\"statRatio\":0.95,\"targetConvertPv\":3333,\"theoryFee\":25922}";
        LandpageSubParams a5Params = JSON.parseObject(a5Strs, LandpageSubParams.class);
        factorMap2.put("-1_-1_-1_88_44444", a5Params);
        factorMap2.put("-1_-1_-1_88_44444", null);

        //前置页id
        String a6Strs = "{\"adClickPv\":66666,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":11.96816,\"expCntPv\":154,\"factor\":1.0,\"fee\":5637,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":44444,\"statEcpm\":11.96816,\"statEcpm2\":0.0,\"statRatio\":0.95,\"targetConvertPv\":11111,\"theoryFee\":0}";
        LandpageSubParams a6Params = JSON.parseObject(a6Strs, LandpageSubParams.class);
        factorMap2.put("-1_-1_-1_-1_44444", a6Params);
        factorMap2.put("-1_-1_-1_-1_44444", null);


        //广告位
        String a41Strs = "{\"adClickPv\":100000,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":54330,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.95,\"targetConvertPv\":38902,\"theoryFee\":188489}";
        LandpageSubParams a41Params = JSON.parseObject(a41Strs, LandpageSubParams.class);
        factorMap2.put("-1_-1_99_-1_-1", a41Params);
        factorMap2.put("-1_-1_99_-1_-1", null);

        //媒体包
        String a51Strs = "{\"adClickPv\":200000,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":7.60399,\"expCntPv\":841,\"factor\":1.0,\"fee\":19814,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":68900,\"statEcpm\":5.81227,\"statEcpm2\":7.60399,\"statRatio\":0.95,\"targetConvertPv\":43200,\"theoryFee\":25922}";
        LandpageSubParams a51Params = JSON.parseObject(a51Strs, LandpageSubParams.class);
        factorMap2.put("-1_-1_-1_88_-1", a51Params);
        factorMap2.put("-1_-1_-1_88_-1", null);

        //所有大盘
        String a61Strs = "{\"adClickPv\":1000000,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":11.96816,\"expCntPv\":154,\"factor\":1.0,\"fee\":5637,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":678901,\"statEcpm\":11.96816,\"statEcpm2\":0.0,\"statRatio\":0.95,\"targetConvertPv\":487902,\"theoryFee\":0}";
        LandpageSubParams a61Params = JSON.parseObject(a61Strs, LandpageSubParams.class);
        factorMap2.put("-1_-1_-1_-1_-1", a61Params);
        factorMap2.put("-1_-1_-1_-1_-1", null);
        allParams.setFatorMap(factorMap2);


        AdBidResultDo Top1Advert = new AdBidResultDo();

        Top1Advert.setSlotId(99L);
        Top1Advert.setAdvertId(420615L);

        for (int i = 0; i < 10; i++) {
            AdBidResultDo Ret = LandpageRcmder.rcmd(landpageRcmdReqList, null, null, null, Top1Advert, "88", featuremapdo);
            System.out.println("AdBidResultDo: " + JSON.toJSONString(Ret));
            System.out.println("finish");
        }


    }

}
