/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.landpage;

import cn.com.duiba.nezha.alg.alg.activity.ActivityInfo;
import cn.com.duiba.nezha.alg.alg.activity.ActivitySubParams;
import cn.com.duiba.nezha.alg.alg.activity.SlotInfo;
import cn.com.duiba.nezha.alg.alg.activity.Thompson;
import cn.com.duiba.nezha.alg.alg.landpage.LandpageParams;
import cn.com.duiba.nezha.alg.alg.landpage.LandpageRcmdReq;
import cn.com.duiba.nezha.alg.alg.landpage.LandpageRcmdRet;
import cn.com.duiba.nezha.alg.alg.landpage.LandpageSubParams;
import cn.com.duiba.nezha.alg.alg.landpage.ScoreDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.api.model.E2ELocalTFModel;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LandpageRcmder {
    private static final Logger logger = LoggerFactory.getLogger(LandpageRcmder.class);
    private static String LOG_PRIFIX = "LandpageRcmder";
    private static HashMap<Long, String> sActMap = new HashMap();
    private static HashMap<Long, Long> dActMap = new HashMap();
    private static Random random = new Random();
    private static HashMap<Long, ActivityInfo> actWhiteList = new HashMap();
    private static HashMap<Long, SlotInfo> slotWhiteList = new HashMap();
    private static List testList = Arrays.asList(30942L, 30828L, 26497L, 30222L, 30784L, 31234L, 31352L, 31185L, 31475L, 31557L, 31545L, 30192L);

    public static Long getAlgRcmdType0() {
        double rd = Math.random();
        if (rd <= 0.2) {
            return 3L;
        }
        return 4L;
    }

    public static Long getAlgRcmdType1() {
        double rd = Math.random();
        if (rd <= 0.95) {
            return 3L;
        }
        return 5L;
    }

    public static Long getAlgRcmdType2() {
        double rd = Math.random();
        if (rd <= 0.2) {
            return 3L;
        }
        return 4L;
    }

    public static Long getActType(Long activityId) {
        Long ret = null;
        ActivityInfo activityInfo = actWhiteList.get(activityId);
        if (activityInfo != null && activityInfo.getActType() != null) {
            ret = activityInfo.getActType();
        }
        return ret;
    }

    public static String getActTrade2(Long activityId) {
        String ret = null;
        ActivityInfo activityInfo = actWhiteList.get(activityId);
        if (activityInfo != null && activityInfo.getActTrade2() != null) {
            ret = activityInfo.getActTrade2();
        }
        return ret;
    }

    public static Long getDefActId(Long slotId) {
        Long ret = null;
        SlotInfo slotInfo = slotWhiteList.get(slotId);
        if (slotInfo != null && slotInfo.getDefActId() != null) {
            ret = slotInfo.getDefActId();
        }
        return ret;
    }

    public static Long getDefActType(Long slotId) {
        Long ret = null;
        SlotInfo slotInfo = slotWhiteList.get(slotId);
        if (slotInfo != null && slotInfo.getDefActType() != null) {
            ret = slotInfo.getDefActType();
        }
        return ret;
    }

    public static Map<Long, Double> predict(Map<Long, FeatureMapDo> featureMapDoMap, E2ELocalTFModel deepModel) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{deepModel})) {
            try {
                HashMap<Long, Map> modelInput = new HashMap<Long, Map>();
                for (Map.Entry<Long, FeatureMapDo> entry : featureMapDoMap.entrySet()) {
                    modelInput.put(entry.getKey(), entry.getValue().getFeatureMap());
                }
                Map ret = deepModel.predict(modelInput);
                return ret;
            }
            catch (Exception e) {
                logger.error("LandpageRecommend.predictScore error{}, Model{}", (Object)e, (Object)deepModel);
                return Collections.emptyMap();
            }
        }
        return new HashMap<Long, Double>();
    }

    public static Map<Long, Double> predict(Map<Long, FeatureMapDo> featureMapDoMap, DeepModelV2 deepModelV2, LocalTFModelV2 localTFModelV2) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{deepModelV2, localTFModelV2})) {
            return deepModelV2.predictWithLocalTFV2(featureMapDoMap, localTFModelV2);
        }
        return new HashMap<Long, Double>();
    }

    public static AdBidResultDo rcmd(List<LandpageRcmdReq> landpageRcmdReqList, LandpageParams landpageParams, LandpageParams allParams, Map<Long, Double> preEcpmMap, AdBidResultDo Top1Advert, String appPkgTrade2, Map<Long, FeatureMapDo> featuremapdo) throws Exception {
        Long advertId = Top1Advert.getAdvertId();
        Long slotId = (long)Top1Advert.getSlotId();
        List<LandpageRcmdRet> landpageRcmdRetList = LandpageRcmder.getScore(landpageRcmdReqList, landpageParams, allParams, preEcpmMap, slotId, advertId, appPkgTrade2);
        if (AssertUtil.isEmpty(landpageRcmdRetList)) {
            if (Top1Advert.getAdBidParamsDo() == null) {
                Top1Advert.setAdBidParamsDo(new AdBidParamsDo());
            }
            Top1Advert.getAdBidParamsDo().setLandpageTop(new LandpageRcmdRet());
            return Top1Advert;
        }
        landpageRcmdRetList = landpageRcmdRetList.stream().sorted(Comparator.comparing(LandpageRcmdRet::getScore).reversed()).collect(Collectors.toList());
        LandpageRcmdRet landpagetop = null;
        if (landpageRcmdRetList.get(0).getScore() == 0.0) {
            Random r = new Random();
            int idx = r.nextInt(landpageRcmdRetList.size());
            landpagetop = landpageRcmdRetList.get(idx);
        } else {
            landpagetop = landpageRcmdRetList.get(0);
        }
        landpagetop.setFeatureMap(featuremapdo.get(landpagetop.getLandpageId()).getFeatureMap());
        if (Top1Advert.getAdBidParamsDo() == null) {
            Top1Advert.setAdBidParamsDo(new AdBidParamsDo());
        }
        AdBidParamsDo printdo = Top1Advert.getAdBidParamsDo();
        printdo.setLandpageTop(landpagetop);
        return Top1Advert;
    }

    public static List<LandpageRcmdRet> getScore(List<LandpageRcmdReq> landpageRcmdReqList, LandpageParams landpageParams, LandpageParams allParams, Map<Long, Double> preEcpmMap, Long slotId, Long advertId, String appPkgTrade2) throws Exception {
        ArrayList<LandpageRcmdRet> ret = new ArrayList<LandpageRcmdRet>();
        if (AssertUtil.isEmpty(landpageRcmdReqList)) {
            logger.warn(LOG_PRIFIX + ".getScore  landpageRcmdReqList is Empty,invaild");
            return ret;
        }
        for (LandpageRcmdReq landpageReq : landpageRcmdReqList) {
            Long landpageId = landpageReq.getLandpageId();
            Long frontpageId = landpageReq.getFrontpageId();
            Long paypageId = landpageReq.getPaypageId();
            Long formpageId = landpageReq.getFormpageId();
            Long modelId = landpageReq.getModelId();
            Double preEcpm = 0.0011;
            LandpageSubParams landpgParams = null;
            LandpageSubParams landpgSlotParams = null;
            LandpageSubParams landpgPkgParams = null;
            LandpageSubParams advertParams = null;
            LandpageSubParams advertSlotParams = null;
            LandpageSubParams advertPkgParams = null;
            LandpageSubParams frontpgParams = null;
            LandpageSubParams frontpgSlotParams = null;
            LandpageSubParams frontpgPkgParams = null;
            LandpageSubParams frontpgSubParams = null;
            LandpageSubParams frontpgSlotSubParams = null;
            LandpageSubParams frontpgPkgSubParams = null;
            Double[] weight = new Double[]{1.2, 2.0, 2.0, 1.0, 1.0, 1.0};
            if (landpageParams != null) {
                weight = landpageParams.getWeight();
                landpgParams = landpageParams.getFactor(advertId, landpageId, -1L, "-1", -1L);
                landpgSlotParams = landpageParams.getFactor(advertId, landpageId, slotId, "-1", -1L);
                landpgPkgParams = landpageParams.getFactor(advertId, landpageId, -1L, appPkgTrade2, -1L);
                advertParams = landpageParams.getFactor(advertId, -1L, -1L, "-1", -1L);
                advertSlotParams = landpageParams.getFactor(advertId, -1L, slotId, "-1", -1L);
                advertPkgParams = landpageParams.getFactor(advertId, -1L, -1L, appPkgTrade2, -1L);
            }
            if (allParams != null) {
                frontpgSubParams = allParams.getFactor(-1L, -1L, -1L, "-1", frontpageId);
                frontpgSlotSubParams = allParams.getFactor(-1L, -1L, slotId, "-1", frontpageId);
                frontpgPkgSubParams = allParams.getFactor(-1L, -1L, -1L, appPkgTrade2, frontpageId);
                frontpgParams = allParams.getFactor(-1L, -1L, -1L, "-1", -1L);
                frontpgSlotParams = allParams.getFactor(-1L, -1L, slotId, "-1", -1L);
                frontpgPkgParams = allParams.getFactor(-1L, -1L, -1L, appPkgTrade2, -1L);
            }
            Double score = 0.0;
            Double rd = Math.random();
            ArrayList<Long> alpha = new ArrayList<Long>();
            ArrayList<Long> beta = new ArrayList<Long>();
            ArrayList<ScoreDo> ScoreDoList = new ArrayList<ScoreDo>();
            if (landpgParams != null && advertParams != null) {
                ScoreDoList.add(LandpageRcmder.getStaticScore(landpgParams, advertParams, rd));
            }
            if (landpgSlotParams != null && advertSlotParams != null) {
                ScoreDoList.add(LandpageRcmder.getStaticScore(landpgSlotParams, advertSlotParams, rd));
            }
            if (landpgPkgParams != null && advertPkgParams != null) {
                ScoreDoList.add(LandpageRcmder.getStaticScore(landpgPkgParams, advertPkgParams, rd));
            }
            if (frontpgParams != null && frontpgParams != null) {
                ScoreDoList.add(LandpageRcmder.getStaticScore(frontpgSubParams, frontpgParams, rd));
            }
            if (frontpgSlotParams != null && frontpgSlotParams != null) {
                ScoreDoList.add(LandpageRcmder.getStaticScore(frontpgSlotSubParams, frontpgSlotParams, rd));
            }
            if (frontpgPkgParams != null && frontpgPkgParams != null) {
                ScoreDoList.add(LandpageRcmder.getStaticScore(frontpgPkgSubParams, frontpgPkgParams, rd));
            }
            Integer i = 0;
            Double sum = 0.0;
            for (ScoreDo scoreDo : ScoreDoList) {
                score = score + weight[i] * scoreDo.getScore();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
                sum = sum + weight[n];
                alpha.add(scoreDo.getAlpha());
                beta.add(scoreDo.getBeta());
            }
            if (sum > 0.0) {
                score = score / sum;
            }
            LandpageRcmdRet landpageRcmdRet = new LandpageRcmdRet();
            landpageRcmdRet.setLandpageId(landpageId);
            landpageRcmdRet.setScore(score);
            landpageRcmdRet.setPreEcpm(preEcpm);
            landpageRcmdRet.setAlpha(alpha);
            landpageRcmdRet.setBeta(beta);
            ret.add(landpageRcmdRet);
        }
        return ret;
    }

    public static ScoreDo getStaticScore(LandpageSubParams landpgParams, LandpageSubParams advertParams, double rd) {
        ScoreDo retDo = new ScoreDo();
        long alpha = 20L;
        long beta = 100L - alpha;
        if (advertParams != null) {
            long adClickPv = advertParams.getAdClickPv();
            long mergePosPv = advertParams.getMergePosPv();
            double ratio = DataUtil.division((Long)(mergePosPv + alpha), (Long)(adClickPv + alpha + beta), (int)5);
            if (mergePosPv > 100L && adClickPv >= mergePosPv) {
                ratio = DataUtil.division((Long)mergePosPv, (Long)adClickPv, (int)5);
                alpha = DataUtil.double2Long((Double)DataUtil.division((Long)mergePosPv, (Long)10L));
            }
            alpha = Math.min(alpha, 50L);
            beta = DataUtil.double2Long((Double)(DataUtil.division((Long)alpha, (Double)ratio) - (double)alpha));
        }
        double statRatio = 0.95;
        if (landpgParams != null) {
            long adClickPv = landpgParams.getAdClickPv();
            long mergePosPv = landpgParams.getMergePosPv();
            statRatio = landpgParams.getStatRatio();
            alpha = mergePosPv + alpha;
            beta = adClickPv + beta - mergePosPv;
        }
        double ret = Thompson.betaSampler(alpha, beta);
        if (rd <= statRatio) {
            ret = LandpageRcmder.getWilsonScore(alpha, alpha + beta);
        }
        retDo.setScore(DataUtil.formatDouble((Double)ret, (int)6));
        retDo.setAlpha(alpha);
        retDo.setBeta(beta);
        return retDo;
    }

    public static ScoreDo getStaticScore(LandpageSubParams landpageSubParams, LandpageSubParams slotSubParams) {
        ScoreDo retDo = new ScoreDo();
        long alpha = 10L;
        long beta = 1000L - alpha;
        if (slotSubParams != null) {
            long slotAdClickPv = slotSubParams.getAdClickPv();
            long slotTargetConvertPv = slotSubParams.getTargetConvertPv();
            double slotRatio = DataUtil.division((Long)(slotTargetConvertPv + alpha), (Long)(slotAdClickPv + alpha + beta), (int)5);
            if (slotTargetConvertPv > 0L && slotAdClickPv >= slotTargetConvertPv) {
                slotRatio = DataUtil.division((Long)slotTargetConvertPv, (Long)slotAdClickPv, (int)5);
                alpha = DataUtil.double2Long((Double)DataUtil.division((Long)slotTargetConvertPv, (Long)10L));
            }
            alpha = Math.min(alpha, 50L);
            beta = DataUtil.double2Long((Double)(DataUtil.division((Long)alpha, (Double)slotRatio) - (double)alpha));
        }
        if (landpageSubParams != null) {
            long landpgAdClickPv = landpageSubParams.getAdClickPv();
            long landpgTargetConvertPv = landpageSubParams.getTargetConvertPv();
            alpha = landpgTargetConvertPv + alpha;
            beta = landpgAdClickPv + beta - landpgTargetConvertPv;
        }
        double ret = Thompson.betaSampler(alpha, beta);
        double statRatio = landpageSubParams.getStatRatio();
        if (Math.random() <= statRatio) {
            ret = LandpageRcmder.getWilsonScore(alpha, alpha + beta);
        }
        retDo.setScore(DataUtil.formatDouble((Double)ret, (int)6));
        retDo.setAlpha(alpha);
        retDo.setBeta(beta);
        return retDo;
    }

    private static ScoreDo getStaticScore(LandpageSubParams landpageSubParams, LandpageSubParams slotSubParams, LandpageSubParams slotParams, Double weight) {
        long theoryLandClickPv;
        long theoryFee;
        ScoreDo scoreDo = LandpageRcmder.getStaticScore(landpageSubParams, slotSubParams);
        if (weight == null || weight <= 0.0) {
            return scoreDo;
        }
        double value = 1000.0;
        if (slotParams != null && slotParams.getLandpageClickPv() > 0L && slotParams.getTheoryFee() > 0L) {
            long landClickPv = slotParams.getLandpageClickPv();
            long theoryFee2 = slotParams.getTheoryFee();
            value = DataUtil.division((Long)theoryFee2, (Long)landClickPv);
        }
        long landpageSubLandClickPv = 0L;
        long slotSubLandClickPv = 0L;
        if (landpageSubParams != null) {
            landpageSubLandClickPv = landpageSubParams.getLandpageClickPv();
            theoryFee = landpageSubParams.getTheoryFee();
            theoryLandClickPv = DataUtil.double2Long((Double)DataUtil.division((Long)theoryFee, (Double)value));
            landpageSubParams.setLandpageClickPv(theoryLandClickPv);
        }
        if (slotSubParams != null) {
            slotSubLandClickPv = slotSubParams.getLandpageClickPv();
            theoryFee = slotSubParams.getTheoryFee();
            theoryLandClickPv = DataUtil.double2Long((Double)DataUtil.division((Long)theoryFee, (Double)value));
            slotSubParams.setLandpageClickPv(theoryLandClickPv);
        }
        ScoreDo theoryScoreDo = LandpageRcmder.getStaticScore(landpageSubParams, slotSubParams);
        double ret = weight * theoryScoreDo.getScore() + (1.0 - weight) * scoreDo.getScore();
        scoreDo.setScore(DataUtil.formatDouble((Double)ret, (int)6));
        scoreDo.setAlpha2(theoryScoreDo.getAlpha());
        scoreDo.setBeta2(theoryScoreDo.getBeta());
        if (landpageSubParams != null) {
            landpageSubParams.setLandpageClickPv(landpageSubLandClickPv);
        }
        if (slotSubParams != null) {
            slotSubParams.setLandpageClickPv(slotSubLandClickPv);
        }
        return scoreDo;
    }

    private static Double getScore(double preEcpm, ActivitySubParams activitySubParams) {
        double ret = preEcpm;
        if (activitySubParams != null) {
            Double statEcpm = activitySubParams.getEcpm();
            Double statRatio = activitySubParams.getStatRatio();
            Double factor = activitySubParams.getFactor();
            if (statEcpm != null) {
                ret = Math.random() > statRatio ? preEcpm * 1.0 + statEcpm * 0.0 : statEcpm;
            }
            ret *= factor.doubleValue();
        }
        return ret;
    }

    public static Double getWilsonScore(Long pos, Long total) {
        if (total == 0L) {
            total = 1L;
        }
        if (pos > total) {
            pos = total;
        }
        double p = (double)pos.longValue() * 1.0 / (double)total.longValue() * 1.0;
        double z = 1.96;
        double zSquare = z * z;
        Double score = (p + zSquare / (double)(2L * total) - z * Math.sqrt((double)(4L * total) * p * (1.0 - p) + zSquare) / (double)(2L * total)) / (1.0 + zSquare / (double)total.longValue());
        return DataUtil.formatDouble((Double)score, (int)6);
    }

    public static void main(String[] args) throws Exception {
        String Str1 = "{\"adClickPv\":1889,\"alpha\":0,\"beta\":0,\"ecpm\":34.92593,\"expCntPv\":3476,\"factor\":1.0,\"fee\":407830,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":395,\"statEcpm\":34.92593,\"statEcpm2\":24.35018,\"statRatio\":0.0,\"targetConvertPv\":53,\"theoryFee\":284337}";
        String Str2 = "{\"adClickPv\":2024,\"alpha\":0,\"beta\":0,\"ecpm\":34.77623,\"expCntPv\":3692,\"factor\":1.0,\"fee\":443536,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":424,\"statEcpm\":34.77623,\"statEcpm2\":23.5723,\"statRatio\":0.0,\"targetConvertPv\":56,\"theoryFee\":300641}";
        String Str3 = "{\"adClickPv\":39402,\"alpha\":0,\"beta\":0,\"ecpm\":92.96489,\"expCntPv\":54751,\"factor\":1.0,\"fee\":13902157,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":14587,\"statEcpm\":82.39634,\"statEcpm2\":92.96489,\"statRatio\":0.0,\"targetConvertPv\":2946,\"theoryFee\":15685315}";
        LandpageSubParams Params1 = (LandpageSubParams)JSON.parseObject((String)Str1, LandpageSubParams.class);
        LandpageSubParams Params2 = (LandpageSubParams)JSON.parseObject((String)Str2, LandpageSubParams.class);
        LandpageSubParams Params3 = (LandpageSubParams)JSON.parseObject((String)Str3, LandpageSubParams.class);
        HashMap<Long, FeatureMapDo> featuremapdo = new HashMap<Long, FeatureMapDo>();
        ArrayList<LandpageRcmdReq> landpageRcmdReqList = new ArrayList<LandpageRcmdReq>();
        LandpageRcmdReq a1 = new LandpageRcmdReq();
        FeatureMapDo f1 = new FeatureMapDo();
        HashMap<String, String> dyn = new HashMap<String, String>();
        HashMap<String, String> sta = new HashMap<String, String>();
        sta.put("langpageid", "11111L");
        dyn.put("frontpage_id", "44444L");
        f1.setDynamicFeatureMap(dyn);
        f1.setStaticFeatureMap(sta);
        featuremapdo.put(11111L, f1);
        a1.setLandpageId(11111L);
        a1.setFrontpageId(44444L);
        landpageRcmdReqList.add(a1);
        LandpageRcmdReq a2 = new LandpageRcmdReq();
        FeatureMapDo f2 = new FeatureMapDo();
        HashMap<String, String> dyn2 = new HashMap<String, String>();
        HashMap<String, String> sta2 = new HashMap<String, String>();
        sta2.put("langpageid", "22222L");
        dyn2.put("frontpage_id", "44444L");
        f2.setDynamicFeatureMap(dyn2);
        f2.setStaticFeatureMap(sta2);
        featuremapdo.put(22222L, f2);
        a2.setLandpageId(22222L);
        a2.setFrontpageId(44444L);
        landpageRcmdReqList.add(a2);
        LandpageRcmdReq a3 = new LandpageRcmdReq();
        FeatureMapDo f3 = new FeatureMapDo();
        HashMap<String, String> dyn3 = new HashMap<String, String>();
        HashMap<String, String> sta3 = new HashMap<String, String>();
        sta3.put("langpageid", "33333L");
        dyn3.put("frontpage_id", "44444L");
        f3.setDynamicFeatureMap(dyn3);
        f3.setStaticFeatureMap(sta3);
        featuremapdo.put(33333L, f3);
        a3.setLandpageId(33333L);
        a3.setFrontpageId(44444L);
        landpageRcmdReqList.add(a3);
        LandpageParams landpageParams = new LandpageParams();
        landpageParams.setAdvertId(420615L);
        LandpageParams allParams = new LandpageParams();
        allParams.setAdvertId(-1L);
        HashMap<String, LandpageSubParams> fatorMap = new HashMap<String, LandpageSubParams>();
        HashMap<String, LandpageSubParams> factorMap2 = new HashMap<String, LandpageSubParams>();
        String a10Strs = "{\"adClickPv\":34990,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":2570,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.95,\"targetConvertPv\":820,\"theoryFee\":188489}";
        LandpageSubParams a10Params = (LandpageSubParams)JSON.parseObject((String)a10Strs, LandpageSubParams.class);
        fatorMap.put("420615_-1_-1_-1_-1", a10Params);
        String a11Strs = "{\"adClickPv\":4990,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":270,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.95,\"targetConvertPv\":220,\"theoryFee\":188489}";
        LandpageSubParams a11Params = (LandpageSubParams)JSON.parseObject((String)a11Strs, LandpageSubParams.class);
        fatorMap.put("420615_-1_99_-1_-1", a11Params);
        String a12Strs = "{\"adClickPv\":8990,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":570,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.95,\"targetConvertPv\":520,\"theoryFee\":188489}";
        LandpageSubParams a12Params = (LandpageSubParams)JSON.parseObject((String)a12Strs, LandpageSubParams.class);
        fatorMap.put("420615_-1_-1_88_-1", a12Params);
        String a21Strs = "{\"adClickPv\":3499,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":257,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.95,\"targetConvertPv\":82,\"theoryFee\":188489}";
        LandpageSubParams a21Params = (LandpageSubParams)JSON.parseObject((String)a21Strs, LandpageSubParams.class);
        fatorMap.put("420615_11111_-1_-1_-1", a21Params);
        String a22Strs = "{\"adClickPv\":589,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":7.60399,\"expCntPv\":841,\"factor\":1.0,\"fee\":19814,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":31,\"statEcpm\":5.81227,\"statEcpm2\":7.60399,\"statRatio\":0.95,\"targetConvertPv\":15,\"theoryFee\":25922}";
        LandpageSubParams a22Params = (LandpageSubParams)JSON.parseObject((String)a22Strs, LandpageSubParams.class);
        fatorMap.put("420615_22222_-1_-1_-1", a22Params);
        String a23Strs = "{\"adClickPv\":92,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":11.96816,\"expCntPv\":154,\"factor\":1.0,\"fee\":5637,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":6,\"statEcpm\":11.96816,\"statEcpm2\":0.0,\"statRatio\":0.95,\"targetConvertPv\":0,\"theoryFee\":0}";
        LandpageSubParams a23Params = (LandpageSubParams)JSON.parseObject((String)a23Strs, LandpageSubParams.class);
        fatorMap.put("420615_33333_-1_-1_-1", a23Params);
        String a1Strs = "{\"adClickPv\":3499,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":257,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.95,\"targetConvertPv\":82,\"theoryFee\":188489}";
        LandpageSubParams a1Params = (LandpageSubParams)JSON.parseObject((String)a1Strs, LandpageSubParams.class);
        fatorMap.put("420615_11111_99_-1_-1", a1Params);
        String a2Strs = "{\"adClickPv\":589,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":7.60399,\"expCntPv\":841,\"factor\":1.0,\"fee\":19814,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":31,\"statEcpm\":5.81227,\"statEcpm2\":7.60399,\"statRatio\":0.95,\"targetConvertPv\":15,\"theoryFee\":25922}";
        LandpageSubParams a2Params = (LandpageSubParams)JSON.parseObject((String)a2Strs, LandpageSubParams.class);
        fatorMap.put("420615_22222_99_-1_-1", a2Params);
        String a3Strs = "{\"adClickPv\":92,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":11.96816,\"expCntPv\":154,\"factor\":1.0,\"fee\":5637,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":6,\"statEcpm\":11.96816,\"statEcpm2\":0.0,\"statRatio\":0.95,\"targetConvertPv\":0,\"theoryFee\":0}";
        LandpageSubParams a3Params = (LandpageSubParams)JSON.parseObject((String)a3Strs, LandpageSubParams.class);
        fatorMap.put("420615_33333_99_-1_-1", a3Params);
        String a7Strs = "{\"adClickPv\":5499,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":457,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.95,\"targetConvertPv\":102,\"theoryFee\":188489}";
        LandpageSubParams a7Params = (LandpageSubParams)JSON.parseObject((String)a7Strs, LandpageSubParams.class);
        fatorMap.put("420615_11111_-1_88_-1", a7Params);
        String a8Strs = "{\"adClickPv\":789,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":7.60399,\"expCntPv\":841,\"factor\":1.0,\"fee\":19814,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":61,\"statEcpm\":5.81227,\"statEcpm2\":7.60399,\"statRatio\":0.95,\"targetConvertPv\":25,\"theoryFee\":25922}";
        LandpageSubParams a8Params = (LandpageSubParams)JSON.parseObject((String)a8Strs, LandpageSubParams.class);
        fatorMap.put("420615_22222_-1_88_-1", a8Params);
        String a9Strs = "{\"adClickPv\":122,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":11.96816,\"expCntPv\":154,\"factor\":1.0,\"fee\":5637,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":12,\"statEcpm\":11.96816,\"statEcpm2\":0.0,\"statRatio\":0.95,\"targetConvertPv\":2,\"theoryFee\":0}";
        LandpageSubParams a9Params = (LandpageSubParams)JSON.parseObject((String)a9Strs, LandpageSubParams.class);
        fatorMap.put("420615_33333_-1_88_-1", a9Params);
        landpageParams.setFatorMap(fatorMap);
        String a4Strs = "{\"adClickPv\":6666,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":5555,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.95,\"targetConvertPv\":2222,\"theoryFee\":188489}";
        LandpageSubParams a4Params = (LandpageSubParams)JSON.parseObject((String)a4Strs, LandpageSubParams.class);
        factorMap2.put("-1_-1_99_-1_44444", a4Params);
        factorMap2.put("-1_-1_99_-1_44444", null);
        String a5Strs = "{\"adClickPv\":8888,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":7.60399,\"expCntPv\":841,\"factor\":1.0,\"fee\":19814,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":7777,\"statEcpm\":5.81227,\"statEcpm2\":7.60399,\"statRatio\":0.95,\"targetConvertPv\":3333,\"theoryFee\":25922}";
        LandpageSubParams a5Params = (LandpageSubParams)JSON.parseObject((String)a5Strs, LandpageSubParams.class);
        factorMap2.put("-1_-1_-1_88_44444", a5Params);
        factorMap2.put("-1_-1_-1_88_44444", null);
        String a6Strs = "{\"adClickPv\":66666,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":11.96816,\"expCntPv\":154,\"factor\":1.0,\"fee\":5637,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":44444,\"statEcpm\":11.96816,\"statEcpm2\":0.0,\"statRatio\":0.95,\"targetConvertPv\":11111,\"theoryFee\":0}";
        LandpageSubParams a6Params = (LandpageSubParams)JSON.parseObject((String)a6Strs, LandpageSubParams.class);
        factorMap2.put("-1_-1_-1_-1_44444", a6Params);
        factorMap2.put("-1_-1_-1_-1_44444", null);
        String a41Strs = "{\"adClickPv\":100000,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":9.26115,\"expCntPv\":5232,\"factor\":1.0,\"fee\":190474,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":54330,\"statEcpm\":9.26115,\"statEcpm2\":9.16464,\"statRatio\":0.95,\"targetConvertPv\":38902,\"theoryFee\":188489}";
        LandpageSubParams a41Params = (LandpageSubParams)JSON.parseObject((String)a41Strs, LandpageSubParams.class);
        factorMap2.put("-1_-1_99_-1_-1", a41Params);
        factorMap2.put("-1_-1_99_-1_-1", null);
        String a51Strs = "{\"adClickPv\":200000,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":7.60399,\"expCntPv\":841,\"factor\":1.0,\"fee\":19814,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":68900,\"statEcpm\":5.81227,\"statEcpm2\":7.60399,\"statRatio\":0.95,\"targetConvertPv\":43200,\"theoryFee\":25922}";
        LandpageSubParams a51Params = (LandpageSubParams)JSON.parseObject((String)a51Strs, LandpageSubParams.class);
        factorMap2.put("-1_-1_-1_88_-1", a51Params);
        factorMap2.put("-1_-1_-1_88_-1", null);
        String a61Strs = "{\"adClickPv\":1000000,\"alpha\":0,\"beta\":0,\"conf\":false,\"ecpm\":11.96816,\"expCntPv\":154,\"factor\":1.0,\"fee\":5637,\"isConfidence\":true,\"isNew\":true,\"landpageClickPv\":678901,\"statEcpm\":11.96816,\"statEcpm2\":0.0,\"statRatio\":0.95,\"targetConvertPv\":487902,\"theoryFee\":0}";
        LandpageSubParams a61Params = (LandpageSubParams)JSON.parseObject((String)a61Strs, LandpageSubParams.class);
        factorMap2.put("-1_-1_-1_-1_-1", a61Params);
        factorMap2.put("-1_-1_-1_-1_-1", null);
        allParams.setFatorMap(factorMap2);
        AdBidResultDo Top1Advert = new AdBidResultDo();
        Top1Advert.setSlotId(99L);
        Top1Advert.setAdvertId(420615L);
        for (int i = 0; i < 10; ++i) {
            AdBidResultDo Ret = LandpageRcmder.rcmd(landpageRcmdReqList, null, null, null, Top1Advert, "88", featuremapdo);
            System.out.println("AdBidResultDo: " + JSON.toJSONString((Object)Ret));
            System.out.println("finish");
        }
    }

    static {
        actWhiteList.put(30942L, new ActivityInfo(30942L, 1L, null));
        actWhiteList.put(31143L, new ActivityInfo(31143L, 1L, "1"));
        actWhiteList.put(31346L, new ActivityInfo(31346L, 1L, "1"));
        actWhiteList.put(31144L, new ActivityInfo(31144L, 1L, "2"));
        actWhiteList.put(31145L, new ActivityInfo(31145L, 1L, "3"));
        actWhiteList.put(31146L, new ActivityInfo(31146L, 1L, "4"));
        actWhiteList.put(30828L, new ActivityInfo(30828L, 2L, null));
        actWhiteList.put(31184L, new ActivityInfo(31184L, 2L, "1"));
        actWhiteList.put(30998L, new ActivityInfo(30998L, 2L, "2"));
        actWhiteList.put(31101L, new ActivityInfo(31101L, 2L, "3"));
        actWhiteList.put(31307L, new ActivityInfo(31307L, 2L, "8"));
        actWhiteList.put(31308L, new ActivityInfo(31308L, 2L, "11"));
        actWhiteList.put(31183L, new ActivityInfo(31183L, 2L, "4"));
        actWhiteList.put(30222L, new ActivityInfo(30222L, 1L, null));
        slotWhiteList.put(417764L, new SlotInfo(417764L, 30942L, 1L));
        slotWhiteList.put(422622L, new SlotInfo(422622L, 30942L, 1L));
        slotWhiteList.put(404873L, new SlotInfo(404873L, 30828L, 2L));
        slotWhiteList.put(417855L, new SlotInfo(417855L, 30828L, 2L));
        slotWhiteList.put(423985L, new SlotInfo(423985L, 30222L, 1L));
        slotWhiteList.put(420877L, new SlotInfo(420877L, 30828L, 2L));
        slotWhiteList.put(404106L, new SlotInfo(404106L, 30828L, 2L));
    }
}

