package cn.com.duiba.nezha.alg.alg.landpage;

import cn.com.duiba.nezha.alg.api.model.E2ELocalTFModel;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import lombok.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Data
public class LandpgModel {

    private static final Logger logger = LoggerFactory.getLogger(LandpgModel.class);

    /**
     * 落地页优选推荐模型
     */
    // 无编码器预估模型
    private E2ELocalTFModel Model;

    // 编码器模型+预估模型
    private DeepModelV2 deepModelV2;
    private LocalTFModelV2 localTFModelV2;


    public <T> Map<T, Double> predict(Map<T, FeatureMapDo> featureMap) {

        try {
            Map<T, Double> ret;
            Map<T, Map<String, String>> modelInput = new HashMap<>();
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                modelInput.put(entry.getKey(), entry.getValue().getFeatureMap());
            }
            ret = Model.predict(modelInput);
            return ret;

        } catch (Exception e) {
            logger.error("LandpageRecommend.predictScore error{}, Model{}", e, Model);
        }
        return Collections.emptyMap();

    }
}
