package cn.com.duiba.nezha.alg.alg.vo.ee;

import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.Data;

@Data
public class AdControlParams {


    private Long advertId;
    private Long slotId;
    private String appGroup;


    private Boolean isColdStart;//是否冷启动
    /**
     * 探价参数
     */
    private Boolean isEE;//是否生效探价
    private Double eeFactor;//探价因子
    private Double eeRatio;//探价因子

    private Double eeFactor2;//探价因子2

    /**
     * 起量参数
     */
    private Boolean isQiliang;//是否生效起量
    private Double qlFactor;//起量因子


    /**
     *
     */

    private Double adAvgCPC;//计划cpc均价

    private Double slotAvgCPC;//广告位cpc均价

    private static double slotProtectProbs = 0.5;


    private String updateTime;


    public Double getExploreFactor() {

        Double ret = null;
        if (isEE != null && isEE && eeRatio != null && eeFactor != null && eeFactor2 != null) {
            if (Math.random() < eeRatio) {
                double factor = eeFactor * eeFactor2;
                factor = MathUtil.stdwithBoundary(factor, 1.0, 1.5);
                ret = factor;
            }
        }
        return ret;
    }


}
