package cn.com.duiba.nezha.alg.alg.landpage;

import cn.com.duiba.nezha.alg.alg.landpage.*;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.api.model.E2ELocalTFModel;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;

import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.SerializationUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 落地页推荐接口，工程系统推荐调用，只和该对象交互
 */
public class LandpageAlg {

    /**
     * 落地页推荐接口
     *
     * @param landpageRcmdReqList 落地页列表
     * @param Top1Advert           广告Map
     * @param landpgmodel            模型
     * @param landpageParams      算法控制参数,广告位
     * @return
     * @throws Exception
     */
    public static AdBidResultDo rcmd(List<LandpageRcmdReq> landpageRcmdReqList,
                                       AdBidResultDo Top1Advert,
                                       LandpgModel landpgmodel,
                                       LandpageParams landpageParams,
                                       LandpageParams allParams) throws Exception {

        /**
         * 基础信息获取
         */
        FeatureMapDo featuremap = Top1Advert.getFeaturemap();
        String appPkgTrade2 = null;
        if (featuremap.getStaticFeatureMap() != null) {
            appPkgTrade2 = featuremap.getStaticFeatureMap().get("ft300111"); //媒体包小类
        }

        Long slotId = Top1Advert.getSlotId(); //广告位id


        /**
         * 获取编码器、预估模型
         */

        DeepModelV2 deepModelV2 = landpgmodel.getDeepModelV2();
        LocalTFModelV2 localTFModelV2 = landpgmodel.getLocalTFModelV2();
        /**
         * 特征解析
         */
//        Map<Long, FeatureMapDo> featureMapDoMap = LandpageRcmder.getFeatureMap(landpageRcmdReqList, cf, staticCf);

        Map<Long, FeatureMapDo> featureMapDoMap = new HashMap<>();
        Map<Long, Double> preEcpmMap = null;
        for (LandpageRcmdReq landpgreq: landpageRcmdReqList) {
            Long landpgid = landpgreq.getLandpageId();
            Long frontpageid = landpgreq.getFrontpageId();
            Long paypageid = landpgreq.getPaypageId();
            Long formpageid = landpgreq.getFormpageId();
            Long modelid = landpgreq.getModelId();

            FeatureMapDo featuremapdo = new FeatureMapDo();
//            FeatureMapDo featuremapdo = featuremap.deepClone();
//            HashMap<String, String> dynamicfeaturemap = (HashMap<String, String>) featuremapdo.getDynamicFeatureMap();
//
//            HashMap<String, String> clone = SerializationUtils.clone(dynamicfeaturemap);

            Map<String, String> dynamicfeaturemap = new HashMap<>(featuremap.getDynamicFeatureMap());

//            Map<String, String> dynamicfeaturemap = featuremapdo.getDynamicFeatureMap();
            dynamicfeaturemap.put("ft200301", Optional.ofNullable(landpgid).map(Object::toString).orElse(""));
            dynamicfeaturemap.put("ft200302", Optional.ofNullable(frontpageid).map(Object::toString).orElse(""));
            dynamicfeaturemap.put("ft200303", Optional.ofNullable(paypageid).map(Object::toString).orElse(""));
            dynamicfeaturemap.put("ft200304", Optional.ofNullable(formpageid).map(Object::toString).orElse(""));
            dynamicfeaturemap.put("ft200305", Optional.ofNullable(modelid).map(Object::toString).orElse(""));
            featuremapdo.setDynamicFeatureMap(dynamicfeaturemap);
            featuremapdo.setStaticFeatureMap(featuremap.getStaticFeatureMap());

            featureMapDoMap.put(landpgid, featuremapdo);
        }

        /**
         * 模型预估, 返回Map<落地页ID, 预估分>
         */
        preEcpmMap = LandpageRcmder.predict(featureMapDoMap, deepModelV2, localTFModelV2);

        /**
         * 推荐, 返回Map<广告ID, 广告结果对象>
         */
        AdBidResultDo ret = LandpageRcmder.rcmd(landpageRcmdReqList, landpageParams, allParams, preEcpmMap, Top1Advert, appPkgTrade2, featureMapDoMap);


        return ret;
    }


    public static void main(String[] args) {

        try {
            run();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    public static void run() throws Exception {

        List<LandpageRcmdReq> landpageRcmdReqList = new ArrayList<>();

        for (int i = 1; i < 10; i++) {
            LandpageRcmdReq landpageRcmdReq = new LandpageRcmdReq();
            landpageRcmdReq.setLandpageId(100L + (long)i);
            landpageRcmdReq.setFrontpageId(null);
            landpageRcmdReq.setPaypageId(10000L + (long)i);
            landpageRcmdReq.setFormpageId(100000L + (long)i);
            landpageRcmdReq.setModelId(200L + (long)i);
            landpageRcmdReqList.add(landpageRcmdReq);
        }

        FeatureMapDo f3 = new FeatureMapDo();
        Map<String, String> dyn3 = new HashMap<>();
        Map<String, String> sta3 = new HashMap<>();
        sta3.put("langpageid","33333L");
        sta3.put("ft00009","1");
        dyn3.put("ft00010","2");
        dyn3.put("frontpage_id", "32333L");
        f3.setDynamicFeatureMap(dyn3);
        f3.setStaticFeatureMap(sta3);
        AdBidResultDo top1 = new AdBidResultDo();
        top1.setFeaturemap(f3);
        top1.setAdvertId(12345L);
        top1.setSlotId(2345L);

        System.out.println("time start=" + LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));

        long d1 = System.currentTimeMillis();
        for (int j = 0; j < 1000; j++) {
            LandpageAlg.rcmd(landpageRcmdReqList,
                    top1, null,null, null);
        }
        long d2 = System.currentTimeMillis();

        System.out.println("time end=" + LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        System.out.println("耗时：" + (d2 - d1) + " ms");
    }

    public static void run3() throws Exception {

        List<LandpageRcmdRet> landpageRcmdRetList = new ArrayList<>();
        LandpageRcmdRet r1 = new LandpageRcmdRet();
        r1.setLandpageId(1L);
        r1.setScore(1.0);

        landpageRcmdRetList.add(r1);

        LandpageRcmdRet r2 = new LandpageRcmdRet();
        r2.setLandpageId(0L);
        r2.setScore(2.0);

        landpageRcmdRetList.add(r2);

        landpageRcmdRetList = landpageRcmdRetList.stream()
                .sorted(Comparator.comparing(LandpageRcmdRet::getScore).reversed())
                .collect(Collectors.toList());

        System.out.println("activityRcmdRetList=" + JSON.toJSONString(landpageRcmdRetList));

    }

}
