package cn.com.duiba.nezha.alg.alg.landpage;

import cn.com.duiba.nezha.alg.alg.landpage.LandpageSubParams;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class LandpageParams {


    public Long advertId;
    public Map<String, LandpageSubParams> fatorMap = new HashMap<>();
//    public Double[] weight = {1.2, 2.0, 2.0, 1.0, 1.0, 1.0}; //理论表单转化pv融合权重 {0.15, 0.25, 0.25, 0.12, 0.12, 0.11}
    public Double[] weight = {2.0, 1.0};
    public LandpageSubParams getFactor(Long advertId, Long landpageId, Long slotId, String appPkgTrade2 ,Long frontpageId) {
        String key = advertId + "_" + landpageId + "_" + slotId + "_" + appPkgTrade2 + "_" + frontpageId;
        return fatorMap.get(key);
    }

    public LandpageSubParams getLandpageSubParams(Long advertId, Long landpageId, Long slotId, String appPkgTrade2 ,Long frontpageId) {
        String key = advertId + "_" + landpageId + "_" + slotId + "_" + appPkgTrade2 + "_" + frontpageId;
        if (!fatorMap.containsKey(key)) {
            fatorMap.put(key, new LandpageSubParams());
        }
        return fatorMap.get(key);
    }

}
