package cn.com.duiba.nezha.alg.alg.vo.advert;

import cn.com.duiba.nezha.alg.alg.correct.IsotonicCalibrator;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlSubModel;
import lombok.Data;

import java.util.Map;

@Data
public class AdBidInputDo {


    String key;//


    /**
     * 基础信息
     */
    Long newTradeTagId;//行业

    Long accountId;//计划ID  2022.3.1

    Long advertId;//计划ID

    Long packageId;//配置ID

    Long materialId;//素材ID


    Long appId;//媒体ID

    Long slotId;//广告位ID

    /**
     * 控制策略
     */
    Integer releaseTarget;  //1-稳定投放，2-抢量优先(中)， 3-抢量优先(高)， 4-人工定向， 5-成本优先


    /**
     * 计费 &目标类型
     */
    Integer chargeType; //是否ocpc，1：cpc、2：ocpc

    Integer cvrType;//ocpx 转化目标类型，目前支持：0、2、3（2020.09.10）

    Integer deepCvrType;//ocpx 深度转化目标类型，目前支持：8（2020.09.10）

    /**
     * 定向类型
     */

    Integer targeType; //人工定向、自动定向

    /**
     * 出价
     */

    Long fee;//cpc广告出价

    Long aFee;//ocpx 广告 转化目标出价（配置的）

    Long appAFee;//ocpx 广告 媒体 转化目标出价（******   新增 !!!! *******）

    Long deepFee;//深度目标成本（2020.11.12）


    Double dcvrLowerBound;// dcvr降价阈值 2023.10.31



    /**
     * 预估值
     */
    Double preCtr;// 预估ctr

    Double preCvr;// 预估cvr

    Double preDcvr;// 预估dcvr-- 2021.1.19

    Double ctr;// 融合ctr

    Double cvr;// 融合cvr

    Double dcvr;// 融合dcvr


    Double statCtr;// 统计ctr

    Double statCvr;// 统计cvr

    Double statDcvr;// 统计dcvr


    /**
     * 底价调节
     */
    Long reserveFee;//底价

    Boolean reservePriceWhite;//底价生效白名单，白名单内不触发

    /**
     * 策略因子,影响出价
     */

    Double specialAccountWeight;// 系统，特殊广告主调价权重，影响出价

    /**
     * 策略因子,影响排序（本接口不需要）
     */
//
     Double  specialAdvertWeight;// 系统，特殊广告计划调价权重，影响排序
//
     Double  discountWeight;// 系统，折扣权重，影响排序
//
     Double  supportWeight;// 算法，扶持调价权重，影响排序
//


    /**
     * 自动定向流量标识
     */

    Boolean isAutoTarget;// 是否自动定向流量

    /**
     * 是否新o测试白名单
     * null：无  1：无   2：是
     */
    Integer isNewOTest;// 是否新o测试白名单（null：无  1：无  2：是）2021.3.1


    /**
     * 是否冷启动测试白名单
     * null：无  1：无   2：是
     */
    Integer isColdTest;// 是否冷启动测试白名单（null：无  1：无  2：是）2021.3.1



    Integer deepControlType;// 双出价模式： null：无 0-白名单测试  1-保后端成本   2-保消耗  3-优化后端成本（适合转化延迟情况）

    Integer doubleMode; // 双出价模式，保前端还是后端之类

    Integer deepDelayType;// 双出价后端延迟类型： null：无  1：10分钟内   2：10分钟以上


    Integer bidControlType;// 是否跑量测试白名单， null：无  1：无   2：是


    /**
     * 探索流量加价
     */

    Double exploreFactor;//

    /**
     * 是否扶持
     */
    Boolean isSupport;

    /**
     * 成本控制参数
     */

    OcpxControlSubModel ocpxControlSubModel;// 12.3分拆独立

    //IsotonicCalibrator isotonicCalibrator;// 校准模型

    /**
     * 双出价白名单是否生效
     */

    Boolean deepAllEffect;

    /**
     * 延迟时间集合
     */
    Map<String, Double> convertDelayTime;


    /**
     * 是否限流媒体 1:限流媒体释放
     */

    Integer appLimitReleaseMark;

    /**
     * 是否开启提价保量模式（0=不开启，1=开启）
     */

    Integer priceRiseMark;


    /**
     * AB分流标识
     */

    Integer newOAbTestId;// AB1  新o测试AB分流 测试Id（1：默认组、2：实验组...）2021.3.1


    Integer coldAbTestId;// AB2 冷启动AB分流 测试Id（1：默认组、2：实验组...） 2021.3.1


    Integer abTestId;// AB3 双出价AB分流 测试Id（1：默认组、2：实验组...）

    Integer fastAbTestId;// AB5 跑量AB分流 测试Id（1：默认组、2：实验组...） 2021.2.22


    /**
     *
     */

    Integer eeAbTestId;// AB6 探价AB分流 测试Id（1：默认组、2：实验组...） 2022.2.16

    Integer upSpeedAbTestId;// AB6 探价AB分流 测试Id（1：默认组、2：实验组...） 2022.2.16



}