package cn.com.duiba.nezha.alg.alg.vo.adx.pd;

import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.*;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER2;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;


/**
 * 创意推荐入参对象
 */

@Data
public class AdxIdeaRcmdRequestDo implements Serializable {

    private static final long serialVersionUID = -8343027904367459748L;

    /**
     * 点击率预估模型
     */
    private FM fmModel;

    /**
     * 编码器模型
     */
    private CODER2 coderModel;

    /**
     * TF模型
     */
    private LocalTFModel ltfModel;

    /**
     * 更新的时候的模型，临时模型，用于预热
     */
    private LocalTFModel ltfModelTemp;

    /**
     * 可投放创意特征对象List（静态创意）
     *
     * 限定有效创意，拼接创意特征
     */
    private List<AdxIdeaFeatureDo> staticIdeaFeatureList;

    /**
     * 非创意特征对象(静态特征对象)
     */
    private AdxFeatureDo adxFeatureDo;

    /**
     * 可投放创意统计数据(key:创意id)
     */
    private Map<Long, AdxStatsDo> ideaStatsList;

    /**
     * 所属资源位统计数据
     */
    private AdxStatsDo resoStats;

    /**
     * 人工投放选择的创意id
     */
    private Long manualIdeaId;

    /**
     * 投放方式(0=依次, 1=比例, 2=算法1.0, 3=算法2.0，4=算法3.0(支持动态创意推荐))
     */
    private Integer putType;

    /**
     * 创意推荐定时任务结果
     */
    private AdxResourceRcmdDo adxResourceRcmdDo;

    /**
     * 模型融合收益
     */
    private Double mergeRpm;

    /**
     * 模型预估收益
     */
    private Double pRpm;

    /**
     * 统计收益
     */
    private Double sRpm;





    /**
     * 动态创意+素材特征对象List
     * n1个动态创意id，搭配n2个素材id，共n1*n2个元素
     */
    private List<AdxIdeaFeatureDo> dynamicIdeaFeatureList;

    /**
     * 素材召回集合
     */
    private AdxMaterialRecallDo materialRecallList;

    /**
     * 创意id+素材id，统计数据，近20min/当天（包含动态和静态）
     * key为创意id+素材id
     */
    private Map<AdxIdeaMaterialId, AdxStatsDo> ideaMaterialStatInfo;

    /**
     * 用户+资源位+素材，曝光、点击次数，当天
     * key为素材id
     */
    private Map<Long, AdxStatsDo> userResoMaterialStatInfo;

    /**
     * 资源位+素材，统计数据，近3天
     * key为素材id
     */
    private Map<Long, AdxStatsDo> resoMaterialStatInfo;



    /**
     * 创意+百度appId 统计数据(key:创意id)，近1h/当天/近3天
     */
    private Map<Long, AdxStatsDo> ideaAppStatsList;

    /**
     * 资源位+百度appId 统计数据，近1h/当天/近3天
     */
    private AdxStatsDo resoAppStats;

    /**
     * 人工素材ID列表
     */
    private List<Long> manualMaterialList;
}
