package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Data
public class EsModel {
    private static final String redisKeyPrefix = "NZ_XuXu"; // 该类的rediskey前缀
    private static final double lowerBound = 0.01;
    private static final double upperBound = 100.0;
    private String dim; // 计算模型所在的维度
    private String redisKey; // 存储该模型所用的rediskey
    private String updateTime; // 模型更新时间

    private double factor; // 模型产生的因子


    /**
     * 生成redisKey的方法
     *
     * @param ideaId 计划id
     * @param abId   实验id
     * @return 对应维度的模型redisKey
     */
    public static String getModelRedisKey(Long ideaId, Long abId) {
        String ideaIdStr = ideaId == null ? "" : ideaId.toString();
        String abIdStr = abId == null ? "" : abId.toString();
        return redisKeyPrefix + "_" + ideaIdStr + "_" + abIdStr;
    }

    public double calcFactor(double lastFactor) {
        if (factor > lowerBound && factor < upperBound) {
//            return lastFactor * factor;
            return factor; // 不与其他策略并行生效

        } else {
            log.error("The model which redis key is " + redisKey + " has illegal factor. ");
//            return lastFactor;
            return 1.0;
        }
    }

}
